<?php $__env->startSection('css_libraries'); ?>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">

                <div class="card-header d-flex justify-content-between align-items-center">
                    <?php echo __('admin.eggs'); ?>

                    <a href="<?php echo e(route('pterodactyl.clear_cache')); ?>" class="btn btn-info"
                       onclick="return confirm('<?php echo __('admin.clear_cache_desc'); ?>')">
                        <?php echo __('admin.clear_cache'); ?>

                    </a>
                </div>

                <div class="card-body">

                    <hr>
                    <table class="table">
                        <thead>
                        <tr>
                            <th><?php echo __('admin.name'); ?></th>
                            <th><?php echo __('admin.nest'); ?></th>
                            <th><?php echo __('admin.variables'); ?></th>
                            <th class="text-right"><?php echo __('admin.actions'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $eggs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $egg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($egg['name']); ?></td>
                                <td><?php echo e($egg['nest_name']); ?></td>
                                <td><?php echo e(count($egg['variables'])); ?></td>

                                <td class="text-right">
                                    <a class="btn btn-primary"
                                       href="<?php echo e(route('pterodactyl.egg_manage', ['egg' => $egg['id']])); ?>">
                                        <?php echo __('admin.manage'); ?>

                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.eggs.blade.php'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/app/Services/Pterodactyl/Resources/views/admin/default/eggs.blade.php ENDPATH**/ ?>