<?php $__env->startSection('css_libraries'); ?>
<link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>" />
<link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
<script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
<script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <section class="section">
        <div class="section-body">
            <div class="col-12">
                <?php if ($__env->exists(AdminTheme::path('users.user_nav'))) echo $__env->make(AdminTheme::path('users.user_nav'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>

        <div class="col-12">
            <div class="">
                <div class="card">
                    <div class="card-header">
                        <h4><?php echo __('admin.punishments'); ?></h4>
                        <div class="card-header-action">
                            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#banModal" class="btn btn-icon icon-left btn-primary"><i class="fas fa-solid fa-plus"></i>
                                <?php echo __('admin.create'); ?>

                            </button>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-striped table-md">
                                <tbody>
                                <tr>
                                    <th><?php echo __('admin.id'); ?></th>
                                    <th><?php echo __('admin.user'); ?></th>
                                    <th><?php echo __('admin.staff'); ?></th>
                                    <th><?php echo __('admin.type'); ?></th>
                                    <th><?php echo __('admin.reason'); ?></th>
                                    <th><?php echo __('admin.create_at'); ?></th>
                                    <th class="text-right"><?php echo __('admin.actions'); ?></th>
                                </tr>

                                <?php $__currentLoopData = $punishments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $punishment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($punishment->id); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('users.edit', ['user' => $punishment->user->id])); ?>"
                                               style="display: flex; color: #6c757d">
                                                <img alt="image" src="<?php echo e($punishment->user->avatar()); ?>"
                                                     class="rounded-circle mr-1 mt-1" width="32px" height="32px"
                                                     data-toggle="tooltip" title=""
                                                     data-original-title="<?php echo e($punishment->user->first_name); ?> <?php echo e($punishment->user->last_name); ?>">
                                                <div class="flex">
                                                    <?php echo e($punishment->user->username); ?> <br>
                                                    <small><?php echo e($punishment->user->email); ?></small>
                                                </div>
                                            </a>
                                        </td>
                                        <td>
                                            <?php if(isset($punishment->staff)): ?>
                                            <a href="<?php echo e(route('users.edit', ['user' => $punishment->staff->id])); ?>"
                                               style="display: flex; color: #6c757d">
                                                <img alt="image" src="<?php echo e($punishment->staff->avatar()); ?>"
                                                     class="rounded-circle mr-1 mt-1" width="32px" height="32px"
                                                     data-toggle="tooltip" title=""
                                                     data-original-title="<?php echo e($punishment->staff->first_name); ?> <?php echo e($punishment->staff->last_name); ?>">
                                                <div class="flex">
                                                    <?php echo e($punishment->staff->username); ?> <br>
                                                    <small><?php echo e($punishment->staff->email); ?></small>
                                                </div>
                                            </a>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="flex align-items-center">
                                                <i class="fas fa-solid fa-circle
                                                <?php if(in_array($punishment->type, ['ban', 'ipban'])): ?> text-danger <?php else: ?> text-warning <?php endif; ?>"
                                                   style="font-size: 11px;"></i> <?php echo e(ucfirst($punishment->type)); ?>

                                            </div>
                                        </td>
                                        <td>
                                            <?php echo e($punishment->reason); ?>

                                        </td>
                                        <td>
                                            <?php echo __('admin.created'); ?>: <?php echo e($punishment->created_at->translatedFormat(settings('date_format', 'd M Y'))); ?>

                                            <br>
                                            <?php echo __('admin.expires_in'); ?>: <?php if(isset($punishment->expires_at)): ?> <?php echo e($punishment->expires_at->translatedFormat(settings('date_format', 'd M Y'))); ?> <?php else: ?> <?php echo e(__('admin.never')); ?> <?php endif; ?>
                                            <br>
                                        </td>
                                        <td class="text-right">
                                            <?php if(in_array($punishment->type, ['ban', 'ipban'])): ?>
                                                <a href="<?php echo e(route('admin.bans.unban', $punishment->id)); ?>" class="btn btn-warning"><?php echo e(__('admin.unban')); ?></a>
                                            <?php endif; ?>
                                            <a href="<?php echo e(route('admin.bans.destroy', $punishment->id)); ?>" class="btn btn-danger"><i class="fas fa-solid fa-trash"></i></a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer text-right">
                      <?php echo e($punishments->links(AdminTheme::pagination())); ?>

                    </div>
                </div>
            </div>
        </div>
    </section>

<!-- Modal -->
<div class="modal fade" id="banModal" tabindex="-1" role="dialog" aria-labelledby="banModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="banModalLabel"><?php echo e(__('admin.punish')); ?> <?php echo e($user->username); ?></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('admin.close')); ?>">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="<?php echo e(route('admin.user.punishments.create', $user->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-body">
                <div class="form-group">
                    <label for="type"><?php echo e(__('admin.type')); ?></label>
                    <div class="input-group mb-2">
                        <select name="type" id="type" class="form-control select2 select2-hidden-accessible"
                                tabindex="-1" aria-hidden="true" onchange="toggleType()">
                                <option value="warning" <?php if(false): ?> selected <?php endif; ?>><?php echo e(__('admin.warning')); ?></option>
                                <option value="ban" <?php if(false): ?> selected <?php endif; ?>><?php echo e(__('admin.ban')); ?></option>
                                <option value="ipban" <?php if(false): ?> selected <?php endif; ?>><?php echo e(__('admin.ip_ban')); ?></option>
                        </select>
                        <small class="form-text text-muted"></small>
                    </div>
                </div>

                <div class="form-group" style="display: none;" id="ip_address">
                    <label><?php echo e(__('admin.ip_address')); ?></label>
                    <input type="text" class="form-control" name="ip_address" value="<?php if($user->ips()->exists()): ?><?php echo e($user->ips()->orderBy('uses', 'desc')->first()->ip_address); ?><?php endif; ?>"/>
                    <small class="mt-1"><?php echo e(__('admin.the_ip_address_is_automatically_retrieved_by_check')); ?></small>
                </div>

                <div class="form-group">
                    <label><?php echo e(__('admin.reason_optional')); ?></label>
                    <textarea type="text" class="form-control" name="reason" value=""></textarea>
                </div>

                <div class="form-group">
                    <label><?php echo e(__('admin.expires_at_optional')); ?></label>
                    <input type="date" class="form-control" name="expires_at" value=""/>
                </div>
            </div>
            <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('admin.close')); ?></button>
            <button type="submit" class="btn btn-primary"><?php echo e(__('admin.save_changes')); ?></button>
            </div>
        </form>
      </div>
    </div>
  </div>

  <script>
    function toggleType() {
        if(document.getElementById("type").value == 'ipban') {
            document.getElementById("ip_address").style.display = 'unset';
        } else {
            document.getElementById("ip_address").style.display = 'none';
        }
    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.punishments'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/users/punishments.blade.php ENDPATH**/ ?>