<?php $__env->startSection('css_libraries'); ?>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card mb-6">
                <div class="card-body">
                    <ul class="nav nav-pills">
                        <li class="nav-item">
                            <a class="nav-link <?php if(request()->input('severity', 'CRITICAL') == 'CRITICAL'): ?> active <?php endif; ?>"
                               href="<?php echo e(route('logs.index', ['severity' => 'CRITICAL'])); ?>"><?php echo __('admin.critical'); ?>

                                <span
                                    class="badge <?php if(request()->input('severity', 'CRITICAL') == 'CRITICAL'): ?> badge-white <?php else: ?> badge-primary <?php endif; ?> ">
                                    <?php echo e(ErrorLog::where('severity', 'CRITICAL')->count()); ?></span></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php if(request()->input('severity') == 'ERROR'): ?> active <?php endif; ?>"
                               href="<?php echo e(route('logs.index', ['severity' => 'ERROR'])); ?>"><?php echo __('admin.error'); ?> <span
                                    class="badge  badge-primary <?php if(request()->input('severity') == 'ERROR'): ?> badge-white <?php else: ?> badge-primary <?php endif; ?> ">
                                    <?php echo e(ErrorLog::where('severity', 'ERROR')->count()); ?></span></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php if(request()->input('severity') == 'WARNING'): ?> active <?php endif; ?>"
                               href="<?php echo e(route('logs.index', ['severity' => 'WARNING'])); ?>"><?php echo __('admin.warning'); ?>

                                <span
                                    class="badge  <?php if(request()->input('severity') == 'WARNING'): ?> badge-white <?php else: ?> badge-primary <?php endif; ?>">
                                    <?php echo e(ErrorLog::where('severity', 'WARNING')->count()); ?></span></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php if(request()->input('severity') == 'INFO'): ?> active <?php endif; ?>"
                               href="<?php echo e(route('logs.index', ['severity' => 'INFO'])); ?>"><?php echo __('admin.info'); ?> <span
                                    class="badge  <?php if(request()->input('severity') == 'INFO'): ?> badge-white <?php else: ?> badge-primary <?php endif; ?> ">
                                    <?php echo e(ErrorLog::where('severity', 'INFO')->count()); ?></span></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php if(request()->input('severity') == 'RESOLVED'): ?> active <?php endif; ?>"
                               href="<?php echo e(route('logs.index', ['severity' => 'RESOLVED'])); ?>"><?php echo __('admin.resolved'); ?>

                                <span
                                    class="badge  <?php if(request()->input('severity') == 'RESOLVED'): ?> badge-white <?php else: ?> badge-primary <?php endif; ?> ">
                                    <?php echo e(ErrorLog::where('severity', 'RESOLVED')->count()); ?></span></a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <?php if(ErrorLog::count() == 0): ?>
                        <?php echo $__env->make(AdminTheme::path('empty-state'), ['title' => 'We couldn\'t find any logs', 'description' => 'New logs will appear here'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <table class="table">
                            <thead>
                            <tr>
                                <th><?php echo __('admin.severity'); ?></th>
                                <th><?php echo __('admin.source'); ?></th>
                                <th><?php echo __('admin.message'); ?></th>
                                <th><?php echo __('admin.date'); ?></th>
                                <th class="text-right"><?php echo __('admin.actions'); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><span class="badge badge-secondary"><?php echo e($log->severity); ?></span></td>
                                    <td><?php echo e($log->source); ?></td>
                                    <td>
                                        <?php echo Str::limit($log->message, 50); ?>

                                        <div class="modal fade" id="logModal<?php echo e($log->id); ?>" tabindex="-1" role="dialog"
                                             aria-labelledby="logModalLabel<?php echo e($log->id); ?>" aria-hidden="true">
                                            <div class="modal-dialog modal-lg" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="logModalLabel<?php echo e($log->id); ?>">
                                                            <?php echo e($log->source); ?>

                                                        </h4>
                                                        <button type="button" class="close" data-dismiss="modal"
                                                                aria-label="<?php echo e(__('admin.close')); ?>">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>

                                                    <div class="modal-body">
                                                        <strong> <?php echo nl2br($log->message); ?> </strong>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary"
                                                                data-dismiss="modal"><?php echo __('admin.close'); ?>

                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?php echo e($log->created_at->format('d M Y')); ?> (<?php echo e($log->created_at->diffForHumans()); ?>)</td>
                                    <td class="text-right">
                                        <button type="button" class="btn btn-primary" data-toggle="modal"
                                                data-target="#logModal<?php echo e($log->id); ?>">
                                            <?php echo __('admin.view'); ?>

                                        </button>
                                        <button type="button"
                                                class="btn btn-primary"><?php echo __('admin.resolve'); ?></button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            </tbody>
                        </table>
                        <?php echo e($logs->links(AdminTheme::pagination())); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.logs'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/logs.blade.php ENDPATH**/ ?>