<?php if(node()::get()->count() <= 0): ?>
    <div class="alert alert-danger" role="alert">
        <h4 class="alert-heading"><?php echo __('admin.warn'); ?></h4>
        <p><?php echo __('admin.pterodactyl_node_warn'); ?></p>
        <hr>
        <p class="mb-0"><?php echo __('admin.co_to_configure'); ?>  <a class="btn btn-warning" href="<?php echo e(route('pterodactyl.nodes')); ?>"><?php echo __('admin.nodes'); ?></a></p>
    </div>
<?php endif; ?>


<form action="<?php echo e(route('package_update', ['package' => $package->id])); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <div class="row">
        <div class="form-group col-4">
            <label for="database_limit"><?php echo __('admin.database_limit'); ?></label>
            <div class="input-group mb-2">
                <input type="number" class="form-control text-right" name="database_limit" id="database_limit"
                       min="0"
                       value="<?php echo e($package->data('database_limit')); ?>" required/>
                <div class="input-group-append">
                    <div class="input-group-text"><i class="fas fa-solid fa-database"></i></div>
                </div>
                <small class="form-text text-muted">
                    <?php echo __('admin.database_limit_desc'); ?>

                </small>
            </div>
        </div>

        <div class="form-group col-4">
            <label for="allocation_limit"><?php echo __('admin.allocation_limit'); ?></label>
            <div class="input-group mb-2">
                <input type="number" class="form-control text-right" name="allocation_limit" id="allocation_limit"
                       min="0"
                       value="<?php echo e($package->data('allocation_limit')); ?>"
                       required/>
                <div class="input-group-append">
                    <div class="input-group-text"><i class="fas fa-solid fa-network-wired"></i></div>
                </div>
                <small class="form-text text-muted">
                    <?php echo __('admin.allocation_limit_desc'); ?>

                </small>
            </div>
        </div>

        <div class="form-group col-4">
            <label for="backup_limit"><?php echo __('admin.backup_limit'); ?></label>
            <div class="input-group mb-2">
                <input type="number" class="form-control text-right" name="backup_limit" id="backup_limit"
                       min="0" value="<?php echo e($package->data('backup_limit')); ?>"
                       required/>
                <div class="input-group-append">
                    <div class="input-group-text"><i class="fas fa-solid fa-download"></i></div>
                </div>
                <small class="form-text text-muted">
                    <?php echo __('admin.backup_limit_desc'); ?>

                </small>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="form-group col-4">
            <label for="cpu_limit"><?php echo __('admin.cpu_limit'); ?></label>
            <div class="input-group mb-2">
                <input type="number" class="form-control text-right" name="cpu_limit" id="cpu_limit" min="0"
                       value="<?php echo e($package->data('cpu_limit')); ?>" required/>
                <div class="input-group-append">
                    <div class="input-group-text">%</div>
                </div>
                <small class="form-text text-muted">
                    <?php echo __('admin.cpu_limit_desc'); ?>

                </small>
            </div>
        </div>

        <div class="form-group col-4">
            <label for="memory_limit"><?php echo __('admin.memory'); ?></label>
            <div class="input-group mb-2">
                <input type="number" class="form-control text-right" name="memory_limit" id="memory_limit"
                       min="0" value="<?php echo e($package->data('memory_limit')); ?>"
                       required/>
                <div class="input-group-append">
                    <div class="input-group-text">MB</div>
                </div>
                <small class="form-text text-muted">
                    <?php echo __('admin.memory_desc'); ?>

                </small>
            </div>
        </div>

        <div class="form-group col-4">
            <label for="disk_limit"><?php echo __('admin.disk'); ?></label>
            <div class="input-group mb-2">
                <input type="number" class="form-control text-right" name="disk_limit" id="disk_limit"
                       min="0" value="<?php echo e($package->data('disk_limit')); ?>"
                       required/>
                <div class="input-group-append">
                    <div class="input-group-text">MB</div>
                </div>
                <small class="form-text text-muted">
                    <?php echo __('admin.disk_desc'); ?>

                </small>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="form-group col-4">
            <label for="cpu_pinning"><?php echo __('admin.cpu_pinning'); ?> <?php echo __('admin.optional'); ?></label>
            <div class="input-group mb-2">
                <input type="text" class="form-control text-right"
                       value="<?php echo e($package->data('cpu_pinning')); ?>"
                       name="cpu_pinning" id="cpu_pinning"/>
                <small class="form-text text-muted">
                    <?php echo __('admin.cpu_pinning_desc'); ?>

                </small>
            </div>
        </div>

        <div class="form-group col-4">
            <label for="swap_limit"><?php echo __('admin.swap'); ?></label>
            <div class="input-group mb-2">
                <input type="number" class="form-control text-right" name="swap_limit" id="swap_limit"
                       value="<?php echo e($package->data('swap_limit', 0)); ?>"
                       required/>
                <div class="input-group-append">
                    <div class="input-group-text">MB</div>
                </div>
                <small class="form-text text-muted">
                    <?php echo __('admin.swap_desc'); ?>

                </small>
            </div>
        </div>

        <div class="form-group col-4">
            <label for="block_io_weight"><?php echo __('admin.block_io_weight'); ?></label>
            <div class="input-group mb-2">
                <input type="number" class="form-control text-right" name="block_io_weight" id="block_io_weight"
                       value="<?php echo e($package->data('block_io_weight', 500)); ?>"
                       required/>
                <small class="form-text text-muted">
                    <?php echo __('admin.block_io_weight_desc'); ?>

                </small>
            </div>
        </div>

        <div class="form-group col-4">
            <label for="block_io_weight"><?php echo __('admin.enable_oom_killer'); ?></label>
            <div class="input-group mb-2">
                <div class="custom-control custom-checkbox">
                    <input type="checkbox" class="custom-control-input" name="OOM_KILLER" id="customCheck1"
                           value="1" <?php if($package->data('OOM_KILLER', false)): ?> checked <?php endif; ?>/>
                    <label class="custom-control-label" for="customCheck1">
                        <?php echo __('admin.enable_oom_killer_desc'); ?>

                    </label>
                </div>
            </div>
        </div>
    </div>

    <hr>
    <div class="row">
        <div class="form-group col-6">
            <label for="location"><?php echo __('admin.allowed_locations'); ?></label>
            <div class="input-group mb-2">
                <select name="locations[]" id="location" class="form-control select2 select2-hidden-accessible"
                        multiple="" tabindex="-1" aria-hidden="true">
                    <?php $__currentLoopData = PterodactylLocation::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($location->id); ?>"
                                <?php if(in_array($location->id, $package->data('locations', []))): ?> selected <?php endif; ?>><?php echo e($location->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <small class="form-text text-muted"><?php echo __('admin.allowed_locations_desc'); ?></small>
            </div>
        </div>

        <div class="form-group col-6">
            <label for="egg"><?php echo __('admin.egg'); ?></label>
            <div class="input-group mb-2">
                <select name="egg" id="egg" class="form-control select2 select2-hidden-accessible"
                        tabindex="-1" aria-hidden="true" onchange="setEgg()">
                    <?php $__currentLoopData = Pterodactyl::getEggs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $egg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e(json_encode($egg['attributes'])); ?>"
                                <?php if($package->data('egg', false) AND json_decode($package->data('egg'))->id == $egg['attributes']['id']): ?> selected <?php endif; ?>><?php echo e($egg['attributes']['name']); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <small class="form-text text-muted"><?php echo __('admin.egg_desc'); ?></small>
            </div>
        </div>
    </div>

    <div class="row">
        <?php if(json_decode($package->data('egg')) !== NULL): ?>

            <div class="form-group col-6">
                <label for="docker_image"><?php echo __('admin.docker_image'); ?></label>
                <div class="input-group mb-2">
                    <div class="input-group-append">
                        <div class="input-group-text" type="button" id="dropdownMenuButton" data-toggle="dropdown"
                             aria-haspopup="true" aria-expanded="false" style="cursor: pointer"><i
                                class="fas fa-chevron-circle-down"></i></div>
                        <div class="dropdown-menu" x-placement="bottom-start"
                             style="position: absolute; transform: translate3d(0px, 28px, 0px); top: 0px; left: 0px; will-change: transform;">
                            <?php $__currentLoopData = json_decode($package->data('egg'))->docker_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <button type="button" class="dropdown-item" style="cursor: pointer"
                                        onclick="document.getElementById('docker_image').value = '<?php echo e($image); ?>';"><?php echo e($key); ?></button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <input type="text" class="form-control text-left" name="docker_image" id="docker_image"
                           value="<?php echo e($package->data('docker_image', json_decode($package->data('egg'))->docker_image )); ?>"
                    />
                    <small class="form-text text-muted">
                        <?php echo __('admin.docker_image_desc'); ?>

                    </small>
                </div>
            </div>

            <div class="form-group col-6">
                <label for="excluded_variables[]"><?php echo __('admin.exclude_variables_checkout'); ?></label>
                <div class="input-group mb-2">
                    <select name="excluded_variables[]" id="excluded_variables[]"
                            class="form-control select2 select2-hidden-accessible"
                            multiple="" tabindex="-1" aria-hidden="true">
                        <?php $__currentLoopData = json_decode($package->data('egg'))->relationships->variables->data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($variable->attributes->user_editable AND $variable->attributes->user_viewable): ?>
                                <option value="<?php echo e($variable->attributes->env_variable); ?>"
                                        <?php if(in_array($variable->attributes->env_variable, $package->data('excluded_variables', []))): ?> selected <?php endif; ?>><?php echo e($variable->attributes->name); ?></option>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <small class="form-text text-muted"><?php echo __('admin.exclude_variables_checkout_desc'); ?></small>
                </div>
            </div>

            <div class="form-group col-12">
                <label><?php echo __('admin.startup_command'); ?></label>
                <input type="text" class="form-control" id="startup"
                       value="<?php echo e($package->data('startup', json_decode($package->data('egg'))->startup )); ?>"
                       name="startup">
                <small class="form-text text-muted">
                    <?php echo __('admin.startup_command_desc'); ?>

                </small>
            </div>

            <div class="col-12">
                <hr>
            </div>

            <?php $__currentLoopData = json_decode($package->data('egg'))->relationships->variables->data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="form-group col-6">
                    <label><?php echo e($variable->attributes->name); ?></label>
                    <input type="text" class="form-control"
                           value="<?php if(isset($package->data('environment')[$variable->attributes->env_variable])): ?><?php echo e($package->data('environment')[$variable->attributes->env_variable]); ?><?php else: ?><?php echo e($variable->attributes->default_value); ?><?php endif; ?>"
                           name="environment[<?php echo e($variable->attributes->env_variable); ?>]" <?php if(Str::contains($variable->attributes->rules, 'required')): ?> <?php endif; ?>>
                    <small class="form-text text-muted">
                        <?php echo e($variable->attributes->description); ?> <br><br>
                        <strong><?php echo __('admin.access_in_startup'); ?>:</strong><code> &#123;&#123;<?php echo e($variable->attributes->env_variable); ?>

                            &#125;&#125;</code><br>
                        <strong><?php echo __('admin.validation_rules'); ?></strong><code> <?php echo e($variable->attributes->rules); ?></code>
                    </small>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </div>

    <div class="text-right">
        <button class="btn btn-dark" id="submit" type="submit"><?php echo __('admin.update'); ?></button>
    </div>
</form>


<script>
    function setEgg() {

        if (document.getElementById("docker_image")) {
            document.getElementById("docker_image").value = '';
        }

        if (document.getElementById("startup")) {
            document.getElementById("startup").value = '';
        }

        var button = document.getElementById("submit");
        button.click();
    }

</script>
<?php /**PATH /var/www/wemx/app/Services/Pterodactyl/Resources/views/admin/default/params.blade.php ENDPATH**/ ?>