<?php $__env->startSection('content'); ?>
<div>
    <!-- Button trigger modal -->
    <button type="button" class="btn btn-primary mt-4 mb-4" data-toggle="modal"
            data-target="#createEmail">
        <?php echo e(__('admin.create')); ?>

    </button>

    <div class="alert alert-info alert-dismissible fade show" role="alert">
        WemX already sends a set of emails when an order is cancelled, suspended or terminated.
        You can configure them <a target="_blank"
                                  href="/admin/emails/messages"><strong>here</strong></a>
        - This page provides you more customibility to send package specific emails.
        <button type="button" class="close" data-dismiss="alert" aria-label="<?php echo e(__('admin.close')); ?>">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>

    <?php if(PackageEmail::where('package_id', $package->id)->count() == 0): ?>
        <?php echo $__env->make(AdminTheme::path('empty-state'), [
            'title' => 'No emails found',
            'description' => 'You haven\'t created any emails for this package',
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <!-- Create Email Modal -->
    <div class="modal fade bd-example-modal-lg" id="createEmail" tabindex="-1" role="dialog"
         aria-labelledby="createEmailLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="createEmailLabel"><?php echo e(__('admin.email_event')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('admin.close')); ?>">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('packages.emails.create', $package->id)); ?>" method="POST"
                      enctype="multipart/form-data">
                    <div class="modal-body">
                        <?php echo csrf_field(); ?>
                        <div class="mb-4">
                            <label for="event"><?php echo e(__('admin.event')); ?></label>
                            <select class="form-control select2 select2-hidden-accessible"
                                    name="event"
                                    tabindex="-1" aria-hidden="true">
                                <option value="creation">
                                    <?php echo e(__('admin.creation')); ?>

                                </option>
                                <option value="renewal">
                                    <?php echo e(__('admin.renewal')); ?>

                                </option>
                                <option value="upgrade">
                                    <?php echo e(__('admin.upgrade')); ?>

                                </option>
                                <option value="suspension">
                                    <?php echo e(__('admin.suspension')); ?>

                                </option>
                                <option value="unsuspension">
                                    <?php echo e(__('admin.unsuspension')); ?>

                                </option>
                                <option value="cancellation">
                                    <?php echo e(__('admin.cancellation')); ?>

                                </option>
                                <option value="termination">
                                    <?php echo e(__('admin.termination')); ?>

                                </option>
                            </select>
                        </div>

                        <div class="mb-4">
                            <label for="title"><?php echo e(__('admin.email_title')); ?></label>
                            <input type="text" name="title" id="title" placeholder="<?php echo e(__('admin.subject')); ?>"
                                   class="form-control" required=""/>
                        </div>

                        <div class="">
                            <label for="body"><?php echo e(__('admin.email_body')); ?></label>
                            <textarea class="form-control" name="body" id="body"></textarea>
                            <small class="form-text text-muted"></small>
                        </div>

                        <div class="form-group" style="display: flex;flex-direction: column;">
                            <label for="myfile"><?php echo e(__('admin.select_a_file_optional')); ?></label>
                            <input class="" type="file" id="myfile" name="attachment">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">
                            <?php echo e(__('admin.close')); ?>

                        </button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('admin.create')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-striped table-md">
                <tbody>
                <?php if($package->emails->count() > 0): ?>
                    <tr>
                        <th><?php echo e(__('admin.event')); ?></th>
                        <th><?php echo e(__('admin.title')); ?></th>
                        <th class="text-right"><?php echo e(__('admin.last_updated')); ?></th>
                        <th class="text-right"><?php echo e(__('admin.action')); ?></th>
                    </tr>
                <?php endif; ?>
                <?php $__currentLoopData = $package->emails->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $email): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($email->event); ?></td>
                        <td><?php echo e($email->title); ?></td>
                        <td class="text-right"><?php echo e($email->updated_at->diffForHumans()); ?></td>
                        <td class="text-right">
                            <a href="<?php echo e(route('packages.emails.delete', ['email' => $email->id])); ?>"
                               class="btn btn-icon btn-danger"><i class="fas fa-trash-alt"></i></a>
                            <button data-toggle="modal" data-target="#editEmail<?php echo e($email->id); ?>"
                                    class="btn btn-primary"><?php echo e(__('admin.manage')); ?>

                            </button>
                        </td>
                    </tr>

                    <!-- Create Email Modal -->
                    <div class="modal fade bd-example-modal-lg" id="editEmail<?php echo e($email->id); ?>"
                         tabindex="-1" role="dialog"
                         aria-labelledby="editEmail<?php echo e($email->id); ?>Label" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editEmail<?php echo e($email->id); ?>Label">
                                        <?php echo e(__('admin.email_event')); ?></h5>
                                    <button type="button" class="close" data-dismiss="modal"
                                            aria-label="<?php echo e(__('admin.close')); ?>">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <form
                                    action="<?php echo e(route('packages.emails.update', ['email' => $email->id])); ?>"
                                    method="POST" enctype="multipart/form-data">
                                    <div class="modal-body">
                                        <?php echo csrf_field(); ?>
                                        <div class="mb-4">
                                            <label for="event"><?php echo e(__('admin.event')); ?></label>
                                            <select
                                                class="form-control select2 select2-hidden-accessible"
                                                name="event"
                                                tabindex="-1" aria-hidden="true">
                                                <option value="creation"
                                                        <?php if($email->event == 'creation'): ?> selected <?php endif; ?>>
                                                    <?php echo e(__('admin.creation')); ?>

                                                </option>
                                                <option value="renewal"
                                                        <?php if($email->event == 'renewal'): ?> selected <?php endif; ?>>
                                                    <?php echo e(__('admin.renewal')); ?>

                                                </option>
                                                <option value="upgrade"
                                                        <?php if($email->event == 'upgrade'): ?> selected <?php endif; ?>>
                                                    <?php echo e(__('admin.upgrade')); ?>

                                                </option>
                                                <option value="suspension"
                                                        <?php if($email->event == 'suspension'): ?> selected <?php endif; ?>>
                                                    <?php echo e(__('admin.suspension')); ?>

                                                </option>
                                                <option value="unsuspension"
                                                        <?php if($email->event == 'unsuspension'): ?> selected <?php endif; ?>>
                                                    <?php echo e(__('admin.unsuspension')); ?>

                                                </option>
                                                <option value="cancellation"
                                                        <?php if($email->event == 'cancellation'): ?> selected <?php endif; ?>>
                                                    <?php echo e(__('admin.cancellation')); ?>

                                                </option>
                                                <option value="termination"
                                                        <?php if($email->event == 'termination'): ?> selected <?php endif; ?>>
                                                    <?php echo e(__('admin.termination')); ?>

                                                </option>
                                            </select>
                                        </div>

                                        <div class="mb-4">
                                            <label for="title"><?php echo e(__('admin.email_title')); ?></label>
                                            <input type="text" name="title" id="title"
                                                   value="<?php echo e($email->title); ?>"
                                                   placeholder="<?php echo e(__('admin.subject')); ?>"
                                                   class="form-control" required=""/>
                                        </div>

                                        <div class="">
                                            <label for="body"><?php echo e(__('admin.email_body')); ?></label>
                                            <textarea class="form-control" name="body" id="body"><?php echo $email->body; ?></textarea>
                                            <small class="form-text text-muted"></small>
                                        </div>

                                        <div class="form-group"
                                             style="display: flex;flex-direction: column;">
                                            <label for="myfile"><?php echo e(__('admin.select_a_file_optional')); ?></label>
                                            <input class="" type="file" id="myfile"
                                                   name="attachment">
                                        </div>

                                        <?php if($email->attachment): ?>
                                            <span
                                                class="badge badge-pill badge-secondary"><?php echo e(basename($email->attachment)); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary"
                                                data-dismiss="modal"><?php echo e(__('admin.close')); ?>

                                        </button>
                                        <button type="submit" class="btn btn-primary"><?php echo e(__('admin.update')); ?>

                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make(AdminTheme::path('packages/edit/master'), ['title' => 'Package Emails', 'tab' => 'emails'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/packages/edit/emails.blade.php ENDPATH**/ ?>