<?php $__env->startSection('content'); ?>
<div>
    <form action="<?php echo e(route('package.create-feature', $package->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="form-group col-md-3 col-6" data-toggle="modal" data-target="#IconModal">
                <label for="name"><?php echo e(__('admin.icon')); ?></label>
                <input type="text" name="icon" id="feature-icon" placeholder=""
                       class="form-control" value="" required=""/>
            </div>
            <div class="form-group col-md-3 col-6">
                <label for="icon"><?php echo e(__('admin.color')); ?></label>
                <select class="form-control select2 select2-hidden-accessible"
                        name="color" id="color" tabindex="-1" aria-hidden="true">
                    <?php $__currentLoopData = config('utils.colors'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($color); ?>"><?php echo e($color); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="form-group col-md-6 col-12">
                <label for="description"><?php echo e(__('admin.description')); ?></label>
                <input type="text" name="description" id="description" placeholder=""
                       class="form-control" value="" required=""/>
            </div>
        </div>
        <div class="text-right">
            <button class="btn btn-primary" type="submit"><?php echo e(__('admin.add_feature')); ?></button>
        </div>
    </form>
    <!-- Modal -->
    <div class="modal fade" id="IconModal" tabindex="-1" role="dialog"
         aria-labelledby="IconModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"
                        id="IconModalLabel"><?php echo e(__('admin.select_icon')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('admin.close')); ?>">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <?php $__currentLoopData = config('utils.icons'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $icon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-1 mb-4">
                                <div class="bx-md d-flex justify-content-center"
                                     style="cursor: pointer;" onclick='setIcon("<?php echo e($icon); ?>")'>
                                    <?php echo $icon; ?>

                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <div class="form-group col-md-12 col-12">
                            <label for="description"><?php echo e(__('admin.icon_font')); ?></label>
                            <input type="text" name="description" id="custom-icon"
                                   value="<i class='bx bxs-check-shield' ></i>"
                                   class="form-control" value="" required=""/>
                            <small><?php echo __('admin.custom_icons_on_boxicons_choose_icon'); ?></small>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary"
                            data-dismiss="modal"><?php echo e(__('admin.close')); ?></button>
                    <button type="button" onclick="setFeatureIcon()" class="btn btn-primary"
                            data-dismiss="modal"><?php echo e(__('admin.use_icon')); ?></button>
                </div>
            </div>
        </div>
    </div>
    <hr>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-striped" id="sortable-table">
                <thead>
                <tr>
                    <th><?php echo e(__('admin.icon')); ?></th>
                    <th><?php echo e(__('admin.feature')); ?></th>
                    <th><?php echo e(__('admin.order_id')); ?></th>
                    <th class="text-right"><?php echo e(__('admin.action')); ?></th>
                </tr>
                </thead>
                <tbody class="ui-sortable">
                <?php $__currentLoopData = $package->features()->orderBy('order', 'desc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><span class='bx-sm text-primary'><?php echo $feature->icon; ?></span></td>
                        <td class="align-middle">
                            <?php echo e($feature->description); ?>

                        </td>
                        <td class="align-middle">
                            <?php echo e($feature->order); ?>

                        </td>
                        <td class="text-right">
                            <a href="<?php echo e(route('package.move-feature', ['package' => $package->id, 'feature' => $feature->id, 'direction' => 'up'])); ?>"
                               class="btn btn-primary"><i class="fas fa-solid fa-caret-up"></i></a>
                            <a href="<?php echo e(route('package.move-feature', ['package' => $package->id, 'feature' => $feature->id, 'direction' => 'down'])); ?>"
                               class="btn btn-primary"><i
                                    class="fas fa-solid fa-caret-down"></i></a>
                            <a href="<?php echo e(route('package.destroy-feature', ['package' => $package->id, 'feature' => $feature->id])); ?>"
                               class="btn btn-danger"><i class="fas fa-solid fa-trash"></i></a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    function setIcon(icon) {
        document.getElementById("custom-icon").value = icon;
    }

    function setFeatureIcon() {
        document.getElementById("feature-icon").value = document.getElementById("custom-icon").value;
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make(AdminTheme::path('packages/edit/master'), ['title' => 'Package Features', 'tab' => 'features'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/packages/edit/features.blade.php ENDPATH**/ ?>