<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <title><?php echo $__env->yieldContent('title'); ?> - <?php echo App\Models\Settings::get('app_name', 'WemX', ); ?></title>
    <link rel="icon" href="<?php echo App\Models\Settings::get('favicon', 'https://imgur.com/oJDxg2r.png', ); ?>">

    
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- Meta Description Tag: Affects click-through rates from search results -->
    <meta name="description" content="<?php echo e($meta_description ?? settings('seo::description', 'Manage your orders with an easy-to-use Dashboard')); ?>">
    <meta name="theme-color" content="<?php echo App\Models\Settings::get('seo::color', '#4f46e5', ); ?>">
    <meta name="keywords" content="<?php echo e($meta_keywords ?? settings('seo::keywords', '')); ?>">

    <!-- Meta Robots Tag: Controls search engine crawling and indexing -->
    <meta name="robots" content="<?php echo App\Models\Settings::get('seo::robots', 'index, follow', ); ?>">

    <!-- Open Graph Tags: Enhances visibility and engagement on social media platforms -->
    <meta property="og:title" content="<?php echo $__env->yieldContent('title'); ?> - <?php echo App\Models\Settings::get('seo::title', 'WemX', ); ?>">
    <meta property="og:description" content="<?php echo e($meta_description ?? settings('seo::description', 'Manage your orders with an easy-to-use Dashboard')); ?>">
    <meta property="og:image" content="<?php echo App\Models\Settings::get('seo::image', '/static/wemx.png', ); ?>">

    <!-- Custom CSS -->
    

    <link rel="stylesheet" href="<?php echo e(Theme::get('Default')->assets); ?>assets/css/custom.css">
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    <?php echo $__env->make(Theme::path('layouts.tailwind'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('header'); ?>
</head>

<?php echo $__env->make(Theme::path('layouts.widgets.require_address'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<body class="bg-white dark:bg-gray-900" style="min-height: 100vh;display: flex;flex-direction: column;">

    <?php echo $__env->make(Theme::path('layouts.header'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container mx-auto mt-10 mb-10 mx-auto max-w-screen-xl px-4 md:px-6">
        <?php echo $__env->make(Theme::path('layouts.alerts'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="app">
            <?php echo $__env->yieldPushContent('widgets'); ?>
            <?php echo $__env->yieldContent('container'); ?>
        </div>
    </div>

    <?php echo $__env->make(Theme::path('layouts.footer'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
</body>

</html>
<?php /**PATH /var/www/wemx/resources/themes/client/tailwind/layouts/wrapper.blade.php ENDPATH**/ ?>