<?php $__env->startSection('css_libraries'); ?>
<link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>" />
<link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
<script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
<script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <?php if(session('resp')): ?>
        <div class="alert <?php if(session('resp')['status']): ?> alert-success <?php else: ?> alert-danger <?php endif; ?>">
            <p>Status: <?php echo e(session('resp')['status'] ? 'True' : 'False'); ?></p>
            <p>URL: <?php echo e(session('resp')['url']); ?></p>
            <p>API: <?php echo e(session('resp')['api'] ? 'Authorized' : 'Not Authorized'); ?></p>
            <p>SSO: <?php echo e(session('resp')['sso']); ?></p>
        </div>
    <?php endif; ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <form action="<?php echo e(route('admin.settings.store')); ?>" method="POST">
            <div class="card-header">
              <h4><?php echo __('admin.pterodactyl_settings'); ?></h4>
            </div>
            <div class="card-body">
                <?php echo csrf_field(); ?>
              <div class="row">

                <div class="form-group col-6">
                    <label><?php echo __('admin.pterodactyl_url'); ?> <a href="https://docs.wemx.net/en/third-party/pterodactyl#configuration" target="_blank"><?php echo __('admin.documentation'); ?></a></label>
                    <input type="url" class="form-control" name="encrypted::pterodactyl::api_url" id="api_url" value="<?php echo App\Models\Settings::get('encrypted::pterodactyl::api_url', ); ?>" required="">
                    <small class="form-text text-muted">
                        <?php echo __('admin.pterodactyl_url_desc'); ?>

                    </small>
                </div>

                <div class="form-group col-6">
                    <label><?php echo __('admin.pterodactyl_api_key'); ?></label>
                    <input type="password" class="form-control" name="encrypted::pterodactyl::api_key" id="api_key" value="<?php echo App\Models\Settings::get('encrypted::pterodactyl::api_key', ); ?>" required="">
                    <small class="form-text text-muted">
                       <?php echo __('admin.pterodactyl_api_key_desc'); ?>

                    </small>
                </div>

                <div class="form-group col-6">
                  <label><?php echo __('admin.pterodactyl_sso_key'); ?></label>
                  <input type="password" class="form-control" name="encrypted::pterodactyl::sso_secret" id="sso_secret" value="<?php echo App\Models\Settings::get('encrypted::pterodactyl::sso_secret', ); ?>">
                  <small class="form-text text-muted">
                      <?php echo __('admin.pterodactyl_sso_key_desc'); ?> <a href="https://docs.wemx.net/en/third-party/pterodactyl#pterodactyl-sso" target="_blank"><?php echo __('admin.documentation'); ?></a>
                  </small>
              </div>

              </div>
            </div>
            <div class="card-footer text-right">
                <a href="<?php echo e(route('pterodactyl.test-api')); ?>" class="btn btn-primary"><?php echo __('admin.test_connection'); ?></a>
              <button type="submit" class="btn btn-primary"><?php echo __('admin.submit'); ?></button>
            </div>
          </div>
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.pterodactyl_settings'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/app/Services/Pterodactyl/Resources/views/admin/default/settings.blade.php ENDPATH**/ ?>