<?php $__env->startSection('container'); ?>
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header"><?php echo __('admin.services'); ?></div>

                <div class="card-body">
                    <hr>

                    <table class="table">
                        <thead>
                        <tr>
                            <th><?php echo __('admin.name'); ?></th>
                            <th><?php echo __('admin.status'); ?></th>
                            <th class="text-right"><?php echo __('admin.actions'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = Service::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($service->about()->display_name); ?></td>
                                    <td>
                                        <?php if($service->module()->isEnabled()): ?>
                                            <span class="badge badge-success"><?php echo __('admin.enabled'); ?></span>
                                        <?php else: ?>
                                            <span class="badge badge-danger"><?php echo __('admin.disabled'); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-right">
                                        <?php if($service->hasConfig()): ?>
                                        <a href="<?php echo e(route('services.config', ['service' => $service->module()->getLowerName()])); ?>" class="btn btn-primary mr-2">
                                            <i class="fas fa-cog"></i> <?php echo __('admin.configuration'); ?>

                                        </a>
                                        <?php endif; ?>
                                        <?php if($service->module()->isEnabled()): ?>
                                            <a href="<?php echo e(route('modules.toggle', ['module' => $service->module()->getName()])); ?>"
                                                class="btn btn-danger"><?php echo __('admin.disable'); ?></a>
                                        <?php else: ?>
                                            <a href="<?php echo e(route('modules.toggle', ['module' => $service->module()->getName()])); ?>"
                                                class="btn btn-success"><?php echo __('admin.enable'); ?></a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <?php if ($__env->exists(AdminTheme::path('marketplace.resources-card'))) echo $__env->make(AdminTheme::path('marketplace.resources-card'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.services'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/services/index.blade.php ENDPATH**/ ?>