<?php $__env->startSection('css_libraries'); ?>
<link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>" />
<link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
<script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
<script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <form action="<?php echo e(route('admin.settings.store')); ?>" method="POST">
            <div class="card-header">
              <h4><?php echo __('admin.general_settings', ['default' => 'General Settings']); ?></h4>
            </div>
            <div class="card-body">
                <?php echo csrf_field(); ?>
              <div class="row">
                <div class="form-group col-6">
                    <label><?php echo __('admin.application_name', ['default' => 'Application Name']); ?></label>
                    <input type="text" name="app_name" value="<?php echo App\Models\Settings::get('app_name', 'WemX', ); ?>" class="form-control">
                </div>
                <div class="form-group col-6">
                    <label><?php echo __('admin.contact_email', ['default' => 'Contact Email']); ?></label>
                    <input type="email" name="contact_email" value="<?php echo App\Models\Settings::get('contact_email', 'contact@example.com', ); ?>" class="form-control">
                </div>
                <div class="form-group col-6">
                    <label><?php echo __('admin.company_address', ['default' => 'Company Address']); ?></label>
                    <input type="text" name="company_address" value="<?php echo App\Models\Settings::get('company_address', '291 N 4th St, San Jose, CA 95112, USA', ); ?>" class="form-control">
                </div>
                <div class="form-group col-6">
                    <label><?php echo __('admin.date_format', ['default' => 'Date Format']); ?></label>
                    <input type="text" name="date_format" value="<?php echo App\Models\Settings::get('date_format', 'd M Y', ); ?>" class="form-control">
                </div>
                <div class="form-group col-6">
                    <label for="currency"><?php echo __('admin.currency'); ?></label>
                    <select class="form-control select2 select2-hidden-accessible" name="currency" tabindex="-1" aria-hidden="true">
                        <?php $__currentLoopData = config('utils.currencies'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						    <option value="<?php echo e($key); ?>" <?php if(settings('currency') == $key): ?> selected <?php endif; ?>><?php echo e($currency['name']); ?> (<?php echo e($currency['symbol']); ?>)</option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-group col-6">
                    <label for="language"><?php echo __('admin.default_language', ['default' => 'Default Language']); ?></label>
                    <select class="form-control select2 select2-hidden-accessible" name="language" tabindex="-1" aria-hidden="true">
                        <?php if(Module::isEnabled('locales')): ?>
                            <?php $__currentLoopData = lang_module()->getInstalled(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php if(settings('language') == $key): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($lang); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <option value="en">English</option>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="form-group col-6">
                    <label><?php echo __('admin.terminate_order_after_days'); ?></label>
                    <input type="number" name="orders::terminate_suspended_after" value="<?php echo App\Models\Settings::get('orders::terminate_suspended_after', 7, ); ?>" class="form-control">
                </div>
                <div class="form-group col-6">
                    <label><?php echo __('admin.maxmimum_members_per_order'); ?></label>
                    <input type="number" name="orders::maxmimum_members" value="<?php echo App\Models\Settings::get('orders::maxmimum_members', 5, ); ?>" class="form-control">
                </div>
                <div class="form-group col-6">
                    <div class="control-label">
                        User Data Download
                    </div>
                    <label class="custom-switch mt-2"
                           onclick="location.href = '<?php if(settings('download_user_data', true)): ?> /admin/settings/store?download_user_data=0 <?php else: ?> /admin/settings/store?download_user_data=1 <?php endif; ?>';">
                        <input type="checkbox" name="download_user_data" value="1" class="custom-switch-input"
                               <?php if(settings('download_user_data', true)): ?> checked <?php endif; ?>>
                        <span class="custom-switch-indicator"></span>
                        <span class="custom-switch-description">
                            Do you want to give your users the option to download all data stored about the user from user settings.
                        </span>
                    </label>
                </div>

                <div class="form-group col-6">
                    <div class="control-label">
                        Enable Account Deletion Requests
                    </div>
                    <label class="custom-switch mt-2"
                           onclick="location.href = '<?php if(settings('delete_user_account', true)): ?> /admin/settings/store?delete_user_account=0 <?php else: ?> /admin/settings/store?delete_user_account=1 <?php endif; ?>';">
                        <input type="checkbox" name="delete_user_account" value="1" class="custom-switch-input"
                               <?php if(settings('delete_user_account', true)): ?> checked <?php endif; ?>>
                        <span class="custom-switch-indicator"></span>
                        <span class="custom-switch-description">
                            Users will be given the option to delete their account and all data stored about the user from user settings.
                        </span>
                    </label>
                </div>

                <div class="form-group col-6">
                    <div class="control-label">
                        Enable Cookie popup
                    </div>
                    <label class="custom-switch mt-2"
                           onclick="location.href = '<?php if(settings('cookie_popup_enabled', true)): ?> /admin/settings/store?cookie_popup_enabled=0 <?php else: ?> /admin/settings/store?cookie_popup_enabled=1 <?php endif; ?>';">
                        <input type="checkbox" name="cookie_popup_enabled" value="1" class="custom-switch-input"
                               <?php if(settings('cookie_popup_enabled', true)): ?> checked <?php endif; ?>>
                        <span class="custom-switch-indicator"></span>
                        <span class="custom-switch-description">
                            Do you want to enable the cookie alert popup message on the client area
                        </span>
                    </label>
                </div>

                <div class="form-group col-6">
                    <div class="control-label">
                        Enable Contact Us Page
                    </div>
                    <label class="custom-switch mt-2"
                           onclick="location.href = '<?php if(settings('contact_us_enabled', true)): ?> /admin/settings/store?contact_us_enabled=0 <?php else: ?> /admin/settings/store?contact_us_enabled=1 <?php endif; ?>';">
                        <input type="checkbox" name="contact_us_enabled" value="1" class="custom-switch-input"
                               <?php if(settings('contact_us_enabled', true)): ?> checked <?php endif; ?>>
                        <span class="custom-switch-indicator"></span>
                        <span class="custom-switch-description">
                            Do you want to enable the "contact us" page and allow users to submit submissions
                        </span>
                    </label>
                </div>

                <div class="form-group col-6">
                    <label><?php echo __('admin.application_logo', ['default' => 'Application Logo']); ?></label>
                    <input type="text" name="logo" value="<?php echo App\Models\Settings::get('logo', 'https://imgur.com/oJDxg2r.png', ); ?>" class="form-control">
                    <div class="gallery gallary mt-3">
                        <div class="gallery-item" data-image="<?php echo App\Models\Settings::get('logo', 'https://imgur.com/oJDxg2r.png', ); ?>" data-title="Image 1" href="<?php echo App\Models\Settings::get('logo', 'https://imgur.com/oJDxg2r.png', ); ?>" title="Image 1" style="background-image: url('<?php echo App\Models\Settings::get('logo', 'https://imgur.com/oJDxg2r.png', ); ?>');"></div>
                      </div>
                </div>

                <div class="form-group col-6">
                    <label><?php echo __('admin.favicon'); ?></label>
                    <input type="text" name="favicon" value="<?php echo App\Models\Settings::get('favicon', 'https://imgur.com/oJDxg2r.png', ); ?>" class="form-control">
                    <div class="gallery mt-3">
                        <div class="gallery-item" data-image="<?php echo App\Models\Settings::get('favicon', 'https://imgur.com/oJDxg2r.png', ); ?>" data-title="Image 1" href="<?php echo App\Models\Settings::get('favicon', 'https://imgur.com/oJDxg2r.png', ); ?>" title="Image 1" style="background-image: url('<?php echo App\Models\Settings::get('favicon', 'https://imgur.com/oJDxg2r.png', ); ?>');"></div>
                      </div>
                </div>

              </div>
            </div>
            <div class="card-footer text-right">
              <button type="submit" class="btn btn-primary"><?php echo __('admin.submit'); ?></button>
            </div>
          </div>
        </form>
    </div>
</div>
<style>
    span.select2.select2-container.select2-container--default {
        width: 100% !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.settings'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/settings/general.blade.php ENDPATH**/ ?>