<?php $__env->startSection('css_libraries'); ?>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <section class="section">
        <div class="section-body">
            <div class="col-12 col-md-12 col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4><?php echo e(__('Create Download')); ?></h4>

                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('downloads.store')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <div class="form-group">
                                <label for="name">Name</label>
                                <input type="text" class="form-control" name="name" id="name"
                                    value="<?php echo e(old('name')); ?>" required>
                                <small class="form-text text-muted">Downloads name</small>
                            </div>

                            <div class="form-group">
                                <label for="description">Description</label>
                                <textarea class="form-control" name="description" required><?php echo e(old('description')); ?></textarea>
                                <small class="form-text text-muted">Description about downloads</small>
                            </div>

                            <div class="form-group">
                                <label for="package">Required Package</label>
                                <div class="input-group mb-2">
                                    <select name="package[]" id="package"
                                        class="form-control select2 select2-hidden-accessible" multiple="" tabindex="-1"
                                        aria-hidden="true">
                                        <?php $__currentLoopData = Package::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($package->id); ?>"><?php echo e($package->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>
                                    <small class="form-text text-muted"></small>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="file">File</label>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" id="file" name="file"
                                        accept=".zip">
                                    <label class="custom-file-label" for="file">Choose file</label>
                                    <small class="form-text text-muted">Please upload a ZIP file</small>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="allow_guest">Allow Guest</label>
                                <select name="allow_guest" id="allow_guest" class="form-control" required>
                                    <option value="1">Yes</option>
                                    <option value="0">No</option>
                                </select>

                            </div>

                            <div class="col-md-12">
                                <div class="text-right">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('Downloads'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/Modules/Downloads/Resources/views/admin/create.blade.php ENDPATH**/ ?>