<?php $__env->startSection('container'); ?>
    <section class="section">
        <div class="section-body">
            <div class="col-12 mb-4">
                <div class="card mb-0">
                    <div class="card-body">
                        <ul class="nav nav-pills">
                            <li class="nav-item">
                                <a class="nav-link <?php if($status == 'active'): ?> active <?php endif; ?>"
                                   href="<?php echo e(route('orders.index', ['status' => 'active'])); ?>">
                                    <?php echo __('admin.active'); ?>

                                    <span class="badge <?php if($status == 'active'): ?> badge-white <?php else: ?> badge-primary <?php endif; ?>">
                                            <?php echo e(Order::whereStatus('active')->count()); ?>

                                    </span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link <?php if($status == 'suspended'): ?> active <?php endif; ?>"
                                   href="<?php echo e(route('orders.index', ['status' => 'suspended'])); ?>"><?php echo __('admin.suspended'); ?>

                                    <span
                                        class="badge <?php if($status == 'suspended'): ?> badge-white <?php else: ?> badge-primary <?php endif; ?>">
                                        <?php echo e(Order::whereStatus('suspended')->count()); ?>

                                    </span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link <?php if($status == 'cancelled'): ?> active <?php endif; ?>"
                                   href="<?php echo e(route('orders.index', ['status' => 'cancelled'])); ?>"><?php echo __('admin.cancelled'); ?>

                                    <span
                                        class="badge <?php if($status == 'cancelled'): ?> badge-white <?php else: ?> badge-primary <?php endif; ?>">
                                        <?php echo e(Order::whereStatus('cancelled')->count()); ?>

                                    </span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link <?php if($status == 'terminated'): ?> active <?php endif; ?>"
                                   href="<?php echo e(route('orders.index', ['status' => 'terminated'])); ?>"><?php echo __('admin.terminated'); ?>

                                    <span
                                        class="badge <?php if($status == 'terminated'): ?> badge-white <?php else: ?> badge-primary <?php endif; ?>">
                                        <?php echo e(Order::whereStatus('terminated')->count()); ?>

                                    </span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-12 col-md-12 col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4><?php echo __('admin.orders'); ?></h4>
                        <div class="card-header-action">
                            <a href="<?php echo e(route('orders.create')); ?>" class="btn btn-icon icon-left btn-primary"><i
                                    class="fas fa-solid fa-plus"></i> <?php echo __('admin.create'); ?></a>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-striped table-md">
                                <tbody>
                                <tr>
                                    <th>#</th>
                                    <th><?php echo __('admin.description'); ?></th>
                                    <th><?php echo __('admin.user'); ?></th>
                                    <th><?php echo __('admin.price'); ?></th>
                                    <th><?php echo __('admin.service'); ?></th>
                                    <th><?php echo __('admin.status'); ?></th>
                                    <th><?php echo __('admin.create_at'); ?></th>
                                    <th><?php echo __('admin.actions'); ?></th>
                                </tr>

                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>#<?php echo e(Str::substr($order->id, 0, 8)); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('orders.edit', ['order' => $order->id])); ?>"
                                               style="display: flex; color: #6c757d">
                                                <img alt="image"
                                                     src="<?php echo e(asset('storage/products/' . $order->package['icon'])); ?>"
                                                     class="mr-1 mt-1" style="border-radius: 5px" width="32px"
                                                     height="32px" data-toggle="tooltip" title="" data-original-title="
                                                    <?php echo e($order->package['name']); ?>">
                                                <?php echo e($order->name); ?>

                                            </a>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('users.edit', ['user' => $order->user->id])); ?>"
                                               style="display: flex; color: #6c757d">
                                                <img alt="image" src="<?php echo e($order->user->avatar()); ?>"
                                                     class="rounded-circle mr-1 mt-1" width="32px" height="32px"
                                                     data-toggle="tooltip" title="" data-original-title="
                                                    <?php echo e($order->user->first_name); ?> <?php echo e($order->user->last_name); ?>">
                                                <div class="flex">
                                                    <?php echo e($order->user->username); ?> <br>
                                                    <small><?php echo e($order->user->email); ?></small>
                                                </div>
                                            </a>
                                        </td>
                                        <td><?php echo e(currency('symbol')); ?><?php echo e($order->price['renewal_price']); ?></span>
                                            / <?php echo $order->periodToHuman(); ?></td>
                                        <td><?php echo e($order->service); ?></td>
                                        <td>
                                            <div class="flex align-items-center">
                                                <i class="fas fa-solid fa-circle
                                                    <?php if($order->status == 'active'): ?> text-success <?php elseif($order->status == 'suspended'): ?> text-warning
                                                    <?php elseif($order->status == 'cancelled' OR $order->status == 'terminated'): ?> text-danger <?php endif; ?>"
                                                   style="font-size: 11px;">

                                                </i>
                                                <?php echo __('admin.' . $order->status); ?>

                                            </div>
                                        </td>
                                        <td>
                                            <?php echo __('admin.created'); ?>

                                            : <?php echo e($order->created_at->translatedFormat(settings('date_format', 'd M Y'))); ?>

                                            <br>
                                            <?php echo __('admin.due_date'); ?>

                                            : <?php echo e($order->due_date->translatedFormat(settings('date_format', 'd M Y'))); ?>

                                            <br>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('orders.edit', ['order' => $order->id])); ?>"
                                                class="btn btn-primary"> <?php echo __('admin.manage'); ?></a>
                                            <?php if($order->status == 'terminated'): ?>
                                                <button type="button" onclick="deleteOrder(<?php echo e($order->id); ?>)" class="btn btn-danger"><i class="fas fa-solid fa-trash"></i></button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer text-right">
                        <?php echo e($orders->links(AdminTheme::pagination())); ?>

                    </div>
                </div>
            </div>
        </div>
    </section>

<script>
    function deleteOrder(order) {
        if (window.confirm('Are you sure you want to delete this order? All payments and data stored related to the order will be deleted.')) {
            window.location.href = "/admin/orders/" + order +"/delete";
        } else {
            event.preventDefault();
        }
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.order'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/orders/index.blade.php ENDPATH**/ ?>