<?php $__env->startSection('container'); ?>
<div class="col-12 col-md-12 col-lg-12">
    <div class="card">
      <div class="card-header">
        <h4>Departments</h4>
        <div class="card-header-action">
          <a href="<?php echo e(route('tickets.departments.create')); ?>" class="btn btn-icon icon-left btn-primary">
              Create Department
          </a>
        </div>
      </div>
      <div class="card-body p-0">
        <div class="table-responsive">
          <table class="table table-striped table-md">
            <tbody><tr>
              <th>Name</th>
              <th>Description</th>
              <th>Auto close after</th>
              <th>Auto lock after</th>
              <th class="text-right">Last Updated</th>
              <th class="text-right">Actions</th>
            </tr>
            <?php if($departments->count() == 0): ?> 
              <?php echo $__env->make(AdminTheme::path('empty-state'), ['title' => 'No departments found', 'description' => 'You have not created any departments yet'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
            <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td><?php echo e($department->name); ?></td>
              <td><?php echo e($department->description); ?></td>
              <td><?php echo e($department->auto_close_after); ?> hours</td>
              <td><?php echo e($department->auto_lock_after); ?> hours</td>
              <td class="text-right"><?php echo e($department->updated_at->diffForHumans()); ?></td>
              <td class="text-right">
                <a href="<?php echo e(route('tickets.departments.edit', $department->id)); ?>" class="btn btn-success">Edit</a>
              </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody></table>
        </div>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make(AdminTheme::wrapper(), ['title' => 'Departments', 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/Modules/Tickets/Resources/views/admin/default/departments/index.blade.php ENDPATH**/ ?>