<?php $__env->startSection('container'); ?>
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header"><?php echo __('admin.coupons', ['default' => 'Coupons']); ?></div>

                <div class="card-body">
                    <a href="<?php echo e(route('coupons.create')); ?>" class="btn btn-primary"><?php echo __('admin.create_coupon', ['default' => 'Create Coupon']); ?></a>
                    <hr>

                    <table class="table">
                        <thead>
                            <tr>
                                <th><?php echo __('admin.code', ['default' => 'Code']); ?></th>
                                <th><?php echo __('admin.amount', ['default' => 'Amount']); ?></th>
                                <th><?php echo __('admin.user_left', ['default' => 'Uses left']); ?></th>

                                <th><?php echo __('admin.expires_at', ['default' => 'Expires At']); ?></th>
                                <th class="text-right"><?php echo __('admin.actions', ['default' => 'Actions']); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($coupon->code); ?></td>
                                    <td><?php echo e($coupon->discount_amount); ?><?php if($coupon->discount_type == 'percentage'): ?> % <?php else: ?> <?php echo e(currency("symbol")); ?> <?php endif; ?></td>
                                    <td><?php echo e($coupon->allowed_uses); ?></td>

                                    <td><?php if($coupon->expires_at): ?> <?php echo e($coupon->expires_at); ?> <?php else: ?> <?php echo __('admin.never', ['default' => 'never']); ?> <?php endif; ?></td>
                                    <td class="text-right">
                                        <a href="<?php echo e(route('coupons.edit', $coupon->id)); ?>"
                                            class="btn btn-primary"><?php echo __('admin.edit'); ?></a>

                                        <form action="<?php echo e(route('coupons.destroy', $coupon->id)); ?>" method="POST"
                                            style="display: inline-block;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button onclick="deleteItem(event)" type="submit"
                                                class="btn btn-danger"><?php echo __('admin.delete'); ?></button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.coupons', ['default' => 'Coupons']), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/coupons/index.blade.php ENDPATH**/ ?>