<?php $__env->startSection('css_libraries'); ?>
<link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>" />
<link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
<script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
<script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <form action="<?php echo e(route('admin.settings.store')); ?>" method="POST">
            <div class="card-header">
              <h4><?php echo e(__('affiliates::general.affiliate_settings')); ?></h4>
            </div>
            <div class="card-body">
                <?php echo csrf_field(); ?>
              <div class="row">

                <div class="form-group col-6">
                  <label><?php echo e(__('affiliates::general.minimum_payout_amount')); ?></label>
                  <input type="number" min="0" class="form-control" name="affiliates::minimum_payout" id="minimum_payout" value="<?php echo App\Models\Settings::get('affiliates::minimum_payout', 10, ); ?>" required="">
                  <small class="form-text text-muted">
                      <?php echo e(__('affiliates::general.minimum_payout_amount_desc')); ?>

                  </small>
                </div>

                <div class="form-group col-6">
                  <label for="gateways"><?php echo e(__('affiliates::general.payout_gateways')); ?></label>
                  <div class="input-group mb-2">
                      <select name="affiliates::gateways[]" id="gateways" class="form-control select2 select2-hidden-accessible"
                          multiple="" tabindex="-1" aria-hidden="true">
                              <option value="balance" <?php if(in_array('balance', json_decode(settings('affiliates::gateways', '["balance", "paypal", "bitcoin"]')))): ?> selected <?php endif; ?>>
                                  <?php echo e(__('affiliates::general.account_balance')); ?></option>
                              <option value="paypal" <?php if(in_array('paypal', json_decode(settings('affiliates::gateways', '["balance", "paypal", "bitcoin"]')))): ?> selected <?php endif; ?>>PayPal</option>
                              <option value="bitcoin" <?php if(in_array('bitcoin', json_decode(settings('affiliates::gateways', '["balance", "paypal", "bitcoin"]')))): ?> selected <?php endif; ?>>Bitcoin</option>
                      </select>
                      <small class="form-text text-muted"></small>
                  </div>
              </div>

                <div class="form-group col-6">
                    <label><?php echo e(__('affiliates::general.default_comission')); ?></label>
                    <input type="number" min="0" max="100" class="form-control" name="affiliates::default_comission" id="default_comission" value="<?php echo App\Models\Settings::get('affiliates::default_comission', 10, ); ?>" required="">
                    <small class="form-text text-muted">
                        <?php echo e(__('affiliates::general.default_comission_desc')); ?>

                    </small>
                </div>

                <div class="form-group col-6">
                  <label><?php echo e(__('affiliates::general.default_discount')); ?></label>
                  <input type="number" min="0" max="100" class="form-control" name="affiliates::default_discount" id="default_discount" value="<?php echo App\Models\Settings::get('affiliates::default_discount', 15, ); ?>" required="">
                  <small class="form-text text-muted">
                      <?php echo e(__('affiliates::general.default_discount_desc')); ?>

                  </small>
                </div>

              </div>
            </div>
            <div class="card-footer text-right">
              <button type="submit" class="btn btn-primary"><?php echo e(__('affiliates::general.submit')); ?></button>
            </div>
          </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => 'Dashboard', 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/Modules/Affiliates/Resources/views/admin/default/settings.blade.php ENDPATH**/ ?>