<?php $__env->startSection('title', __('client.contact_us')); ?>
<?php if(Settings::getJson('encrypted::captcha::cloudflare', 'is_enabled', false)): ?>
    <script src="https://challenges.cloudflare.com/turnstile/v0/api.js" async defer></script>
<?php endif; ?>

<?php $__env->startSection('title', __('client.contact_us')); ?>

<?php $__env->startSection('container'); ?>
<section class="bg-white dark:bg-gray-900" style="height: 100%;">
    <div class="py-8 lg:py-16 px-4 mx-auto max-w-screen-md">
        <?php if(session('contact_submission')): ?>
        <h2 class="mb-4 text-4xl tracking-tight font-extrabold text-center text-gray-900 dark:text-white mt-12">
            <?php echo e(__('client.contact_us_success_subject')); ?></h2>
        <p class="mb-8 lg:mb-16 font-light text-center text-gray-500 dark:text-gray-400 sm:text-xl">
            <?php echo e(__('client.contact_us_success_content', ['subject' => session('contact_submission')])); ?>

        </p>
        <?php else: ?>
        <h2 class="mb-4 text-4xl tracking-tight font-extrabold text-center text-gray-900 dark:text-white mt-12">
            <?php echo __('client.contact_us'); ?></h2>
        <p class="mb-8 lg:mb-16 font-light text-center text-gray-500 dark:text-gray-400 sm:text-xl">
            <?php echo __('client.contact_us_desc'); ?>

        </p>

        <form action="<?php echo e(route('contact.submit')); ?>" method="POST" class="space-y-8">
            <?php echo csrf_field(); ?>
            <div>
                <label for="email" class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                    <?php echo __('auth.your_email'); ?></label>
                <input type="email" id="email" name="email"
                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 <?php if(auth()->check()): ?> cursor-not-allowed <?php endif; ?> focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500 dark:shadow-sm-light"
                    placeholder="name@example.com" required <?php if(auth()->check()): ?> value="<?php echo e(auth()->user()->email); ?>" readonly="" <?php endif; ?>>
            </div>
            <div>
                <label for="subject"
                    class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300"><?php echo __('client.subject'); ?></label>
                <input type="text" id="subject" name="subject"
                    class="block p-3 w-full text-sm text-gray-900 bg-gray-50 rounded-lg border border-gray-300 shadow-sm focus:ring-primary-500 focus:border-primary-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500 dark:shadow-sm-light"
                    placeholder="" required>
            </div>
            <div class="sm:col-span-2">
                <label for="message" class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-400">
                    <?php echo __('client.your_message'); ?></label>
                <textarea id="message" name="message" rows="6"
                    class="block p-2.5 w-full text-sm text-gray-900 bg-gray-50 rounded-lg shadow-sm border border-gray-300 focus:ring-primary-500 focus:border-primary-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                    placeholder=""></textarea>
            </div>

            <?php if(Settings::getJson('encrypted::captcha::cloudflare', 'page_contact_us', false)): ?>
                <div class="flex items-center justify-start">
                    <?php if (isset($component)) { $__componentOriginale9d0814dccb09ead38d4e1f9dcb45674 = $component; } ?>
<?php $component = RyanChandler\LaravelCloudflareTurnstile\View\Components\Turnstile::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('turnstile'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(RyanChandler\LaravelCloudflareTurnstile\View\Components\Turnstile::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale9d0814dccb09ead38d4e1f9dcb45674)): ?>
<?php $component = $__componentOriginale9d0814dccb09ead38d4e1f9dcb45674; ?>
<?php unset($__componentOriginale9d0814dccb09ead38d4e1f9dcb45674); ?>
<?php endif; ?>
                </div>
            <?php endif; ?>

            <button type="submit"
                class="py-3 px-5 text-sm font-medium text-center text-white rounded-lg bg-primary-700 sm:w-fit hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                <?php echo __('client.send_message'); ?></button>
        </form>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(Theme::wrapper(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/client/tailwind/contact-us.blade.php ENDPATH**/ ?>