<?php $__env->startSection('container'); ?>
    <section class="section">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4><?php echo __('admin.client_themes'); ?></h4>
                        <div class="card-header-action">
                            <form>
                                <div class="input-group">
                                    <input type="text" class="form-control" placeholder="<?php echo __('admin.search'); ?>"/>
                                    <div class="input-group-btn">
                                        <button class="btn btn-primary"><i class="fas fa-search"></i></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="card-body ">
                        <div class="table-responsive">
                            <table class="table table-striped" id="sortable-table">
                                <thead>
                                <tr>
                                    <th class="text-center">
                                        <i class="fas fa-th"></i>
                                    </th>
                                    <th><?php echo __('admin.theme'); ?></th>
                                    <th><?php echo __('admin.authors', ['default' => 'Author(s)']); ?></th>
                                    <th><?php echo __('admin.version'); ?></th>
                                    <th><?php echo __('admin.status'); ?></th>
                                    <th class="text-right"><?php echo __('admin.actions'); ?></th>
                                </tr>
                                </thead>
                                <tbody class="ui-sortable">
                                <?php $__currentLoopData = Theme::list(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $theme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="" style="">
                                        <td>
                                            <div class="sort-handler ui-sortable-handle">
                                                <i class="fas fa-th"></i>
                                            </div>
                                        </td>
                                        <td><?php echo e($theme->name); ?></td>
                                        <td>
                                            <?php echo e($theme->author); ?>

                                        </td>
                                        <td>v<?php echo e($theme->version); ?></td>


                                        <td>
                                            <div
                                                class="badge <?php if($theme->name == Theme::active()->name): ?> badge-success
                                                <?php else: ?>  badge-danger  <?php endif; ?>"><?php if($theme->name == Theme::active()->name): ?>
                                                    <?php echo __('admin.active'); ?>

                                                <?php else: ?>
                                                    <?php echo __('admin.inactive'); ?>

                                                <?php endif; ?></div>
                                        </td>
                                        <td class="text-right">
                                            <a href="<?php echo e(route('admin.theme.files', ['folder' => 'client/'. $theme->folder])); ?>"
                                               class="btn btn-primary"><?php echo __('admin.files'); ?></a>
                                            <a href="<?php echo e(route('admin.theme.activate', ['theme' => $theme->name])); ?>"
                                               class="btn <?php if($theme->name == Theme::active()->name): ?> btn-primary disabled <?php else: ?>  btn-primary  <?php endif; ?>"><?php echo __('admin.activate'); ?></a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php if ($__env->exists(AdminTheme::path('marketplace.resources-card'))) echo $__env->make(AdminTheme::path('marketplace.resources-card'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' =>  __('admin.client_themes'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/themes/client_themes.blade.php ENDPATH**/ ?>