
<header>
    <nav class="bg-white border-gray-200 px-4 lg:px-6 py-2.5 dark:bg-gray-900">
        <div class="flex flex-wrap justify-between items-center mx-auto max-w-screen-xl px-4 md:px-6">
            <div class="flex justify-start items-center">
                <a href="/" class="flex mr-6 xl:mr-8">
                    <?php if(Settings::has('logo')): ?>
                        <img src="<?php echo App\Models\Settings::get('logo', ); ?>" class="mr-3 h-8 rounded"
                            alt="<?php echo App\Models\Settings::get('app_name', 'WemX', ); ?>" />
                    <?php endif; ?>
                    <span
                        class="self-center text-2xl font-semibold whitespace-nowrap dark:text-white"><?php echo App\Models\Settings::get('app_name',
                        'WemX', ); ?></span>
                </a>

            </div>
            <?php echo $__env->make(Theme::path('layouts.widgets.user-dropdown'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </nav>

    <div class="border-t border-b border-gray-100 bg-gray-50 dark:border-gray-800 dark:bg-gray-800">
        <div class="flex flex-wrap justify-between items-center mx-auto max-w-screen-xl px-4 md:px-6">
            <ul class="flex flex-wrap -mb-px -ml-4">
                <li class="mr-2">
                    <a class="inline-flex text-gray-500 rounded-t-lg py-4 px-4 text-sm font-medium text-center border-b-2 dark:text-gray-400 group border-gray-50 dark:border-gray-800 <?php echo e(is_active('dashboard')); ?> "
                        href="<?php echo e(route('dashboard')); ?>">
                        <span class="mr-2" style="font-size: 20px;">
                            <i class='bx bxs-dashboard'></i>
                        </span>
                        <?php echo __('client.dashboard'); ?>

                    </a>
                </li>

                <li class="mr-2">
                    <a class="inline-flex text-gray-500 rounded-t-lg py-4 px-4 text-sm font-medium text-center border-b-2 dark:text-gray-400 group border-gray-50 dark:border-gray-800 <?php echo e(is_active('news.index')); ?> "
                        href="<?php echo e(route('news.index')); ?>">
                        <span class="mr-2" style="font-size: 20px;">
                            <i class='bx bxs-news'></i>
                        </span>
                        <?php echo e(__('client.news')); ?>

                    </a>
                </li>

                <li class="mr-2">
                    <a class="inline-flex text-gray-500 rounded-t-lg py-4 px-4 text-sm font-medium text-center border-b-2 dark:text-gray-400 group border-gray-50 dark:border-gray-800 <?php echo e(is_active('store.index')); ?> "
                        href="<?php echo e(route('store.index')); ?>">
                        <span class="mr-2" style="font-size: 20px;">
                            <i class='bx bxs-server'></i>
                        </span>
                        <?php echo __('client.services'); ?>

                    </a>
                </li>

                <?php $__currentLoopData = Page::getActive(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(in_array('navbar', $page->placement)): ?>
                    <li class="mr-2">
                        <a class="inline-flex text-gray-500 rounded-t-lg py-4 px-4 text-sm font-medium text-center border-b-2 dark:text-gray-400 group border-gray-50 dark:border-gray-800 <?php echo e(is_active('page', ['page' => $page->path])); ?>"
                            href="<?php echo e(route('page', $page->path)); ?>" <?php if($page->new_tab): ?> target="_blank" <?php endif; ?>>
                            <span class="mr-2" style="font-size: 20px;">
                                <?php echo $page->icon; ?>

                            </span>
                            <?php echo e(__($page->name)); ?>

                        </a>
                    </li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                
                <?php $__currentLoopData = Module::allEnabled(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(config($module->getLowerName() . '.elements.main_menu')): ?>
                        <?php $__currentLoopData = config($module->getLowerName() . '.elements.main_menu'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="mr-2">
                                <a class="inline-flex text-gray-500 rounded-t-lg py-4 px-4 text-sm font-medium text-center border-b-2 dark:text-gray-400 group border-gray-50 dark:border-gray-800 <?php echo e(is_active($menu['href'], ['module' => true])); ?>"
                                    href="<?php echo e($menu['href']); ?>">
                                    <span class="mr-2" style="font-size: 20px; <?php echo e($menu['style']); ?>">
                                        <?php echo $menu['icon']; ?>

                                    </span>
                                    <?php echo __($menu['name']); ?>

                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    </div>

</header>

<?php /**PATH /var/www/wemx/resources/themes/client/tailwind/layouts/header.blade.php ENDPATH**/ ?>