<?php $__env->startSection('title'); ?>
    <?php echo e(__('locales::general.title')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header"><?php echo e(__('locales::general.header')); ?></div>



                <div class="card-body">
                    <button class="btn btn-sm btn-primary" data-toggle="modal"
                            data-target="#generateLang"><?php echo e(__('locales::general.generate_new')); ?></button>

                    <div class="box-body table-responsive no-padding">
                        <table class="table table-hover">
                            <tbody>
                            <tr>
                                <th><?php echo e(__('locales::general.locale_code')); ?></th>
                                <th><?php echo e(__('locales::general.locale_name')); ?></th>
                                <th><?php echo e(__('locales::general.locale_path')); ?></th>
                                <th class="text-right"><?php echo e(__('locales::general.locale_actions')); ?></th>
                            </tr>
                            <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(isset($lang)): ?>
                                    <tr>
                                        <td><code><?php echo e($key); ?></code></td>
                                        <td><?php echo e($lang); ?></td>
                                        <td><code><?php echo e(resource_path('lang')); ?>/<?php echo e($key); ?>/</code>
                                        </td>
                                        <td class="text-right">
                                            <a class="btn btn-primary btn-sm"
                                               href="<?php echo e(route('locales.translate', ['code' => $key])); ?>"><?php echo e(__('locales::general.translate')); ?></a>
                                            <a onclick="deleteItem(event)"
                                               href="<?php echo e(route('locales.remove', ['code' => $key])); ?>"
                                               class="btn btn-primary btn-sm"><?php echo e(__('locales::general.remove')); ?></a>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>


                </div>
            </div>
        </div>
    </div>




    
    <div class="modal fade" id="generateLang" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form action="<?php echo e(route('locales.generate')); ?>" method="POST">
                    <div class="modal-header">
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <label for="lang_code"
                                       class="form-label"><?php echo e(__('locales::general.select_localisation')); ?></label>
                                <select class="form-control" required name="lang_code" id="lang_code">
                                    <?php $__currentLoopData = $localizations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>"><?php echo e($lang); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <?php echo csrf_field(); ?>

                        <button type="button" class="btn btn-default btn-sm pull-left"
                                data-dismiss="modal"><?php echo e(__('locales::general.cancel')); ?></button>
                        <button type="submit"
                                class="btn btn-success btn-sm"><?php echo e(__('locales::general.generate')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        function confirm_delete() {
            return confirm('Are you sure?');
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/Modules/Locales/Resources/views/admin/default/index.blade.php ENDPATH**/ ?>