<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="description" content="WemX Billing System">
    <meta name="keywords" content="WemX Panel, Billing Panel,  <?php echo $__env->yieldContent('keywords'); ?>">
    <meta name="author" content="WemX">
    <title><?php echo $__env->yieldContent('title'); ?> - <?php echo App\Models\Settings::get('app_name', 'WemX', ); ?></title>
    <link rel="icon" href="<?php echo App\Models\Settings::get('favicon', 'https://imgur.com/oJDxg2r.png', ); ?>">
    <?php echo $__env->make(Theme::path('layouts.tailwind'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php if(Settings::getJson('encrypted::captcha::cloudflare', 'is_enabled', false)): ?>
        <script src="https://challenges.cloudflare.com/turnstile/v0/api.js" async defer></script>
    <?php endif; ?>
</head>

<body class="dark:bg-gray-900">
    <div class="app">
        <?php echo $__env->yieldContent('container'); ?>
    </div>
</body>

</html>
<?php /**PATH /var/www/wemx/resources/themes/client/tailwind/auth/wrapper.blade.php ENDPATH**/ ?>