<?php
    $inputClass = 'bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500';
    $checkboxClass = 'w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[\'\'] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600';
    $pVariables = $package->data('environment');
?>

<div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
    <div class="custom-note">
        <div class="flex justify-between mb-3 rounded-t sm:mb-3">
            <div class="text-lg text-gray-900 md:text-xl dark:text-white">
                <h3 class="font-semibold"><?php echo __('client.ptero_server_options'); ?></h3>
                <p class="text-sm text-gray-500 dark:text-gray-400"><?php echo __('client.ptero_server_options_desc'); ?></p>
            </div>
            <div></div>
        </div>

        <div class="mb-4">
            <label for="location"
                   class="block mb-2 text-sm font-medium text-gray-900 dark:text-white"><?php echo __('client.ptero_server_location'); ?></label>
            <select id="location" name="location"
                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                    required>
                <?php $__currentLoopData = $package->data('locations', []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(PterodactylLocation::whereId($location)->exists()): ?>
                        <option value="<?php echo e(PterodactylLocation::find($location)->id); ?>"
                                <?php if(PterodactylLocation::find($location)->stock == 0): ?> disabled <?php endif; ?>><?php echo e(PterodactylLocation::find($location)->name); ?>

                            (<?php echo e(PterodactylLocation::find($location)->inStock()); ?>)
                        </option>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

    </div>


    <div class="grid gap-4 sm:grid-cols-2 sm:gap-6">
        <?php if(json_decode($package->data('egg')) !== NULL): ?>
            <?php $__currentLoopData = json_decode($package->data('egg'))->relationships->variables->data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $variable = $variable->attributes; ?>

                <?php if($variable->user_viewable AND !in_array($variable->env_variable, $package->data('excluded_variables', []))): ?>
                    <div class="w-full">

                        
                        <label for="environment" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                            <?php echo __($variable->name); ?>

                            <?php if(Str::contains($variable->rules, 'required')): ?>
                                <span class="text-red-500">*</span>
                            <?php endif; ?>
                        </label>


                        <?php if(Str::contains($variable->rules, 'boolean')): ?>
                            
                            <label class="relative inline-flex cursor-pointer flex flex-row justify-end">
                                <input type="checkbox" name="environment[<?php echo e($variable->env_variable); ?>]"
                                       class="sr-only peer"
                                       <?php if(isset($pVariables[$variable->env_variable]) && $pVariables[$variable->env_variable]): ?> checked <?php endif; ?>>
                                <div class="<?php echo e($checkboxClass); ?>"></div>
                            </label>

                        <?php elseif(Str::contains(str_replace(' ', '', $variable->rules), '|in:true,false') || Str::contains(str_replace(' ', '', $variable->rules), '|in:false,true')): ?>
                            
                            <label class="relative inline-flex cursor-pointer flex flex-row justify-end">
                                <input type="checkbox" name="environment[<?php echo e($variable->env_variable); ?>]"
                                       value="<?php echo e($pVariables[$variable->env_variable]); ?>" class="sr-only peer"
                                       <?php if(isset($pVariables[$variable->env_variable]) && $pVariables[$variable->env_variable] == 'true'): ?> checked <?php endif; ?>>
                                <div class="<?php echo e($checkboxClass); ?>"></div>
                            </label>

                        <?php elseif(Str::contains(str_replace(' ', '', $variable->rules), '|in:')): ?>
                            
                            <?php $options = explode(',', Str::after($variable->rules, 'in:'));?>
                            <select name="environment[<?php echo e($variable->env_variable); ?>]" class="<?php echo e($inputClass); ?>" required>
                                <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e(trim($option)); ?>"
                                            <?php if(isset($pVariables[$variable->env_variable]) && $pVariables[$variable->env_variable] == trim($option)): ?> selected <?php endif; ?>><?php echo e(ucfirst(trim($option))); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                        <?php else: ?>
                            
                            <input <?php if(!$variable->user_editable): ?> disabled
                                   <?php else: ?> name="environment[<?php echo e($variable->env_variable); ?>]" <?php endif; ?> type="text" id="brand"
                                   class="<?php echo e($inputClass); ?>"
                                   value="<?php if(isset($pVariables[$variable->env_variable])): ?><?php echo e($pVariables[$variable->env_variable]); ?><?php else: ?><?php echo e($variable->default_value); ?><?php endif; ?>"
                                   <?php if(Str::contains($variable->rules, 'required')): ?> required <?php endif; ?>>

                        <?php endif; ?>

                        
                        <p id="helper-text-explanation"
                           class="mt-2 text-sm text-gray-500 dark:text-gray-400"><?php echo __($variable->description); ?></p>


                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </div>

</div>
<?php /**PATH /var/www/wemx/app/Services/Pterodactyl/Resources/views/client/tailwind/props/checkout-options.blade.php ENDPATH**/ ?>