<?php $__env->startSection('css_libraries'); ?>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
        <form action="<?php echo e(route('coupons.store')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="col-12 col-md-12 col-lg-12">
                <div class="card">
                        <div class="card-header">
                            <h4><?php echo __('admin.create_coupon', ['default' => 'Create Coupon']); ?></h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-md-12 col-12">
                                    <label for="code"><?php echo __('admin.coupon_code', ['default' => 'Coupon Code']); ?></label>
                                    <input type="text" name="code" id="code"
                                        class="form-control <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('code', Str::random(8))); ?>"
                                        required>
                                    <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group col-md-6 col-6">
                                    <label for="discount_amount"><?php echo __('admin.discount_amount', ['default' => 'Discount Amount']); ?></label>
                                    <div class="input-group mb-2">
                                        <input type="number" class="form-control text-right" name="discount_amount" id="discount_amount" value="<?php echo e(old('discount_amount', 0)); ?>" min="0" required="">
                                        <div class="input-group-append">
                                            <div class="input-group-text" id="type">%</div>
                                        </div>
                                        <small class="form-text text-muted"> </small>
                                    </div>
                                </div>

                                <div class="form-group col-md-6 col-6">
                                    <label for="discount_type"><?php echo __('admin.discount_type', ['default' => 'Discount Type']); ?></label>
                                    <select onchange="updateType()" class="form-control select2 select2-hidden-accessible" name="discount_type" id="discount_type" tabindex="-1" aria-hidden="true">
                                        <option value="percentage"><?php echo __('admin.percentage', ['default' => 'Percentage %']); ?></option>
                                        <option value="flat"><?php echo __('admin.flat', ['default' => 'Flat $']); ?></option>
                                    </select>
                                </div>

                                <div class="form-group col-md-6 col-6">
                                    <label for="allowed_uses"><?php echo __('admin.allowed_users', ['default' => 'Allowed Uses']); ?></label>
                                    <div class="input-group mb-2">
                                        <input type="number" class="form-control text-left" name="allowed_uses" id="allowed_uses" value="<?php echo e(old('allowed_uses', 1)); ?>" min="0" required="">
                                        <small class="form-text text-muted"> </small>
                                    </div>
                                </div>

                                <div class="form-group col-md-6 col-6">
                                    <label for="expires_at"><?php echo __('admin.expires_at', ['default' => 'Expires At']); ?></label>
                                    <div class="input-group mb-2">
                                        <input type="date" class="form-control text-left" name="expires_at" id="expires_at" value="<?php echo e(old('expires_at')); ?>">
                                        <small class="form-text text-muted">
                                            <?php echo __('admin.expires_coupon_desc', ['default' => 'Leave this field empty if you do not want to set an expiration date for this coupon. If a expiration date is set, the coupon will be valid until that date.']); ?>

                                        </small>
                                    </div>
                                </div>

                                <div class="form-group col-12">
                                    <label for="applicable_products"><?php echo __('admin.applicable_packages', ['default' => 'Applicable Packages']); ?></label>
                                    <div class="input-group mb-2">
                                        <select name="applicable_products[]" id="applicable_products" class="form-control select2 select2-hidden-accessible"
                                            multiple="" tabindex="-1" aria-hidden="true">
                                            <?php $__currentLoopData = Package::latest()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($package->id); ?>"><?php echo e($package->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <small class="form-text text-muted text-primary"><a href="#" onclick="selectAllPackages()">Select All (after select a item from the menu to load all)</a></small>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="card-footer text-right">
                            <button class="btn btn-dark" type="submit"><?php echo __('admin.create'); ?></button>
                        </div>
                </div>
            </form>
            </div>
            <script>
            function selectAllPackages() {
                let select = document.getElementById("applicable_products");
                for (let option of select.options) {
                    option.selected = true;
                }
            }
            function updateType() {
                if(document.getElementById("discount_type").value == 'flat') {
                    document.getElementById("type").innerHTML = '<?php echo e(currency("symbol")); ?>';
                } else {
                    document.getElementById("type").innerHTML = '%';
                }
            }
            </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => 'Coupons', 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/coupons/create.blade.php ENDPATH**/ ?>