<?php $__env->startSection('css_libraries'); ?>
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <div class="row">
        <div class="col-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4><?php echo e(__('admin.edit_package')); ?></h4>
                </div>
                <div class="card-body">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item">
                            <a onclick="openTab('home')" class="nav-link nav-link-tab active" id="home_tab"
                               data-toggle="tab"
                               href="#home" role="tab" aria-controls="home"
                               aria-selected="true"><?php echo e(__('admin.package')); ?></a>
                        </li>
                        <li class="nav-item">
                            <a onclick="openTab('features')" class="nav-link nav-link-tab" id="features_tab"
                               data-toggle="tab"
                               href="#features" role="tab" aria-controls="features"
                               aria-selected="false"><?php echo e(__('admin.features')); ?></a>
                        </li>
                        <li class="nav-item">
                            <a onclick="openTab('profile')" class="nav-link nav-link-tab" id="profile_tab"
                               data-toggle="tab"
                               href="#profile" role="tab" aria-controls="profile"
                               aria-selected="false"><?php echo e(__('admin.prices')); ?></a>
                        </li>
                        <li class="nav-item">
                            <a onclick="openTab('contact')" class="nav-link nav-link-tab" id="contact_tab"
                               data-toggle="tab"
                               href="#contact" role="tab" aria-controls="contact"
                               aria-selected="false"><?php echo e(__('admin.service_provider')); ?></a>
                        </li>
                        <li class="nav-item">
                            <a onclick="openTab('emails')" class="nav-link nav-link-tab" id="emails_tab"
                               data-toggle="tab"
                               href="#emails" role="tab" aria-controls="emails" aria-selected="false">
                                <?php echo e(__('admin.emails')); ?></a>
                        </li>
                        <li class="nav-item">
                            <a onclick="openTab('webhooks')" class="nav-link nav-link-tab" id="webhooks_tab"
                               data-toggle="tab"
                               href="#webhooks" role="tab" aria-controls="webhooks" aria-selected="false">
                                <?php echo e(__('admin.webhooks')); ?></a>
                        </li>
                        <li class="nav-item">
                            <a onclick="openTab('links')" class="nav-link nav-link-tab" id="links_tab" data-toggle="tab"
                               href="#links" role="tab" aria-controls="links"
                               aria-selected="false"><?php echo e(__('admin.links')); ?></a>
                        </li>
                    </ul>

                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home_tab">
                            <form action="<?php echo e(route('packages.update', ['package' => $package->id])); ?>" method="POST"
                                  enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <div class="row">
                                    <div class="form-group col-md-12 col-12">
                                        <label for="name"><?php echo e(__('admin.package_name')); ?></label>
                                        <input type="text" name="name" id="name"
                                               placeholder="<?php echo e(__('admin.package_name')); ?>"
                                               class="form-control" value="<?php echo e($package->name); ?>" required=""/>
                                    </div>

                                    <div class="form-group col-md-6 col-6">
                                        <label for="category"><?php echo e(__('admin.category')); ?></label>
                                        <select class="form-control select2 select2-hidden-accessible" name="category"
                                                tabindex="-1" aria-hidden="true">
                                            <?php $__currentLoopData = Categories::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category->id); ?>"
                                                        <?php if($package->category_id == $category->id): ?> selected <?php endif; ?>><?php echo e($category->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group col-md-6 col-6">
                                        <label for="status"><?php echo e(__('admin.package_status')); ?></label>
                                        <select class="form-control select2 select2-hidden-accessible" name="status"
                                                tabindex="-1" aria-hidden="true">
                                            <option value="active" <?php if($package->status == 'active'): ?> selected <?php endif; ?>>
                                                <?php echo e(__('admin.active')); ?>

                                            </option>
                                            <option value="unlisted"
                                                    <?php if($package->status == 'unlisted'): ?> selected <?php endif; ?>>
                                                <?php echo e(__('admin.unlisted_only_users_with_direct_link_can_view')); ?>

                                            </option>
                                            <option value="restricted"
                                                    <?php if($package->status == 'restricted'): ?> selected <?php endif; ?>>
                                                <?php echo e(__('admin.admin_only_only_administrators_can_view')); ?>

                                            </option>
                                            <option value="inactive"
                                                    <?php if($package->status == 'inactive'): ?> selected <?php endif; ?>>
                                                <?php echo e(__('admin.retired_inactive_package_will_not_be_shown_to_new')); ?>

                                            </option>
                                        </select>
                                    </div>

                                    <div class="form-group col-md-12 col-12 mt-3">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="icon" id="customFile">
                                            <label class="custom-file-label"
                                                   for="customFile"><?php echo e(__('admin.choose_file')); ?></label>
                                        </div>
                                    </div>

                                    <div class="form-group col-md-12 col-12">
                                        <label for="description"><?php echo e(__('admin.package_description')); ?></label>
                                        <textarea class="summernote form-control" name="description" id="description"
                                                  style="display: none;">
                                        <?php if(isset($package->description)): ?>
                                                <?php echo $package->description; ?>

                                            <?php endif; ?>
                                        </textarea>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="form-group col-md-6 col-6">
                                        <label for="stock"><?php echo e(__('admin.global_stock')); ?></label>
                                        <input type="number" name="global_stock" id="stock" min="-1"
                                               value="<?php echo e($package->global_quantity); ?>" class="form-control"
                                               required=""/>
                                        <small
                                            class="form-text text-muted"><?php echo __('admin.client_stock_indicates_the_stock_limit_per_client'); ?></small>
                                    </div>

                                    <div class="form-group col-md-6 col-6">
                                        <label for="stock"><?php echo e(__('admin.per_client_stock')); ?></label>
                                        <input type="number" name="client_stock" id="stock" min="-1"
                                               value="<?php echo e($package->client_quantity); ?>" class="form-control"
                                               required=""/>
                                        <small
                                            class="form-text text-muted"><?php echo __('admin.client_stock_indicates_the_stock_limit_per_client'); ?></small>
                                    </div>

                                    <div class="form-group col-md-6 col-6">
                                        <div class="form-group">
                                            <div class="control-label"><?php echo e(__('admin.require_domain')); ?></div>
                                            <label class="custom-switch mt-2">
                                                <input type="checkbox" name="require_domain" class="custom-switch-input"
                                                       value="1" <?php if($package->require_domain): ?> checked <?php endif; ?>>
                                                <span class="custom-switch-indicator"></span>
                                                <span
                                                    class="custom-switch-description"><?php echo e(__('admin.does_this_package_require_the_user_to_have_domain')); ?></span>
                                            </label>
                                        </div>
                                    </div>

                                    <div class="form-group col-md-6 col-6">
                                        <div class="form-group">
                                            <div class="control-label"><?php echo e(__('admin.allow_notes')); ?></div>
                                            <label class="custom-switch mt-2">
                                                <input type="checkbox" name="allow_notes" class="custom-switch-input"
                                                       value="1" <?php if($package->allow_notes): ?> checked <?php endif; ?>>
                                                <span class="custom-switch-indicator"></span>
                                                <span class="custom-switch-description">
                                                    <?php echo e(__('admin.allow_users_to_include_special_notes_additional')); ?>

                                                </span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <button class="btn btn-dark" type="submit"><?php echo e(__('admin.update')); ?></button>
                                </div>
                            </form>
                        </div>
                        <div class="tab-pane fade" id="features" role="tabpanel" aria-labelledby="features_tab">
                            <form action="<?php echo e(route('package.create-feature', $package->id)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="form-group col-md-3 col-6" data-toggle="modal" data-target="#IconModal">
                                        <label for="name"><?php echo e(__('admin.icon')); ?></label>
                                        <input type="text" name="icon" id="feature-icon" placeholder=""
                                               class="form-control" value="" required=""/>
                                    </div>
                                    <div class="form-group col-md-3 col-6">
                                        <label for="icon"><?php echo e(__('admin.color')); ?></label>
                                        <select class="form-control select2 select2-hidden-accessible"
                                                name="color" id="color" tabindex="-1" aria-hidden="true">
                                            <?php $__currentLoopData = config('utils.colors'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($color); ?>"><?php echo e($color); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6 col-12">
                                        <label for="description"><?php echo e(__('admin.description')); ?></label>
                                        <input type="text" name="description" id="description" placeholder=""
                                               class="form-control" value="" required=""/>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <button class="btn btn-primary" type="submit"><?php echo e(__('admin.add_feature')); ?></button>
                                </div>
                            </form>
                            <!-- Modal -->
                            <div class="modal fade" id="IconModal" tabindex="-1" role="dialog"
                                 aria-labelledby="IconModalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-lg" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title"
                                                id="IconModalLabel"><?php echo e(__('admin.select_icon')); ?></h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('admin.close')); ?>">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="row">
                                                <?php $__currentLoopData = config('utils.icons'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $icon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-1 mb-4">
                                                        <div class="bx-md d-flex justify-content-center"
                                                             style="cursor: pointer;" onclick='setIcon("<?php echo e($icon); ?>")'>
                                                            <?php echo $icon; ?>

                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <div class="form-group col-md-12 col-12">
                                                    <label for="description"><?php echo e(__('admin.icon_font')); ?></label>
                                                    <input type="text" name="description" id="custom-icon"
                                                           value="<i class='bx bxs-check-shield' ></i>"
                                                           class="form-control" value="" required=""/>
                                                    <small><?php echo __('admin.custom_icons_on_boxicons_choose_icon'); ?></small>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary"
                                                    data-dismiss="modal"><?php echo e(__('admin.close')); ?></button>
                                            <button type="button" onclick="setFeatureIcon()" class="btn btn-primary"
                                                    data-dismiss="modal"><?php echo e(__('admin.use_icon')); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table table-striped" id="sortable-table">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(__('admin.icon')); ?></th>
                                            <th><?php echo e(__('admin.feature')); ?></th>
                                            <th><?php echo e(__('admin.order_id')); ?></th>
                                            <th class="text-right"><?php echo e(__('admin.action')); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody class="ui-sortable">
                                        <?php $__currentLoopData = $package->features()->orderBy('order', 'desc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><span class='bx-sm text-primary'><?php echo $feature->icon; ?></span></td>
                                                <td class="align-middle">
                                                    <?php echo e($feature->description); ?>

                                                </td>
                                                <td class="align-middle">
                                                    <?php echo e($feature->order); ?>

                                                </td>
                                                <td class="text-right">
                                                    <a href="<?php echo e(route('package.move-feature', ['package' => $package->id, 'feature' => $feature->id, 'direction' => 'up'])); ?>"
                                                       class="btn btn-primary"><i class="fas fa-solid fa-caret-up"></i></a>
                                                    <a href="<?php echo e(route('package.move-feature', ['package' => $package->id, 'feature' => $feature->id, 'direction' => 'down'])); ?>"
                                                       class="btn btn-primary"><i
                                                            class="fas fa-solid fa-caret-down"></i></a>
                                                    <a href="<?php echo e(route('package.destroy-feature', ['package' => $package->id, 'feature' => $feature->id])); ?>"
                                                       class="btn btn-danger"><i class="fas fa-solid fa-trash"></i></a>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile_tab">
                            <button class="btn btn-primary mt-4 mb-4" data-toggle="modal"
                                    data-target="#createPriceModal"><?php echo e(__('admin.new_price')); ?>

                            </button>

                            <table class="table table-striped">
                                <thead>
                                <tr>
                                    <th scope="col"><?php echo e(__('admin.period')); ?></th>
                                    <th scope="col"><?php echo e(__('admin.status')); ?></th>
                                    <th scope="col"><?php echo e(__('admin.price')); ?></th>
                                    <th scope="col"><?php echo e(__('admin.renewal_price')); ?></th>
                                    <th scope="col"><?php echo e(__('admin.setup_fee')); ?></th>
                                    <th scope="col"><?php echo e(__('admin.cancellation_fee')); ?></th>
                                    <th scope="col"><?php echo __('admin.actions'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $prices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($price->type == 'single' ? ucfirst($price->type) : ucfirst($price->type). ' / ' . $price->periodToHuman()); ?></td>
                                        <td>
                                            <?php if($price->is_active): ?>
                                                <div class="flex align-items-center">
                                                    <i class="fas fa-solid fa-circle  text-success "
                                                       style="font-size: 11px;"></i> <?php echo __('admin.active'); ?>

                                                </div>
                                            <?php else: ?>
                                                <div class="flex align-items-center">
                                                    <i class="fas fa-solid fa-circle  text-danger "
                                                       style="font-size: 11px;"></i> <?php echo __('admin.inactive'); ?>

                                                </div>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e(currency('symbol')); ?><?php echo e($price->price); ?></td>
                                        <td><?php echo e(currency('symbol')); ?> <?php if(isset($price->renewal_price)): ?>
                                                <?php echo e($price->renewal_price); ?>

                                            <?php else: ?>
                                                <?php echo e($price->price); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e(currency('symbol')); ?><?php echo e($price->setup_fee); ?></td>
                                        <td><?php echo e(currency('symbol')); ?><?php echo e($price->cancellation_fee); ?></td>
                                        <td>
                                            <button class="btn btn-primary mt-4 mb-4" data-toggle="modal"
                                                    data-target="#editPriceModal-<?php echo e($price->id); ?>"><?php echo e(__('admin.edit')); ?>

                                            </button>
                                            <a href="<?php echo e(route('package_price.delete', ['price' => $price->id])); ?>"
                                               class="btn btn-icon icon-left btn-danger"><?php echo __('admin.delete'); ?></a>
                                        </td>
                                    </tr>

                                    
                                    <div class="modal fade" tabindex="-1" role="dialog"
                                         id="editPriceModal-<?php echo e($price->id); ?>">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <form
                                                    action="<?php echo e(route('package_price.update', ['price' => $price->id])); ?>"
                                                    method="POST" enctype="multipart/form-data">
                                                    <?php echo csrf_field(); ?>
                                                    <div class="modal-header">
                                                        <h5 class="modal-title"><?php echo e(__('admin.editing_price_cycle')); ?></h5>
                                                        <button type="button" class="close" data-dismiss="modal"
                                                                aria-label="<?php echo e(__('admin.close')); ?>">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body modal-lg">

                                                        <div class="form-group">
                                                            <label for="type"><?php echo e(__('admin.type')); ?></label>
                                                            <select class="form-control select2 select2-hidden-accessible hide" id="type-<?php echo e($price->id); ?>"
                                                                    name="type" tabindex="-1" aria-hidden="true" onchange="setPriceType('<?php echo e($price->id); ?>')">
                                                                <option value="single" <?php if($price->type == 'single'): ?> selected <?php endif; ?>><?php echo e(__('admin.single')); ?></option>
                                                                <option value="recurring" <?php if($price->type == 'recurring'): ?> selected <?php endif; ?>><?php echo e(__('admin.recurring')); ?></option>
                                                            </select>
                                                        </div>

                                                        <div class="row <?php if($price->type == 'single'): ?> d-none <?php endif; ?>" id="recurring-options-<?php echo e($price->id); ?>">
                                                            <div class="form-group col-md-12 col-12">
                                                                <label for="period"><?php echo e(__('admin.period')); ?></label>
                                                                <select
                                                                    class="form-control select2 select2-hidden-accessible hide"
                                                                    id="period" name="period" tabindex="-1"
                                                                    aria-hidden="true">
                                                                    <option value="1"
                                                                            <?php if($price->period == 1): ?> selected <?php endif; ?>>
                                                                        <?php echo e(__('admin.daily')); ?>

                                                                    </option>
                                                                    <option value="7"
                                                                            <?php if($price->period == 7): ?> selected <?php endif; ?>>
                                                                        <?php echo e(__('admin.weekly')); ?>

                                                                    </option>
                                                                    <option value="30"
                                                                            <?php if($price->period == 30): ?> selected <?php endif; ?>>
                                                                        <?php echo e(__('admin.monthly')); ?>

                                                                    </option>
                                                                    <option value="90"
                                                                            <?php if($price->period == 90): ?> selected <?php endif; ?>>
                                                                        <?php echo e(__('admin.quaterly')); ?>

                                                                    </option>
                                                                    <option value="365"
                                                                            <?php if($price->period == 365): ?> selected <?php endif; ?>>
                                                                        <?php echo e(__('admin.yearly')); ?>

                                                                    </option>
                                                                    <option value="730"
                                                                            <?php if($price->period == 730): ?> selected <?php endif; ?>>
                                                                        <?php echo __('admin.per_years', ['years' => 2]); ?>

                                                                    </option>
                                                                    <option value="1825"
                                                                            <?php if($price->period == 1825): ?> selected <?php endif; ?>>
                                                                        <?php echo __('admin.per_years', ['years' => 5]); ?>

                                                                    </option>
                                                                    <option value="3650"
                                                                            <?php if($price->period == 3650): ?> selected <?php endif; ?>>
                                                                        <?php echo __('admin.per_years', ['years' => 10]); ?>

                                                                    </option>
                                                                </select>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <div class="form-group col-md-12 col-12">
                                                                <label for="price"><?php echo e(__('admin.price')); ?></label>
                                                                <input onInput="updateRenewal(<?php echo e($price->id); ?>)"
                                                                       type="number" name="price"
                                                                       id="price-<?php echo e($price->id); ?>" min="0"
                                                                       step="0.01" value="<?php echo e($price->price); ?>"
                                                                       class="form-control" required=""/>
                                                            </div>

                                                            <div class="form-group col-md-12 col-12">
                                                                <label for="setup_fee"><?php echo e(__('admin.setup_fee')); ?></label>
                                                                <input type="number" name="setup_fee" id="setup_fee"
                                                                       min="0.00" step="0.01"
                                                                       value="<?php echo e($price->setup_fee); ?>"
                                                                       class="form-control"
                                                                       required=""/>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <div class="form-group col-md-12 col-12">
                                                                <label for="price"><?php echo e(__('admin.data')); ?></label>
                                                                <textarea type="text" name="data"
                                                                          id="data-<?php echo e($price->id); ?>"
                                                                          class="form-control"><?php echo json_encode($price->data, 15, 512) ?></textarea>
                                                                <small><?php echo e(__('admin.data_for_custom_gateways_should_be_left_empty')); ?></small>
                                                            </div>
                                                        </div>

                                                        <div class="row <?php if($price->type == 'single'): ?> d-none <?php endif; ?>" id="price-options-<?php echo e($price->id); ?>">
                                                            <div class="form-group col-md-6 col-6">
                                                                <div class="control-label"><?php echo e(__('admin.renewal_price')); ?></div>
                                                                <label class="custom-switch mt-2">
                                                                    <input onchange="checkbox(<?php echo e($price->id); ?>)"
                                                                           type="checkbox"
                                                                           id="enable-renewal-price-<?php echo e($price->id); ?>"
                                                                           name="enable-renewal-price"
                                                                           class="custom-switch-input">
                                                                    <span class="custom-switch-indicator"></span>
                                                                    <span class="custom-switch-description"><?php echo e(__('admin.use_custom_renewal_price')); ?></span>
                                                                </label>
                                                            </div>

                                                            <div class="form-group col-md-6 col-6">
                                                                <label for="renewal_price" data-toggle="tooltip"
                                                                       data-placement="right" title=""
                                                                       data-original-title="Renewal price refers to the cost of renewing a subscription, service or contract after the initial period at a possibly different rate."><?php echo e(__('admin.renewal_price')); ?> <i
                                                                        class="fa-solid fa-circle-info"></i></label>
                                                                <input type="number" name="renewal_price"
                                                                       id="renewal_price-<?php echo e($price->id); ?>" min="0.00"
                                                                       value="<?php echo e($price->renewal_price); ?>" step="0.01"
                                                                       class="form-control" disabled/>
                                                            </div>

                                                            <div class="form-group col-md-6 col-6">
                                                                <div class="control-label"><?php echo e(__('admin.cancelled_fee')); ?></div>
                                                                <label class="custom-switch mt-2">
                                                                    <input type="checkbox"
                                                                           onchange="checkbox(<?php echo e($price->id); ?>)"
                                                                           id="enable-cancellation-fee-<?php echo e($price->id); ?>"
                                                                           name="enable-cancellation-fee"
                                                                           class="custom-switch-input">
                                                                    <span class="custom-switch-indicator"></span>
                                                                    <span class="custom-switch-description"><?php echo e(__('admin.setup_cancellation_fee')); ?></span>
                                                                </label>
                                                            </div>

                                                            <div class="form-group col-md-6 col-6">
                                                                <label for="cancellation_fee" data-toggle="tooltip"
                                                                       data-placement="right" title=""
                                                                       data-original-title="Cancellation fee is a charge for ending a contract or service agreement before its end date."><?php echo e(__('admin.cancelled_fee')); ?> <i class="fa-solid fa-circle-info"></i></label>
                                                                <input type="number" name="cancellation_fee"
                                                                       id="cancellation_fee-<?php echo e($price->id); ?>"
                                                                       value="<?php echo e($price->cancellation_fee); ?>" min="0.00"
                                                                       step="0.01" class="form-control" disabled/>
                                                            </div>

                                                        </div>
                                                        <div class="">
                                                            <div class="form-group">
                                                                <div class="control-label"><?php echo e(__('admin.active')); ?></div>
                                                                <label class="custom-switch mt-2">
                                                                    <input type="checkbox" name="is_active"
                                                                           class="custom-switch-input" value="1"
                                                                           <?php if($price->is_active): ?> checked <?php endif; ?>>
                                                                    <span class="custom-switch-indicator"></span>
                                                                    <span class="custom-switch-description"><?php echo e(__('admin.you_can_deactivate_price_if_you_no_longer')); ?></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer bg-whitesmoke br">
                                                        <button type="button" class="btn btn-secondary"
                                                                data-dismiss="modal"><?php echo e(__('admin.close')); ?>

                                                        </button>
                                                        <button class="btn btn-primary" type="submit"><?php echo e(__('admin.update')); ?></button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>

                            <?php if(Prices::where('package_id', $package->id)->count() == 0): ?>
                                <?php echo $__env->make(AdminTheme::path('empty-state'), [
                                    'title' => 'No prices found',
                                    'description' => 'This package is unlisted, please create a price.',
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>
                        </div>
                        <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact_tab">
                            <div class="form-group col-md-12 col-12">
                                <label for="service"><?php echo e(__('admin.service_provider')); ?></label>
                                <select class="form-control select2 select2-hidden-accessible"
                                        onchange="updateService()"
                                        name="service" id="service" tabindex="-1" aria-hidden="true">
                                    <?php $__currentLoopData = Service::allEnabled(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($service->module()->getLowerName()); ?>"
                                                <?php if($package->service == $service->module()->getLowerName()): ?> selected <?php endif; ?>><?php echo e($service->about()->display_name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <hr>

                            <?php if ($__env->exists(AdminTheme::serviceView($package->service, 'params'))) echo $__env->make(AdminTheme::serviceView($package->service, 'params'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            
                            <?php if($package->service()->hasPackageConfig($package)): ?>
                            <form action="<?php echo e(route('package.update-service', $package->id)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <?php $__currentLoopData = $package->service()->getPackageConfig($package)->all() ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-group <?php if(isset($field['col'])): ?> <?php echo e($field['col']); ?> <?php else: ?> col-6 <?php endif; ?>" style="display: flex;flex-direction: column;">
                                        <label><?php echo $field['name']; ?></label>
                                        <?php if($field['type'] == 'select'): ?>
                                        <select class="form-control select2 select2-hidden-accessible" tabindex="-1" aria-hidden="true"
                                        name="<?php echo e($field['key']); ?>"
                                        id="<?php echo e($field['key']); ?>"
                                        <?php if(isset($field['save_on_change']) AND $field['save_on_change']): ?> onchange="saveServiceSettings()" <?php endif; ?>
                                        <?php if(isset($field['multiple']) AND $field['multiple']): ?> multiple <?php endif; ?>
                                        >
                                            <?php $__currentLoopData = $field['options'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>"
                                            <?php if(in_array($key, (array) $package->data(Str::remove("[]", $field['key']), $field['default_value'] ?? ''))): ?> selected <?php endif; ?>
                                            ><?php echo e($option); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php elseif($field['type'] == 'bool'): ?>
                                        <label class="custom-switch mt-2">
                                            <input type="checkbox" name="<?php echo e($field['key']); ?>" <?php if(isset($field['save_on_change']) AND $field['save_on_change']): ?> onchange="saveServiceSettings()" <?php endif; ?> value="1" class="custom-switch-input" <?php if($package->data($field['key'], $field['default_value'] ?? '')): ?> checked <?php endif; ?>>
                                            <span class="custom-switch-indicator"></span>
                                          </label>
                                        <?php else: ?>
                                        <input class="form-control"
                                        type="<?php echo e($field['type']); ?>"
                                        name="<?php echo e($field['key']); ?>"
                                        id="<?php echo e($field['key']); ?>"
                                        <?php if(isset($field['min'])): ?> min="<?php echo e($field['min']); ?>" <?php endif; ?>
                                        <?php if(isset($field['max'])): ?> max="<?php echo e($field['max']); ?>" <?php endif; ?>
                                        <?php if(isset($field['save_on_change']) AND $field['save_on_change']): ?> onchange="saveServiceSettings()" <?php endif; ?>
                                        value="<?php echo e($package->data($field['key'], $field['default_value'] ?? '')); ?>"
                                        placeholder="<?php if(isset($field['placeholder'])): ?><?php echo e($field['placeholder']); ?> <?php else: ?><?php echo e($field['name']); ?> <?php endif; ?>"
                                        <?php if(in_array('required', $field['rules'])): ?> required="" <?php endif; ?>>
                                        <?php endif; ?>
                                        <small class="form-text text-muted">
                                            <?php echo $field['description']; ?>

                                        </small>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-12">
                                        <div class="text-right">
                                            <button class="btn btn-primary" id="service-settings-submit" type="submit">Update</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <?php endif; ?>

                            <script>
                                function saveServiceSettings()
                                {
                                    document.getElementById('service-settings-submit').click();
                                }
                            </script>

                        </div>
                        <div class="tab-pane fade" id="emails" role="tabpanel" aria-labelledby="emails_tab">
                            <!-- Button trigger modal -->
                            <button type="button" class="btn btn-primary mt-4 mb-4" data-toggle="modal"
                                    data-target="#createEmail">
                                <?php echo e(__('admin.create')); ?>

                            </button>

                            <div class="alert alert-info alert-dismissible fade show" role="alert">
                                WemX already sends a set of emails when an order is cancelled, suspended or terminated.
                                You can configure them <a target="_blank"
                                                          href="/admin/emails/messages"><strong>here</strong></a>
                                - This page provides you more customibility to send package specific emails.
                                <button type="button" class="close" data-dismiss="alert" aria-label="<?php echo e(__('admin.close')); ?>">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>

                            <?php if(PackageEmail::where('package_id', $package->id)->count() == 0): ?>
                                <?php echo $__env->make(AdminTheme::path('empty-state'), [
                                    'title' => 'No emails found',
                                    'description' => 'You haven\'t created any emails for this package',
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>

                            <!-- Create Email Modal -->
                            <div class="modal fade bd-example-modal-lg" id="createEmail" tabindex="-1" role="dialog"
                                 aria-labelledby="createEmailLabel" aria-hidden="true">
                                <div class="modal-dialog modal-lg" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="createEmailLabel"><?php echo e(__('admin.email_event')); ?></h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('admin.close')); ?>">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <form action="<?php echo e(route('packages.emails.create', $package->id)); ?>" method="POST"
                                              enctype="multipart/form-data">
                                            <div class="modal-body">
                                                <?php echo csrf_field(); ?>
                                                <div class="mb-4">
                                                    <label for="event"><?php echo e(__('admin.event')); ?></label>
                                                    <select class="form-control select2 select2-hidden-accessible"
                                                            name="event"
                                                            tabindex="-1" aria-hidden="true">
                                                        <option value="creation">
                                                            <?php echo e(__('admin.creation')); ?>

                                                        </option>
                                                        <option value="renewal">
                                                            <?php echo e(__('admin.renewal')); ?>

                                                        </option>
                                                        <option value="upgrade">
                                                            <?php echo e(__('admin.upgrade')); ?>

                                                        </option>
                                                        <option value="suspension">
                                                            <?php echo e(__('admin.suspension')); ?>

                                                        </option>
                                                        <option value="unsuspension">
                                                            <?php echo e(__('admin.unsuspension')); ?>

                                                        </option>
                                                        <option value="cancellation">
                                                            <?php echo e(__('admin.cancellation')); ?>

                                                        </option>
                                                        <option value="termination">
                                                            <?php echo e(__('admin.termination')); ?>

                                                        </option>
                                                    </select>
                                                </div>

                                                <div class="mb-4">
                                                    <label for="title"><?php echo e(__('admin.email_title')); ?></label>
                                                    <input type="text" name="title" id="title" placeholder="<?php echo e(__('admin.subject')); ?>"
                                                           class="form-control" required=""/>
                                                </div>

                                                <div class="">
                                                    <label for="body"><?php echo e(__('admin.email_body')); ?></label>
                                                    <textarea class="summernote form-control" name="body" id="body"
                                                              style="display: none;">
                                                </textarea>
                                                    <small class="form-text text-muted"></small>
                                                </div>

                                                <div class="form-group" style="display: flex;flex-direction: column;">
                                                    <label for="myfile"><?php echo e(__('admin.select_a_file_optional')); ?></label>
                                                    <input class="" type="file" id="myfile" name="attachment">
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                                                    <?php echo e(__('admin.close')); ?>

                                                </button>
                                                <button type="submit" class="btn btn-primary"><?php echo e(__('admin.create')); ?></button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table table-striped table-md">
                                        <tbody>
                                        <?php if($package->emails->count() > 0): ?>
                                            <tr>
                                                <th><?php echo e(__('admin.event')); ?></th>
                                                <th><?php echo e(__('admin.title')); ?></th>
                                                <th class="text-right"><?php echo e(__('admin.last_updated')); ?></th>
                                                <th class="text-right"><?php echo e(__('admin.action')); ?></th>
                                            </tr>
                                        <?php endif; ?>
                                        <?php $__currentLoopData = $package->emails->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $email): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($email->event); ?></td>
                                                <td><?php echo e($email->title); ?></td>
                                                <td class="text-right"><?php echo e($email->updated_at->diffForHumans()); ?></td>
                                                <td class="text-right">
                                                    <a href="<?php echo e(route('packages.emails.delete', ['email' => $email->id])); ?>"
                                                       class="btn btn-icon btn-danger"><i class="fas fa-trash-alt"></i></a>
                                                    <button data-toggle="modal" data-target="#editEmail<?php echo e($email->id); ?>"
                                                            class="btn btn-primary"><?php echo e(__('admin.manage')); ?>

                                                    </button>
                                                </td>
                                            </tr>

                                            <!-- Create Email Modal -->
                                            <div class="modal fade bd-example-modal-lg" id="editEmail<?php echo e($email->id); ?>"
                                                 tabindex="-1" role="dialog"
                                                 aria-labelledby="editEmail<?php echo e($email->id); ?>Label" aria-hidden="true">
                                                <div class="modal-dialog modal-lg" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="editEmail<?php echo e($email->id); ?>Label">
                                                                <?php echo e(__('admin.email_event')); ?></h5>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                    aria-label="<?php echo e(__('admin.close')); ?>">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <form
                                                            action="<?php echo e(route('packages.emails.update', ['email' => $email->id])); ?>"
                                                            method="POST" enctype="multipart/form-data">
                                                            <div class="modal-body">
                                                                <?php echo csrf_field(); ?>
                                                                <div class="mb-4">
                                                                    <label for="event"><?php echo e(__('admin.event')); ?></label>
                                                                    <select
                                                                        class="form-control select2 select2-hidden-accessible"
                                                                        name="event"
                                                                        tabindex="-1" aria-hidden="true">
                                                                        <option value="creation"
                                                                                <?php if($email->event == 'creation'): ?> selected <?php endif; ?>>
                                                                            <?php echo e(__('admin.creation')); ?>

                                                                        </option>
                                                                        <option value="renewal"
                                                                                <?php if($email->event == 'renewal'): ?> selected <?php endif; ?>>
                                                                            <?php echo e(__('admin.renewal')); ?>

                                                                        </option>
                                                                        <option value="upgrade"
                                                                                <?php if($email->event == 'upgrade'): ?> selected <?php endif; ?>>
                                                                            <?php echo e(__('admin.upgrade')); ?>

                                                                        </option>
                                                                        <option value="suspension"
                                                                                <?php if($email->event == 'suspension'): ?> selected <?php endif; ?>>
                                                                            <?php echo e(__('admin.suspension')); ?>

                                                                        </option>
                                                                        <option value="unsuspension"
                                                                                <?php if($email->event == 'unsuspension'): ?> selected <?php endif; ?>>
                                                                            <?php echo e(__('admin.unsuspension')); ?>

                                                                        </option>
                                                                        <option value="cancellation"
                                                                                <?php if($email->event == 'cancellation'): ?> selected <?php endif; ?>>
                                                                            <?php echo e(__('admin.cancellation')); ?>

                                                                        </option>
                                                                        <option value="termination"
                                                                                <?php if($email->event == 'termination'): ?> selected <?php endif; ?>>
                                                                            <?php echo e(__('admin.termination')); ?>

                                                                        </option>
                                                                    </select>
                                                                </div>

                                                                <div class="mb-4">
                                                                    <label for="title"><?php echo e(__('admin.email_title')); ?></label>
                                                                    <input type="text" name="title" id="title"
                                                                           value="<?php echo e($email->title); ?>"
                                                                           placeholder="<?php echo e(__('admin.subject')); ?>"
                                                                           class="form-control" required=""/>
                                                                </div>

                                                                <div class="">
                                                                    <label for="body"><?php echo e(__('admin.email_body')); ?></label>
                                                                    <textarea class="summernote form-control"
                                                                              name="body" id="body"
                                                                              style="display: none;">
                                                                        <?php echo $email->body; ?>

                                                                    </textarea>
                                                                    <small class="form-text text-muted"></small>
                                                                </div>

                                                                <div class="form-group"
                                                                     style="display: flex;flex-direction: column;">
                                                                    <label for="myfile"><?php echo e(__('admin.select_a_file_optional')); ?></label>
                                                                    <input class="" type="file" id="myfile"
                                                                           name="attachment">
                                                                </div>

                                                                <?php if($email->attachment): ?>
                                                                    <span
                                                                        class="badge badge-pill badge-secondary"><?php echo e(basename($email->attachment)); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary"
                                                                        data-dismiss="modal"><?php echo e(__('admin.close')); ?>

                                                                </button>
                                                                <button type="submit" class="btn btn-primary"><?php echo e(__('admin.update')); ?>

                                                                </button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </div>
                        <div class="tab-pane fade" id="webhooks" role="tabpanel" aria-labelledby="webhooks_tab">
                            <!-- Button trigger modal -->
                            <button type="button" class="btn btn-primary mt-4 mb-4" data-toggle="modal"
                                    data-target="#createWebhook">
                                <?php echo e(__('admin.create')); ?>

                            </button>

                            <div class="alert alert-info alert-dismissible fade show" role="alert">
                                Package webhooks are a powerful feature allowing you to do a huge amount of things. You
                                can also use custom variables inside webhooks. <a
                                    href="https://docs.wemx.net/en/setup/packages#package-webhooks" target="_blank">Learn
                                    More</a>
                            </div>

                            <?php if($package->webhooks->count() == 0): ?>
                                <?php echo $__env->make(AdminTheme::path('empty-state'), [
                                    'title' => 'No webhooks found',
                                    'description' => 'You haven\'t created any webhooks for this package',
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>

                            <!-- Create Webhook Modal -->
                            <div class="modal fade bd-example-modal-lg" id="createWebhook" tabindex="-1" role="dialog"
                                 aria-labelledby="createWebhookLabel" aria-hidden="true">
                                <div class="modal-dialog modal-lg" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="createWebhookLabel"><?php echo e(__('admin.webhook_event')); ?></h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('admin.close')); ?>">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <form action="<?php echo e(route('packages.webhooks.create', $package->id)); ?>"
                                              method="POST" enctype="multipart/form-data">
                                            <div class="modal-body">
                                                <?php echo csrf_field(); ?>
                                                <div class="mb-4">
                                                    <label for="event"><?php echo e(__('admin.event')); ?></label>
                                                    <select class="form-control select2 select2-hidden-accessible"
                                                            name="event"
                                                            tabindex="-1" aria-hidden="true">
                                                        <option value="creation">
                                                            <?php echo e(__('admin.creation')); ?>

                                                        </option>
                                                        <option value="renewal">
                                                            <?php echo e(__('admin.renewal')); ?>

                                                        </option>
                                                        <option value="upgrade">
                                                            <?php echo e(__('admin.upgrade')); ?>

                                                        </option>
                                                        <option value="suspension">
                                                            <?php echo e(__('admin.suspension')); ?>

                                                        </option>
                                                        <option value="unsuspension">
                                                            <?php echo e(__('admin.unsuspension')); ?>

                                                        </option>
                                                        <option value="cancellation">
                                                            <?php echo e(__('admin.cancellation')); ?>

                                                        </option>
                                                        <option value="termination">
                                                            <?php echo e(__('admin.termination')); ?>

                                                        </option>
                                                    </select>
                                                </div>

                                                <div class="mb-4">
                                                    <label for="method"><?php echo e(__('admin.method')); ?></label>
                                                    <select class="form-control select2 select2-hidden-accessible"
                                                            name="method"
                                                            tabindex="-1" aria-hidden="true">

                                                        <?php $__currentLoopData = ['get', 'post', 'put', 'patch', 'delete', 'head']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($method); ?>"
                                                                    style="text-transform: uppsercase">
                                                                <?php echo e(strtoupper($method)); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    </select>
                                                </div>

                                                <div class="mb-4">
                                                    <label for="url"><?php echo e(__('admin.url')); ?></label>
                                                    <input type="url" name="url" id="url"
                                                           placeholder="https://example.com/api/v1"
                                                           class="form-control" required=""/>
                                                </div>

                                                <div class="mb-4">
                                                    <label for="data"><?php echo e(__('admin.data')); ?></label>
                                                    <textarea class="form-control" name="data" id="data"
                                                              placeholder='{"key": "value"}'
                                                              style="height: 200px !important"></textarea>
                                                    <small class="form-text text-muted"></small>
                                                </div>

                                                <div class="mb-4">
                                                    <label for="headers"><?php echo e(__('admin.headers')); ?></label>
                                                    <textarea class="form-control" name="headers" id="headers"
                                                              placeholder='{"Authorization": "Bearer apikey"}'></textarea>
                                                    <small class="form-text text-muted"></small>
                                                </div>

                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                                                    <?php echo e(__('admin.close')); ?>

                                                </button>
                                                <button type="submit" class="btn btn-primary"><?php echo e(__('admin.create')); ?></button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table table-striped table-md">
                                        <tbody>
                                        <?php if($package->webhooks->count() > 0): ?>
                                            <tr>
                                                <th><?php echo e(__('admin.event')); ?></th>
                                                <th><?php echo e(__('admin.method')); ?></th>
                                                <th class="text-right"><?php echo e(__('admin.last_updated')); ?></th>
                                                <th class="text-right"><?php echo e(__('admin.action')); ?></th>
                                            </tr>
                                        <?php endif; ?>
                                        <?php $__currentLoopData = $package->webhooks->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $webhook): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($webhook->event); ?></td>
                                                <td><?php echo e($webhook->method); ?></td>
                                                <td class="text-right"><?php echo e($webhook->updated_at->diffForHumans()); ?></td>
                                                <td class="text-right">
                                                    <a href="<?php echo e(route('packages.webhooks.delete', ['webhook' => $webhook->id])); ?>"
                                                       class="btn btn-icon btn-danger"><i class="fas fa-trash-alt"></i></a>
                                                    <button data-toggle="modal"
                                                            data-target="#editWebhook<?php echo e($webhook->id); ?>"
                                                            class="btn btn-primary"><?php echo e(__('admin.manage')); ?>

                                                    </button>
                                                </td>
                                            </tr>

                                            <!-- Create Email Modal -->
                                            <div class="modal fade bd-example-modal-lg" id="editWebhook<?php echo e($webhook->id); ?>"
                                                 tabindex="-1" role="dialog"
                                                 aria-labelledby="editWebhook<?php echo e($webhook->id); ?>Label" aria-hidden="true">
                                                <div class="modal-dialog modal-lg" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title"
                                                                id="editWebhook<?php echo e($webhook->id); ?>Label"><?php echo e(__('admin.webhook_event')); ?></h5>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                    aria-label="<?php echo e(__('admin.close')); ?>">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <form
                                                            action="<?php echo e(route('packages.webhooks.update', ['webhook' => $webhook->id])); ?>"
                                                            method="POST" enctype="multipart/form-data">
                                                            <div class="modal-body">
                                                                <?php echo csrf_field(); ?>
                                                                <div class="mb-4">
                                                                    <label for="event"><?php echo e(__('admin.event')); ?></label>
                                                                    <select
                                                                        class="form-control select2 select2-hidden-accessible"
                                                                        name="event"
                                                                        tabindex="-1" aria-hidden="true">
                                                                        <option value="creation"
                                                                                <?php if($webhook->event == 'creation'): ?> selected <?php endif; ?>>
                                                                            <?php echo e(__('admin.creation')); ?>

                                                                        </option>
                                                                        <option value="renewal"
                                                                                <?php if($webhook->event == 'renewal'): ?> selected <?php endif; ?>>
                                                                            <?php echo e(__('admin.renewal')); ?>

                                                                        </option>
                                                                        <option value="upgrade"
                                                                                <?php if($webhook->event == 'upgrade'): ?> selected <?php endif; ?>>
                                                                            <?php echo e(__('admin.upgrade')); ?>

                                                                        </option>
                                                                        <option value="suspension"
                                                                                <?php if($webhook->event == 'suspension'): ?> selected <?php endif; ?>>
                                                                            <?php echo e(__('admin.suspension')); ?>

                                                                        </option>
                                                                        <option value="unsuspension"
                                                                                <?php if($webhook->event == 'unsuspension'): ?> selected <?php endif; ?>>
                                                                            <?php echo e(__('admin.unsuspension')); ?>

                                                                        </option>
                                                                        <option value="cancellation"
                                                                                <?php if($webhook->event == 'cancellation'): ?> selected <?php endif; ?>>
                                                                            <?php echo e(__('admin.cancellation')); ?>

                                                                        </option>
                                                                        <option value="termination"
                                                                                <?php if($webhook->event == 'termination'): ?> selected <?php endif; ?>>
                                                                            <?php echo e(__('admin.termination')); ?>

                                                                        </option>
                                                                    </select>
                                                                </div>

                                                                <div class="mb-4">
                                                                    <label for="method"><?php echo e(__('admin.method')); ?></label>
                                                                    <select
                                                                        class="form-control select2 select2-hidden-accessible"
                                                                        name="method"
                                                                        tabindex="-1" aria-hidden="true">

                                                                        <?php $__currentLoopData = ['get', 'post', 'put', 'patch', 'delete', 'head']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <option value="<?php echo e($method); ?>"
                                                                                    style="text-transform: uppsercase"
                                                                                    <?php if($webhook->method == $method): ?> selected <?php endif; ?>>
                                                                                <?php echo e(strtoupper($method)); ?>

                                                                            </option>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                                    </select>
                                                                </div>

                                                                <div class="mb-4">
                                                                    <label for="url"><?php echo e(__('admin.url')); ?></label>
                                                                    <input type="url" name="url" id="url"
                                                                           placeholder="https://example.com/api/v1"
                                                                           class="form-control"
                                                                           value="<?php echo e($webhook->url); ?>" required=""/>
                                                                </div>

                                                                <div class="mb-4">
                                                                    <label for="data"><?php echo e(__('admin.data')); ?></label>
                                                                    <textarea class="form-control" name="data" id="data"
                                                                              placeholder='{"key": "value"}'
                                                                              style="height: 200px !important"><?php echo e(json_encode($webhook->data, JSON_PRETTY_PRINT)); ?></textarea>
                                                                    <small class="form-text text-muted"></small>
                                                                </div>

                                                                <div class="mb-4">
                                                                    <label for="headers"><?php echo e(__('admin.headers')); ?></label>
                                                                    <textarea class="form-control" name="headers"
                                                                              id="headers"
                                                                              placeholder='{"Authorization": "Bearer apikey"}'><?php echo e(json_encode($webhook->headers, JSON_PRETTY_PRINT)); ?></textarea>
                                                                    <small class="form-text text-muted"></small>
                                                                </div>

                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary"
                                                                        data-dismiss="modal"><?php echo e(__('admin.close')); ?>

                                                                </button>
                                                                <button type="submit" class="btn btn-primary"><?php echo e(__('admin.update')); ?>

                                                                </button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </div>
                        <div class="tab-pane fade" id="links" role="tabpanel" aria-labelledby="links_tab">
                            <div class="row">
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.package_checkout')); ?></label>
                                    <input type="text" class="form-control"
                                           value="<?php echo e(route('store.package', $package->id)); ?>" readonly="">
                                    <small class="form-text text-muted">
                                        <?php echo e(__('admin.direct_link_to_the_checkout_page_on_your_application')); ?>

                                    </small>
                                </div>
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.package_process_payment')); ?></label>
                                    <input type="text" class="form-control"
                                           value="<?php echo e(route('payment.package', ['package' => $package->id, 'price_id' => '1', 'gateway' => '1'])); ?>"
                                           readonly="">
                                    <small class="form-text text-muted">
                                        <?php echo e(__('admin.important_replace_price_id_with_the_id')); ?>

                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    
    <div class="modal fade" tabindex="-1" role="dialog" id="createPriceModal">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form action="<?php echo e(route('package_price.create', ['package' => $package->id])); ?>" method="POST"
                      enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('admin.create_price')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('admin.close')); ?>">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        
                        <div class="form-group">
                            <label for="type"><?php echo e(__('admin.type')); ?></label>
                            <select class="form-control select2 select2-hidden-accessible hide" id="type-0"
                                    name="type" tabindex="-1" aria-hidden="true" onchange="setPriceType('0')">
                                <option value="single"><?php echo e(__('admin.single')); ?></option>
                                <option value="recurring" selected><?php echo e(__('admin.recurring')); ?></option>
                            </select>
                        </div>
                        
                        <div class="row" id="recurring-options-0">
                            <div class="form-group col-md-12 col-12">
                                <label for="period"><?php echo e(__('admin.period')); ?></label>
                                <select class="form-control select2 select2-hidden-accessible hide" id="period"
                                        name="period" tabindex="-1" aria-hidden="true">
                                    <option value="1"><?php echo e(__('admin.daily')); ?></option>
                                    <option value="7"><?php echo e(__('admin.weekly')); ?></option>
                                    <option value="30" selected><?php echo e(__('admin.monthly')); ?></option>
                                    <option value="90"><?php echo e(__('admin.quaterly')); ?></option>
                                    <option value="365"><?php echo e(__('admin.yearly')); ?></option>
                                    <option value="730"><?php echo __('admin.per_years', ['years' => 2]); ?></option>
                                    <option value="1825"><?php echo __('admin.per_years', ['years' => 5]); ?></option>
                                    <option value="3650"><?php echo __('admin.per_years', ['years' => 10]); ?></option>

                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-12 col-12">
                                <label for="price-0"><?php echo e(__('admin.price')); ?></label>
                                <input onInput="updateRenewal(0)" type="number" name="price" id="price-0"
                                       min="0" step="0.01" value="1.00" class="form-control" required=""/>
                            </div>

                            <div class="form-group col-md-12 col-12">
                                <label for="setup_fee"><?php echo e(__('admin.setup_fee')); ?></label>
                                <input type="number" name="setup_fee" id="setup_fee" min="0.00" step="0.01"
                                       value="0.00" class="form-control" required=""/>
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-12 col-12">
                                <label for="data"><?php echo e(__('admin.data')); ?></label>
                                <textarea type="text" name="data" id="data"
                                          class="form-control"></textarea>
                                <small><?php echo e(__('admin.data_for_custom_gateways_should_be_left_empty')); ?></small>
                            </div>
                        </div>

                        <div class="row" id="price-options-0">
                            <div class="form-group col-md-6 col-6">
                                <div class="control-label"><?php echo e(__('admin.renewal_price')); ?></div>
                                <label class="custom-switch mt-2">
                                    <input onchange="checkbox(0)" type="checkbox" id="enable-renewal-price-0"
                                           name="enable-renewal-price" class="custom-switch-input">
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description"><?php echo e(__('admin.use_custom_renewal_price')); ?></span>
                                </label>
                            </div>

                            <div class="form-group col-md-6 col-6">
                                <label for="renewal_price-0" data-toggle="tooltip" data-placement="right" title=""
                                       data-original-title="Renewal price refers to the cost of renewing a subscription, service or contract after the initial period at a possibly different rate."><?php echo __('admin.renewal_price'); ?> <i class="fa-solid fa-circle-info"></i></label>
                                <input type="number" name="renewal_price" id="renewal_price-0" min="0.00"
                                       step="0.01" class="form-control" disabled/>
                            </div>

                            <div class="form-group col-md-6 col-6">
                                <div class="control-label"><?php echo e(__('admin.cancellation_fee')); ?></div>
                                <label class="custom-switch mt-2">
                                    <input type="checkbox" onchange="checkbox(0)" id="enable-cancellation-fee-0"
                                           name="enable-cancellation-fee" class="custom-switch-input">
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description"><?php echo e(__('admin.setup_cancellation_fee')); ?></span>
                                </label>
                            </div>

                            <div class="form-group col-md-6 col-6">
                                <label for="cancellation_fee-0" data-toggle="tooltip" data-placement="right"
                                       title=""
                                       data-original-title="Cancellation fee is a charge for ending a contract or service agreement before its end date.">
                                    <?php echo __('admin.cancellation_fee'); ?> <i class="fa-solid fa-circle-info"></i></label>
                                <input type="number" name="cancellation_fee" id="cancellation_fee-0" min="0.00"
                                       step="0.01" class="form-control" disabled/>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer bg-whitesmoke br">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('admin.close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('admin.create')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        const storedTabId = localStorage.getItem('activeTab');

        if (storedTabId) {
            openTab(storedTabId);
        } else {
            openTab('home');
        }

        function openTab(tabId) {
            const tabLinks = document.querySelectorAll('.nav-link-tab');
            const tabContents = document.querySelectorAll('.tab-pane');

            tabLinks.forEach(link => {
                link.classList.remove('active');
                link.addEventListener('click', function (e) {
                    e.preventDefault();
                    openTab(link.getAttribute('href').substr(1));
                });
            });

            tabContents.forEach(content => {
                content.classList.remove('show', 'active');
            });

            document.querySelector('.nav-link-tab[href="#' + tabId + '"]').classList.add('active');
            document.getElementById(tabId).classList.add('show', 'active');
            localStorage.setItem('activeTab', tabId);
        }

        function updateRenewal(id) {
            if (document.getElementById('enable-renewal-price-' + id).checked == false) {
                document.getElementById('renewal_price-' + id).value = document.getElementById('price-' + id).value;
            }
        }

        function checkbox(id) {
            if (document.getElementById('enable-renewal-price-' + id).checked == false) {
                document.getElementById('renewal_price-' + id).setAttribute('disabled', '');
            } else {
                document.getElementById('renewal_price-' + id).removeAttribute('disabled');
            }

            if (document.getElementById('enable-cancellation-fee-' + id).checked == false) {
                document.getElementById('cancellation_fee-' + id).setAttribute('disabled', '');
            } else {
                document.getElementById('cancellation_fee-' + id).removeAttribute('disabled');
            }
        }

        function setPriceType(id) {
            var type = document.getElementById('type-' + id).value;

            if(type == 'single') {
                document.getElementById('recurring-options-' + id).classList.add('d-none');
                document.getElementById('price-options-'+ id).classList.add('d-none');
            } else {
                document.getElementById('recurring-options-'+ id).classList.remove('d-none');
                document.getElementById('price-options-'+ id).classList.remove('d-none');
            }
        }

        function updateService() {
            var service = document.getElementById("service").value;
            if (service) {
                window.location = '/admin/packages/update-service/<?php echo e($package->id); ?>/' + service;
            }
        }

        function setIcon(icon) {
            document.getElementById("custom-icon").value = icon;
        }

        function setFeatureIcon() {
            document.getElementById("feature-icon").value = document.getElementById("custom-icon").value;
        }
    </script>

    <style>
        span.select2.select2-container.select2-container--default {
            width: 100% !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => 'Packages', 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/packages/edit.blade.php ENDPATH**/ ?>