<?php $__env->startSection('container'); ?>
    <section class="section">
        <div class="section-body">
            <div class="col-12 col-md-12 col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4><?php echo e(__('affiliates::general.pavouts')); ?></h4>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-striped table-md">
                                <tbody>
                                <tr>
                                    <th><?php echo __('admin.code'); ?></th>
                                    <th><?php echo __('admin.user'); ?></th>
                                    <th><?php echo __('admin.amount'); ?></th>
                                    <th><?php echo __('admin.status'); ?></th>
                                    <th><?php echo __('admin.create_at'); ?></th>
                                    <th class="text-right"><?php echo __('admin.actions'); ?></th>
                                </tr>

                                <?php $__currentLoopData = $payouts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payout): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><a href="<?php echo e(route('affiliates.edit', $payout->affiliate->id)); ?>"><?php echo e($payout->affiliate->code); ?></a></td>
                                        <td>
                                            <a href="<?php echo e(route('users.edit', ['user' => $payout->user->id])); ?>"
                                               style="display: flex; color: #6c757d">
                                                <img alt="image" src="<?php echo e($payout->user->avatar()); ?>"
                                                     class="rounded-circle mr-1 mt-1" width="32px" height="32px"
                                                     data-toggle="tooltip" title=""
                                                     data-original-title="<?php echo e($payout->user->first_name); ?> <?php echo e($payout->user->last_name); ?>">
                                                <div class="flex">
                                                    <?php echo e($payout->user->username); ?> <br>
                                                    <small><?php echo e($payout->user->email); ?></small>
                                                </div>
                                            </a>
                                        </td>

                                        <td><?php echo e(currency('symbol')); ?><?php echo e(number_format($payout->amount, 2)); ?></td>

                                        <td><?php echo e($payout->status); ?></td>

                                        <td><?php echo e($payout->created_at->translatedFormat(settings('date_format', 'd M Y'))); ?></td>

                                        <td class="text-right">
                                            <a href="<?php echo e(route('affiliates.payouts.edit', ['payouts' => $payout->id])); ?>"
                                               class="btn btn-primary"><?php echo __('admin.manage'); ?>

                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer text-right">
                        <?php echo e($payouts->links(AdminTheme::pagination())); ?>

                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.payments'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/Modules/Affiliates/Resources/views/admin/default/payouts.blade.php ENDPATH**/ ?>