<?php $__env->startSection('title', 'Tickets'); ?>


<?php $__env->startSection('keywords', 'WemX Dashboard, WemX Panel'); ?>

<?php $__env->startSection('container'); ?>
<section class="bg-gray-50 dark:bg-gray-900 p-3 sm:p-5">
    <div class="">
        <!-- Start coding here -->
        <div class="bg-white dark:bg-gray-800 relative shadow-md sm:rounded-lg overflow-hidden mb-4">
            <div class="flex flex-col md:flex-row items-center justify-end space-y-3 md:space-y-0 md:space-x-4 p-4">
                <div class="w-full md:w-auto flex flex-col md:flex-row space-y-2 md:space-y-0 items-stretch md:items-center justify-end md:space-x-3 flex-shrink-0">
                    <a href="<?php echo e(route('tickets.create')); ?>" class="flex items-center justify-center text-white bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 font-medium rounded-lg text-sm px-4 py-2 dark:bg-primary-600 dark:hover:bg-primary-700 focus:outline-none dark:focus:ring-primary-800">
                        <svg class="h-3.5 w-3.5 mr-2" fill="currentColor" viewbox="0 0 20 20" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                            <path clip-rule="evenodd" fill-rule="evenodd" d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z" />
                        </svg>
                        <?php echo __('ticket.create_new_ticket'); ?>

                    </a>
                </div>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
                    <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                        <tr>
                            <th scope="col" class="px-4 py-3"><?php echo __('ticket.col_ticket'); ?></th>
                            <th scope="col" class="px-4 py-3"><?php echo __('ticket.col_devision'); ?></th>
                            <th scope="col" class="px-4 py-3"><?php echo __('ticket.col_order'); ?></th>
                            <th scope="col" class="px-4 py-3"><?php echo __('ticket.col_member'); ?></th>
                            <th scope="col" class="px-4 py-3"><?php echo __('ticket.col_status'); ?></th>
                            <th scope="col" class="px-4 py-3"><?php echo __('ticket.col_last_updated'); ?></th>

                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $tickets->paginate(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="border-b dark:border-gray-700">
                            <th scope="row" class="px-4 py-3 font-medium text-gray-900 whitespace-nowrap dark:text-white"><a class="hover:text-primary-400 dark:hover:text-primary-400 font-bold" href="<?php echo e(route('tickets.view', $ticket->id)); ?>"><?php echo e($ticket->subject); ?></a></th>
                            <td class="px-4 py-3"><?php echo $ticket->department ? __($ticket->department->name) : 'None'; ?></td>
                            <td class="px-4 py-3"><a <?php if(isset($ticket->order->id)): ?> href="<?php echo e(route('service', ['order' => $ticket->order->id, 'page' => 'manage'])); ?>" <?php else: ?> href="#" <?php endif; ?> class="text-sm font-medium text-primary-600 hover:underline dark:text-primary-500"><?php echo e($ticket->order->package->name ?? 'none'); ?></a></td>
                            <td class="px-4 py-3">
                                <div class="flex -space-x-4 rtl:space-x-reverse">
                                    <?php if($ticket->user->avatar): ?>
                                        <img class="w-10 h-10 border-2 border-white rounded-full dark:border-gray-800" src="<?php echo e($ticket->user->avatar()); ?>" alt="">
                                    <?php else: ?>
                                        <div class="relative inline-flex border border-gray-500 items-center justify-center mt-0.5 w-9 h-9 overflow-hidden bg-gray-100 rounded-full dark:bg-gray-600">
                                            <span class="font-medium text-gray-600 dark:text-gray-300"><?php echo e(substr($ticket->user->first_name, 0, 1) . substr($ticket->user->last_name, 0, 1)); ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <?php $__currentLoopData = $ticket->members()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($member->user->avatar ?? false): ?>
                                            <img class="w-10 h-10 <?php if($loop->last): ?> z-10 <?php endif; ?>  border-2 border-white rounded-full dark:border-gray-800" src="<?php echo e($member->user->avatar()); ?>" alt="">
                                        <?php else: ?>
                                            <div class="relative inline-flex border border-gray-500 items-center justify-center mt-0.5 w-9 h-9 overflow-hidden bg-gray-100 rounded-full dark:bg-gray-600">
                                                <span class="font-medium text-gray-600 dark:text-gray-300"><?php echo e(substr($member->user->first_name, 0, 1) . substr($member->user->last_name, 0, 1)); ?></span>
                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>                             
                            </td>
                            <td class="px-4 py-3">
                                <?php if($ticket->is_open): ?> 
                                    <span class="bg-green-100 text-green-800 text-xs font-medium me-2 px-2.5 py-0.5 rounded-full dark:bg-green-900 dark:text-green-300"><?php echo __('ticket.status_open'); ?></span>
                                <?php else: ?> 
                                    <span class="bg-red-100 text-red-800 text-xs font-medium me-2 px-2.5 py-0.5 rounded-full dark:bg-red-900 dark:text-red-300"><?php echo __('ticket.status_closed'); ?></span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3"><?php echo e($ticket->updated_at->diffForHumans() ?? 'Never'); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = \Modules\Tickets\Entities\TicketMember::where('user_id', auth()->user()->id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php 
                            $ticket = $ticket->ticket;
                        ?>
                        <tr class="border-b dark:border-gray-700">
                            <th scope="row" class="px-4 py-3 font-medium text-gray-900 whitespace-nowrap dark:text-white"><a class="hover:text-primary-400 dark:hover:text-primary-400 font-bold" href="<?php echo e(route('tickets.view', $ticket->id)); ?>"><?php echo e($ticket->subject); ?></a></th>
                            <td class="px-4 py-3"><?php echo e($ticket->department->name ?? 'none'); ?></td>
                            <td class="px-4 py-3"><a <?php if(isset($ticket->order->id)): ?> href="<?php echo e(route('service', ['order' => $ticket->order->id, 'page' => 'manage'])); ?>" <?php else: ?> href="#" <?php endif; ?> class="text-sm font-medium text-primary-600 hover:underline dark:text-primary-500"><?php echo e($ticket->order->package->name ?? 'none'); ?></a></td>
                            <td class="px-4 py-3">
                                <div class="flex -space-x-4 rtl:space-x-reverse">
                                    <?php if($ticket->user->avatar): ?>
                                        <img class="w-10 h-10 border-2 border-white rounded-full dark:border-gray-800" src="<?php echo e($ticket->user->avatar()); ?>" alt="">
                                    <?php else: ?>
                                        <div class="relative inline-flex border border-gray-500 items-center justify-center mt-0.5 w-9 h-9 overflow-hidden bg-gray-100 rounded-full dark:bg-gray-600">
                                            <span class="font-medium text-gray-600 dark:text-gray-300"><?php echo e(substr($ticket->user->first_name, 0, 1) . substr($ticket->user->last_name, 0, 1)); ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <?php $__currentLoopData = $ticket->members()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($member->user->avatar ?? false): ?>
                                            <img class="w-10 h-10 <?php if($loop->last): ?> z-10 <?php endif; ?>  border-2 border-white rounded-full dark:border-gray-800" src="<?php echo e($member->user->avatar()); ?>" alt="">
                                        <?php else: ?>
                                            <div class="relative inline-flex border border-gray-500 items-center justify-center mt-0.5 w-9 h-9 overflow-hidden bg-gray-100 rounded-full dark:bg-gray-600">
                                                <span class="font-medium text-gray-600 dark:text-gray-300"><?php echo e(substr($member->user->first_name, 0, 1) . substr($member->user->last_name, 0, 1)); ?></span>
                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>                             
                            </td>
                            <td class="px-4 py-3">
                                <?php if($ticket->is_open): ?> 
                                    <span class="bg-green-100 text-green-800 text-xs font-medium me-2 px-2.5 py-0.5 rounded-full dark:bg-green-900 dark:text-green-300">Open</span>
                                <?php else: ?> 
                                    <span class="bg-red-100 text-red-800 text-xs font-medium me-2 px-2.5 py-0.5 rounded-full dark:bg-red-900 dark:text-red-300">Closed</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3"><?php echo e($ticket->updated_at->diffForHumans() ?? 'Never'); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-2 mb-6 flex items-center justify-end">
                <?php echo e($tickets->paginate(10)->links(Theme::pagination())); ?>

            </div>
        </div>
        <?php if($tickets->count() == 0): ?>
            <?php echo $__env->make(Theme::path('empty-state'), ['title' => 'No tickets found', 'description' => 'You haven\'t created any tickets yet'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>;
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make(Theme::wrapper(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/Modules/Tickets/Resources/views/client/tailwind/tickets.blade.php ENDPATH**/ ?>