<?php $__env->startSection('title', __('client.dashboard')); ?>


<?php $__env->startSection('keywords', 'WemX Dashboard, WemX Panel'); ?>

<?php $__env->startSection('container'); ?>
    <div class="flex flex-wrap ">
        <div class="lg:w-1/4 pr-4 pl-4 md:w-1/3 pr-4 pl-4 sm:w-1/2 pr-4 pl-4 w-full">
            <?php if($order->domain): ?>
            <div class="p-6 bg-white rounded shadow dark:bg-gray-800 dark:border-gray-700 mb-4">
                <h5 class="mb-4 text-lg font-bold tracking-tight text-gray-900 dark:text-white text-center"><?php echo e($order->domain); ?></h5>
                <div>
                    <a href="http://<?php echo e($order->domain); ?>" target="_blank" class="text-gray-900 mb-3 flex justify-center bg-white border border-gray-300 focus:outline-none hover:bg-gray-100 focus:ring-4 focus:ring-gray-200 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-gray-800 dark:text-white dark:border-gray-600 dark:hover:bg-gray-700 dark:hover:border-gray-600 dark:focus:ring-gray-700">Visit Website</a>
                    <a href="https://www.whois.com/whois/<?php echo e($order->domain); ?>" target="_blank" class="text-white flex justify-center bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800">WHOIS Info</a>
                </div>
            </div>
            <?php endif; ?>
            <div class="px-3 rounded py-4 overflow-y-auto bg-gray-50 dark:bg-gray-800 mb-6">
                <ul class="space-y-2 font-medium">
                    <li>
                        <a href="<?php echo e(route('service', ['order' => $order->id, 'page' => 'manage'])); ?>"
                            class="flex items-center p-2 text-gray-900 rounded-lg dark:text-white hover:bg-gray-100 dark:hover:bg-gray-700 <?php echo e(is_active('service', ['order' => $order, 'page' => 'manage'], 'bg-gray-100 dark:bg-gray-700')); ?>">
                            <svg aria-hidden="true"
                                class="flex-shrink-0 w-6 h-6 text-gray-500 transition duration-75 dark:text-gray-400 group-hover:text-gray-900 dark:group-hover:text-white"
                                fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M5 3a2 2 0 00-2 2v2a2 2 0 002 2h2a2 2 0 002-2V5a2 2 0 00-2-2H5zM5 11a2 2 0 00-2 2v2a2 2 0 002 2h2a2 2 0 002-2v-2a2 2 0 00-2-2H5zM11 5a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V5zM11 13a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z">
                                </path>
                            </svg>
                            <span class="flex-1 ml-3 whitespace-nowrap"><?php echo __('client.general'); ?></span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('service', ['order' => $order->id, 'page' => 'invoices'])); ?>"
                            class="flex items-center p-2 text-gray-900 rounded-lg dark:text-white hover:bg-gray-100 dark:hover:bg-gray-700 <?php echo e(is_active('service', ['order' => $order, 'page' => 'invoices'], 'bg-gray-100 dark:bg-gray-700')); ?>">
                            <svg aria-hidden="true"
                                class="flex-shrink-0 w-6 h-6 text-gray-500 transition duration-75 dark:text-gray-400 group-hover:text-gray-900 dark:group-hover:text-white"
                                fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M8.707 7.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l2-2a1 1 0 00-1.414-1.414L11 7.586V3a1 1 0 10-2 0v4.586l-.293-.293z">
                                </path>
                                <path
                                    d="M3 5a2 2 0 012-2h1a1 1 0 010 2H5v7h2l1 2h4l1-2h2V5h-1a1 1 0 110-2h1a2 2 0 012 2v10a2 2 0 01-2 2H5a2 2 0 01-2-2V5z">
                                </path>
                            </svg>
                            <span class="flex-1 ml-3 whitespace-nowrap"><?php echo __('client.invoices'); ?></span>
                            <span
                                class="inline-flex items-center justify-center w-3 h-3 p-3 ml-3 text-sm font-medium text-blue-800 bg-blue-100 rounded-full dark:bg-blue-900 dark:text-blue-300">
                                <?php echo e($order->payments->where('user_id', auth()->user()->id)->count()); ?></span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('service', ['order' => $order->id, 'page' => 'members'])); ?>"
                            class="flex items-center p-2 text-gray-900 rounded-lg dark:text-white hover:bg-gray-100 dark:hover:bg-gray-700 <?php echo e(is_active('service', ['order' => $order, 'page' => 'members'], 'bg-gray-100 dark:bg-gray-700')); ?>">
                            <svg class="flex-shrink-0 w-6 h-5 text-gray-500 transition duration-75 dark:text-gray-400 group-hover:text-gray-900 dark:group-hover:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 19">
                                <path d="M14.5 0A3.987 3.987 0 0 0 11 2.1a4.977 4.977 0 0 1 3.9 5.858A3.989 3.989 0 0 0 14.5 0ZM9 13h2a4 4 0 0 1 4 4v2H5v-2a4 4 0 0 1 4-4Z"/>
                                <path d="M5 19h10v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2ZM5 7a5.008 5.008 0 0 1 4-4.9 3.988 3.988 0 1 0-3.9 5.859A4.974 4.974 0 0 1 5 7Zm5 3a3 3 0 1 0 0-6 3 3 0 0 0 0 6Zm5-1h-.424a5.016 5.016 0 0 1-1.942 2.232A6.007 6.007 0 0 1 17 17h2a1 1 0 0 0 1-1v-2a5.006 5.006 0 0 0-5-5ZM5.424 9H5a5.006 5.006 0 0 0-5 5v2a1 1 0 0 0 1 1h2a6.007 6.007 0 0 1 4.366-5.768A5.016 5.016 0 0 1 5.424 9Z"/>
                            </svg>
                            <span class="flex-1 ml-3 whitespace-nowrap"><?php echo __('client.members'); ?></span>
                        </a>
                    </li>
                    <?php $__currentLoopData = $order->package->service()->getServiceSidebarButtons($order)->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $button): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(empty($button)): ?>
                        <?php continue; ?>;
                    <?php endif; ?>
                    <li>
                        <a href="<?php echo e($button['href'] ?? '#'); ?>" target="<?php echo e($button['target'] ?? ''); ?>" class="flex items-center p-2 text-gray-900 rounded-lg dark:text-white hover:bg-gray-100 dark:hover:bg-gray-700 <?php echo e(is_active($button['href'], ['order' => $order, 'page' => 'invoices'], 'bg-gray-100 dark:bg-gray-700')); ?>">
                            <span class="flex-shrink-0 flex w-6 h-6 text-gray-500 transition duration-75 dark:text-gray-400 group-hover:text-gray-900 dark:group-hover:text-white" style="font-size: 23px;">
                                <?php echo $button['icon']; ?>

                            </span>
                            <span class="flex-1 ml-3 whitespace-nowrap"><?php echo $button['name']; ?></span>
                        </a>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </div>
        <div class="lg:w-3/4 pr-4 pl-4 md:w-2/3 pr-4 pl-4 sm:w-1/2 pr-4 pl-4 w-full">
            <?php echo $__env->make(Theme::path('components.orders.alerts'), $order, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make(Theme::wrapper(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/client/tailwind/orders/master.blade.php ENDPATH**/ ?>