<?php $__env->startSection('container'); ?>
<section class="section">
    <div class="section-body">
        <div class="col-12">
            <?php if ($__env->exists(AdminTheme::path('users.user_nav'))) echo $__env->make(AdminTheme::path('users.user_nav'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>

    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <?php if($user->payments->count() < 0): ?>
                    <?php if ($__env->exists(AdminTheme::path('empty-state'), ['title' => 'No Active Invoices', 'description' => 'This user has no invoices in history'])) echo $__env->make(AdminTheme::path('empty-state'), ['title' => 'No Active Invoices', 'description' => 'This user has no invoices in history'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php else: ?>
                <table class="table table-striped table-md">
                    <tbody><tr>
                      <th><?php echo __('admin.id'); ?></th>
                      <th><?php echo __('admin.user'); ?></th>
                      <th><?php echo __('admin.description'); ?></th>
                      <th><?php echo __('admin.amount'); ?></th>
                      <th><?php echo __('admin.type'); ?></th>
                      <th><?php echo __('admin.status'); ?></th>
                      <th><?php echo __('admin.create_at'); ?></th>
                      <th class="text-right"><?php echo __('admin.actions'); ?></th>
                    </tr>

                    <?php $__currentLoopData = $user->payments()->latest()->paginate(15); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                      <td><?php echo e(Str::substr($payment->id, 0, 8)); ?></td>
                      <td>
                        <a href="<?php echo e(route('users.edit', ['user' => $payment->user->id])); ?>" style="display: flex; color: #6c757d">
                          <img alt="image" src="<?php echo e($payment->user->avatar()); ?>"
                               class="rounded-circle mr-1 mt-1" width="32px" height="32px" data-toggle="tooltip" title=""
                               data-original-title="<?php echo e($payment->user->first_name); ?> <?php echo e($payment->user->last_name); ?>">
                          <div class="flex">
                            <?php echo e($payment->user->username); ?> <br>
                            <small><?php echo e($payment->user->email); ?></small>
                          </div>
                        </a>
                      </td>
                      <td><?php echo e($payment->description); ?></td>
                      <td><?php echo e(currency('symbol')); ?><?php echo e(number_format($payment->amount, 2)); ?> <?php echo e($payment->currency); ?></td>
                      <td><?php echo e($payment->type); ?></td>
                      <td>
                          <div class="<?php if($payment->status == 'paid'): ?> badge badge-success
                            <?php elseif($payment->status == 'unpaid'): ?> badge badge-danger <?php endif; ?>"><?php echo __('admin.' . $payment->status); ?>

                          </div>
                      </td>
                      <td><?php echo e($payment->created_at->translatedFormat(settings('date_format', 'd M Y'))); ?></td>
                      <td class="text-right">
                          <a href="<?php echo e(route('payments.edit', ['payment' => $payment->id])); ?>" class="btn btn-primary"><?php echo __('admin.manage'); ?></a>
                      </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                  </tbody></table>
                </div>
                <?php endif; ?>
                <div class="card-footer text-right">
                    <?php echo e($user->payments()->latest()->paginate(15)->links(AdminTheme::pagination())); ?>

                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.invoices'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/users/invoices.blade.php ENDPATH**/ ?>