<?php $__env->startSection('css_libraries'); ?>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <form action="<?php echo e(route('services.store', $service->service->getLowerName())); ?>" method="POST">
                    <div class="card-header">
                      <h4><?php echo e($service->module()->getName()); ?> <?php echo __('admin.configuration'); ?></h4>
                    </div>
                    <div class="card-body">
                        <?php echo csrf_field(); ?>
                      <div class="row">
        
                        <?php $__currentLoopData = $service->getConfig()->all() ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="form-group <?php if(isset($field['col'])): ?> <?php echo e($field['col']); ?> <?php else: ?> col-6 <?php endif; ?>" style="display: flex;flex-direction: column;">
                            <label><?php echo $field['name']; ?></label>
                            <?php if($field['type'] == 'select'): ?>
                            <select class="form-control select2 select2-hidden-accessible" tabindex="-1" aria-hidden="true"
                            name="<?php echo e($field['key']); ?>"
                            id="<?php echo e($field['key']); ?>"
                            <?php if(isset($field['multiple']) AND $field['multiple']): ?> multiple <?php endif; ?>
                            >
                                <?php $__currentLoopData = $field['options'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>"
                                <?php if(in_array($key, (array) settings(Str::remove("[]", $field['key']), $field['default_value'] ?? ''))): ?> selected <?php endif; ?>
                                ><?php echo e($option); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php elseif($field['type'] == 'bool'): ?>
                            <label class="custom-switch mt-2">
                                <input type="checkbox" name="<?php echo e($field['key']); ?>" value="1" class="custom-switch-input" <?php if(settings($field['key'], $field['default_value'] ?? '')): ?> checked <?php endif; ?>>
                                <span class="custom-switch-indicator"></span>
                              </label>
                            <?php else: ?>
                            <input class="form-control"
                            type="<?php echo e($field['type']); ?>"
                            name="<?php echo e($field['key']); ?>"
                            id="<?php echo e($field['key']); ?>"
                            <?php if(isset($field['min'])): ?> min="<?php echo e($field['min']); ?>" <?php endif; ?>
                            <?php if(isset($field['max'])): ?> max="<?php echo e($field['max']); ?>" <?php endif; ?>
                            value="<?php echo e(settings($field['key'], $field['default_value'] ?? '')); ?>"
                            placeholder="<?php if(isset($field['placeholder'])): ?><?php echo e($field['placeholder']); ?> <?php else: ?><?php echo e($field['name']); ?> <?php endif; ?>"
                            <?php if(in_array('required', $field['rules'])): ?> required="" <?php endif; ?>>
                            <?php endif; ?>
                            <small class="form-text text-muted">
                                <?php echo $field['description']; ?>

                            </small>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    </div>
                    <div class="card-footer text-right">
                        <?php if($service->canTestConnection()): ?>
                            <a href="<?php echo e(route('services.test-connection', $service->service->getLowerName())); ?>" class="btn btn-success mr-2">Test Connection</a>
                        <?php endif; ?>
                        <button type="submit" class="btn btn-primary"><?php echo __('admin.update'); ?></button>
                    </div>
            </div>
            </form>
        </div>
    </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => $service->service->getName() . ' '.__('admin.configuration'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/services/config.blade.php ENDPATH**/ ?>