<?php $__env->startSection('container'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><?php echo __('admin.add_gateway'); ?></h3>
        </div>
        <div class="card-body">
            <form action="<?php echo e(route('gateways.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <label for="driver"><?php echo __('admin.driver'); ?></label>
                    <select onchange="setDisplayName()" class="form-control" name="driver">
                        <?php $__currentLoopData = $drivers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($driver['driver']); ?>"><?php echo e(Str::replace('_', ' ', $key)); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="name"><?php echo __('admin.name'); ?></label>
                    <input type="text" name="name" id="name"
                        class="form-control" placeholder="<?php echo e(__('admin.credit_card')); ?>"
                        required>
                    <small class="form-text text-muted">
                        <?php echo __('admin.gateway_display_name_desc', ['default' => 'This is the name of the gateway displayed to users']); ?>

                        </small>
                </div>
                <button type="submit" class="btn btn-primary"><?php echo __('admin.create'); ?></button>
            </form>
        </div>
    </div>

    <script>
        function setDisplayName() {
            document.getElementById('name').value = document.getElementById('driver').value;
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.gateways', ['default' => 'Gateways']), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/gateways/create.blade.php ENDPATH**/ ?>