<?php $__env->startSection('container'); ?>

<div class="col-12 mb-4">
    <div class="card mb-0">
        <div class="card-body">
            <ul class="nav nav-pills">
                <li class="nav-item">
                    <a class="nav-link <?php if($nav == 'index'): ?> active <?php endif; ?>" href="<?php echo e(route('admin.tickets')); ?>">
                        All Tickets
                        <?php if($nav == 'index'): ?><span class="badge badge-white"><?php echo e($tickets->count()); ?></span><?php endif; ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php if($nav == 'open'): ?> active <?php endif; ?>" href="<?php echo e(route('admin.tickets.open')); ?>">
                        Open
                        <?php if($nav == 'open'): ?><span class="badge badge-white"><?php echo e($tickets->count()); ?></span><?php endif; ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php if($nav == 'closed'): ?> active <?php endif; ?>" href="<?php echo e(route('admin.tickets.closed')); ?>">
                        Closed
                        <?php if($nav == 'closed'): ?><span class="badge badge-white"><?php echo e($tickets->count()); ?></span><?php endif; ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php if($nav == 'locked'): ?> active <?php endif; ?>" href="<?php echo e(route('admin.tickets.locked')); ?>">
                        Locked
                        <?php if($nav == 'locked'): ?><span class="badge badge-white"><?php echo e($tickets->count()); ?></span><?php endif; ?></a>
                </li>
            </ul>
        </div>
    </div>
</div>

<div class="col-12 col-md-12 col-lg-12">
    <div class="dropdown d-inline mr-2">
        <button class="btn btn-success dropdown-toggle mb-3 " type="button" id="dropdownMenuButton3" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
          Department
        </button>
        <div class="dropdown-menu">
        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
            <a class="dropdown-item" href="<?php echo e(route('admin.tickets', ['department' => $department->id])); ?>"><?php echo e($department->name); ?></a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <div class="card">
      <div class="card-header">
        <h4>Tickets</h4>
        <div class="card-header-action">
        </div>
      </div>
      <div class="card-body p-0">
        <div class="table-responsive">
          <table class="table table-striped table-md">
            <tbody><tr>
              <th class="text-left">User</th>
              <th class="text-left">Subject</th>
              <th>Department</th>
              <th>Status</th>
              <th class="text-right">Last Message by</th>
              <th class="text-right">Last Updated</th>
              <th class="text-right">Actions</th>
            </tr>
            <?php if($tickets->count() == 0): ?> 
              <?php echo $__env->make(AdminTheme::path('empty-state'), ['title' => 'No tickets found', 'description' => 'There are no new tickets'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
            <?php $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td class="text-left">
                <a href="<?php echo e($ticket->user->avatar()); ?>" style="display: flex">
                    <img alt="image" src="https://imgur.com/koz9j8a.png" class="rounded-circle mr-2 mt-1" width="32px" height="32px" data-toggle="tooltip" title="" data-original-title="<?php echo e($ticket->user->username); ?>">
                    <div class="flex">
                      <?php echo e($ticket->user->username); ?> <br>
                        <small><?php echo e($ticket->user->email); ?></small>
                    </div>
                </a>
              </td>
              <td class="text-left">
                <?php echo e($ticket->subject); ?>

              </td>
              <td><?php echo e($ticket->department->name); ?></td>
              <td>
                <?php if($ticket->is_locked): ?>
                <div class="badge badge-warning">
                    Locked
                </div>
                <?php elseif($ticket->is_open): ?>
                <div class="badge badge-success">
                    Open
                </div>
                <?php else: ?> 
                <div class="badge badge-danger">
                    Closed
                </div>
                <?php endif; ?>
              </td>
              <td class="text-left">
                <?php 
                  $last_messanger = $ticket->getMessages()->latest()->first();
                ?>
                <a href="<?php echo e($last_messanger->user->avatar()); ?>" style="display: flex;justify-content: flex-end;">
                    <img alt="image" src="https://imgur.com/koz9j8a.png" class="rounded-circle mr-2 mt-1" width="32px" height="32px" data-toggle="tooltip" title="" data-original-title="<?php echo e($last_messanger->user->username); ?>">
                    <div class="flex">
                      <?php echo e($last_messanger->user->username); ?> <br>
                        <small><?php echo e($last_messanger->user->email); ?></small>
                    </div>
                </a>
              </td>
              <td class="text-right"><?php echo e($ticket->updated_at->diffForHumans()); ?></td>
              <td class="text-right">
                <a href="<?php echo e(route('tickets.view', $ticket->id)); ?>" target="_blank" class="btn btn-success">Open <i class="fas fa-external-link-alt"></i></a>
              </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody></table>
        </div>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make(AdminTheme::wrapper(), ['title' => 'Tickets', 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/Modules/Tickets/Resources/views/admin/default/tickets/index.blade.php ENDPATH**/ ?>