<!-- drawer component -->
<div id="drawer-example" class="fixed top-0 left-0 z-40 h-screen p-4 overflow-y-auto transition-transform -translate-x-full bg-white w-80 dark:bg-gray-800" tabindex="-1" aria-labelledby="drawer-label">
    <h5 id="drawer-label" class="inline-flex items-center mb-4 text-base font-semibold text-gray-500 dark:text-gray-400"><svg class="w-5 h-5 mr-2" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
        </svg><?php echo __('client.info'); ?></h5>
    <button type="button" data-drawer-hide="drawer-example" aria-controls="drawer-example" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 absolute top-2.5 right-2.5 inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white">
        <svg aria-hidden="true" class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
        </svg>
        <span class="sr-only"><?php echo __('client.close_menu'); ?></span>
    </button>
    <p class="mb-6 text-sm text-gray-500 dark:text-gray-400">
        <?php echo __('client.balance_sidebar_desc'); ?>

    </p>

    <form action="<?php echo e(route('balance.add')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="mb-4">

            <h3 class="mb-5 text-lg font-medium text-gray-900 dark:text-white"><?php echo __('client.balance_how_add'); ?></h3>
            <ul class="grid w-full gap-6 md:grid-cols-2">
                <li>
                    <input type="radio" id="5" value="5" onclick="preset(5)" name="preselected_amount" class="hidden peer" checked="">
                    <label for="5" class="inline-flex items-center justify-between w-full p-2 text-gray-500 bg-white border border-gray-200 rounded-lg cursor-pointer dark:hover:text-gray-300 dark:border-gray-700 dark:peer-checked:text-blue-500 peer-checked:border-blue-600 peer-checked:text-blue-600 hover:text-gray-600 hover:bg-gray-100 dark:text-gray-400 dark:bg-gray-800 dark:hover:bg-gray-700">
                        <div class="block">
                            <div class="w-full text-lg font-semibold"><?php echo e(currency('symbol')); ?>5.00</div>
                        </div>
                    </label>
                </li>
                <li>
                    <input type="radio" id="10" value="10" onclick="preset(10)" name="preselected_amount" class="hidden peer">
                    <label for="10" class="inline-flex items-center justify-between w-full p-2 text-gray-500 bg-white border border-gray-200 rounded-lg cursor-pointer dark:hover:text-gray-300 dark:border-gray-700 dark:peer-checked:text-blue-500 peer-checked:border-blue-600 peer-checked:text-blue-600 hover:text-gray-600 hover:bg-gray-100 dark:text-gray-400 dark:bg-gray-800 dark:hover:bg-gray-700">
                        <div class="block">
                            <div class="w-full text-lg font-semibold"><?php echo e(currency('symbol')); ?>10.00</div>
                        </div>
                    </label>
                </li>
                <li>
                    <input type="radio" id="20" value="20" onclick="preset(20)" name="preselected_amount" class="hidden peer">
                    <label for="20" class="inline-flex items-center justify-between w-full p-2 text-gray-500 bg-white border border-gray-200 rounded-lg cursor-pointer dark:hover:text-gray-300 dark:border-gray-700 dark:peer-checked:text-blue-500 peer-checked:border-blue-600 peer-checked:text-blue-600 hover:text-gray-600 hover:bg-gray-100 dark:text-gray-400 dark:bg-gray-800 dark:hover:bg-gray-700">
                        <div class="block">
                            <div class="w-full text-lg font-semibold"><?php echo e(currency('symbol')); ?>20.00</div>
                        </div>
                    </label>
                </li>
                <li>
                    <input type="radio" id="50" value="50" onclick="preset(50)" name="preselected_amount" class="hidden peer">
                    <label for="50" class="inline-flex items-center justify-between w-full p-2 text-gray-500 bg-white border border-gray-200 rounded-lg cursor-pointer dark:hover:text-gray-300 dark:border-gray-700 dark:peer-checked:text-blue-500 peer-checked:border-blue-600 peer-checked:text-blue-600 hover:text-gray-600 hover:bg-gray-100 dark:text-gray-400 dark:bg-gray-800 dark:hover:bg-gray-700">
                        <div class="block">
                            <div class="w-full text-lg font-semibold"><?php echo e(currency('symbol')); ?>50.00</div>
                        </div>
                    </label>
                </li>
            </ul>

            <div class="relative mb-6 mt-6">
                <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                    <svg class="w-5 h-5 text-gray-500 dark:text-gray-400" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" />
                        <circle cx="12" cy="12" r="9" />
                        <path d="M14.8 9a2 2 0 0 0 -1.8 -1h-2a2 2 0 0 0 0 4h2a2 2 0 0 1 0 4h-2a2 2 0 0 1 -1.8 -1" />
                        <path d="M12 6v2m0 8v2" />
                    </svg>
                </div>
                <input type="number" id="amount" name="amount" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10 p-2.5  dark:bg-gray-800 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" value="5">
            </div>

            <div class="">
                <select class="bg-gray-50 border border-gray-300 mb-6 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-800 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" name="gateway" tabindex="-1" aria-hidden="true" required>
                    <?php $__currentLoopData = App\Models\Gateways\Gateway::getActive(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($gateway->driver == 'Balance'): ?>
                    <?php continue; ?>
                    <?php endif; ?>
                    <option value="<?php echo e($gateway->id); ?>"><?php echo e($gateway->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>


        <div class="">
            <button type="submit" class="w-full focus:outline-none text-white bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800"><?php echo __('client.pay_now'); ?></button>
        </div>
    </form>
</div>
<!-- drawer component -->


<div data-popover id="popover-user-profile" role="tooltip" class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 dark:text-gray-400 dark:bg-gray-800 dark:border-gray-600">
    <div class="p-3">
        <div class="flex items-center justify-between mb-2">
            <a href="#">
                <img class="w-10 h-10 rounded-full" src="/docs/images/people/profile-picture-1.jpg" alt="Jese Leos">
            </a>
            <div>
                <button type="button" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-xs px-3 py-1.5 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800"><?php echo e(__('client.follow')); ?></button>
            </div>
        </div>
        <p class="text-base font-semibold leading-none text-gray-900 dark:text-white">
            <a href="#">Jese Leos</a>
        </p>
        <p class="mb-3 text-sm font-normal">
            <a href="#" class="hover:underline">@jeseleos</a>
        </p>
        <p class="mb-4 text-sm"><?php echo __('client.opensource_contributor_building_flowbitecom'); ?></p>
        <ul class="flex text-sm">
            <li class="mr-2">
                <a href="#" class="hover:underline">
                    <span class="font-semibold text-gray-900 dark:text-white">799</span>
                    <span><?php echo e(__('client.following')); ?></span>
                </a>
            </li>
            <li>
                <a href="#" class="hover:underline">
                    <span class="font-semibold text-gray-900 dark:text-white">3,758</span>
                    <span><?php echo e(__('client.followers')); ?></span>
                </a>
            </li>
        </ul>
    </div>
    <div data-popper-arrow></div>
</div>

<script>
    function preset(amount) {
        element = document.getElementById("amount").value = amount;
    }
</script>

<?php echo $__env->make(Theme::path('layouts.cookie'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<footer class="p-4 bg-white sm:p-6 dark:bg-gray-800" style="margin-top: auto;">
    <div class="mx-auto max-w-screen-xl">
        <div class="md:flex md:justify-between">
            <div class="mb-6 md:mb-0">
                <a href="/" class="flex items-center">
                    <?php if(Settings::has('logo')): ?>
                    <img src="<?php echo App\Models\Settings::get('logo', ); ?>" class="mr-3 h-8 rounded" alt="<?php echo App\Models\Settings::get('app_name', 'WemX', ); ?>" />
                    <?php endif; ?> <span class="self-center text-2xl font-semibold whitespace-nowrap dark:text-white"><?php echo App\Models\Settings::get('app_name',
                        'WemX', ); ?></span>
                </a>
            </div>
            <div class="grid grid-cols-2 gap-8 sm:gap-6 sm:grid-cols-3">
                <div>
                    <h2 class="mb-6 text-sm font-semibold text-gray-900 uppercase dark:text-white"><?php echo __('client.resources'); ?></h2>
                    <ul class="text-gray-600 dark:text-gray-400">
                        <?php $__currentLoopData = Page::getActive(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(in_array('footer_resources', $page->placement)): ?>
                        <li class="mb-4">
                            <a href="<?php echo e(route('page', $page->path)); ?>" <?php if($page->new_tab): ?> target="_blank" <?php endif; ?> class="hover:underline"><?php echo e($page->name); ?></a>
                        </li>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <div>
                    <h2 class="mb-6 text-sm font-semibold text-gray-900 uppercase dark:text-white"><?php echo __('client.help_center'); ?></h2>
                    <ul class="text-gray-600 dark:text-gray-400">
                        <?php if(settings('contact_us_enabled', true)): ?>
                        <li class="mb-4">
                            <a href="<?php echo e(route('contact')); ?>" class="hover:underline"><?php echo __('client.contact_us'); ?></a>
                        </li>
                        <?php endif; ?>
                        <?php $__currentLoopData = Page::getActive(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(in_array('footer_help_center', $page->placement)): ?>
                        <li class="mb-4">
                            <a href="<?php echo e(route('page', $page->path)); ?>" <?php if($page->new_tab): ?> target="_blank" <?php endif; ?> class="hover:underline"><?php echo e($page->name); ?></a>
                        </li>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <div>
                    <h2 class="mb-6 text-sm font-semibold text-gray-900 uppercase dark:text-white"><?php echo __('client.legal'); ?></h2>
                    <ul class="text-gray-600 dark:text-gray-400">
                        <?php $__currentLoopData = Page::getActive(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(in_array('footer_legal', $page->placement)): ?>
                        <li class="mb-4">
                            <a href="<?php echo e(route('page', $page->path)); ?>" <?php if($page->new_tab): ?> target="_blank" <?php endif; ?> class="hover:underline"><?php echo e($page->name); ?></a>
                        </li>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
        <hr class="my-6 border-gray-200 sm:mx-auto dark:border-gray-700 lg:my-8" />
        <div class="sm:flex sm:items-center sm:justify-between">
            <span class="text-sm text-gray-500 sm:text-center dark:text-gray-400">
                © <?php echo e(date('Y')); ?>

                <a href="/" class="hover:underline"><?php echo App\Models\Settings::get('app_name', 'WemX', ); ?>™</a>.
                <?php echo __('client.all_rights_reserved'); ?>

            </span>
            <div class="flex mt-4 space-x-6 sm:justify-center sm:mt-0">
                <?php if(settings('socials::discord')): ?>
                <a href="<?php echo App\Models\Settings::get('socials::discord', ); ?>" target="_blank" class="text-gray-500 hover:text-gray-900 dark:hover:text-white">
                    <i class='bx bxl-discord-alt' style="font-size: 1.25rem"></i>
                </a>
                <?php endif; ?>
                <?php if(settings('socials::twitter')): ?>
                <a href="<?php echo App\Models\Settings::get('socials::twitter', ); ?>" target="_blank" class="text-gray-500 hover:text-gray-900 dark:hover:text-primary-500">
                    <i class='bx bxl-instagram' style="font-size: 1.25rem"></i>
                </a>
                <?php endif; ?>
                <?php if(settings('socials::github')): ?>
                <a href="<?php echo App\Models\Settings::get('socials::github', ); ?>" target="_blank" class="text-gray-500 hover:text-gray-900 dark:hover:text-white">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                        <path fill-rule="evenodd" d="M12 2C6.477 2 2 6.484 2 12.017c0 4.425 2.865 8.18 6.839 9.504.5.092.682-.217.682-.483 0-.237-.008-.868-.013-1.703-2.782.605-3.369-1.343-3.369-1.343-.454-1.158-1.11-1.466-1.11-1.466-.908-.62.069-.608.069-.608 1.003.07 1.531 1.032 1.531 1.032.892 1.53 2.341 1.088 2.91.832.092-.647.35-1.088.636-1.338-2.22-.253-4.555-1.113-4.555-4.951 0-1.093.39-1.988 1.029-2.688-.103-.253-.446-1.272.098-2.65 0 0 .84-.27 2.75 1.026A9.564 9.564 0 0112 6.844c.85.004 1.705.115 2.504.337 1.909-1.296 2.747-1.027 2.747-1.027.546 1.379.202 2.398.1 2.651.64.7 1.028 1.595 1.028 2.688 0 3.848-2.339 4.695-4.566 4.943.359.309.678.92.678 1.855 0 1.338-.012 2.419-.012 2.747 0 .268.18.58.688.482A10.019 10.019 0 0022 12.017C22 6.484 17.522 2 12 2z" clip-rule="evenodd" />
                    </svg>
                </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</footer>


<!-- Place your JavaScript code here -->
<?php if(session('code')): ?>
<?php echo session('code'); ?>

<?php endif; ?>

<script>
    function toggleDarkmode() {
        if (document.documentElement.classList.contains('dark')) {
            document.documentElement.classList.remove('dark');
            localStorage.setItem('color-theme', 'light');
        } else {
            document.documentElement.classList.add('dark');
            localStorage.setItem('color-theme', 'dark');
        }
    }
</script>

<script>
    async function copyToClipboard(button) {
        try {
            let textToCopy = button.textContent.trim();
            let tempInput = document.createElement("input");
            document.body.appendChild(tempInput);
            tempInput.value = textToCopy;
            tempInput.select();
            document.execCommand("copy");
            document.body.removeChild(tempInput);
            button.innerText = '<?php echo __('
            client.copied '); ?>';
            setTimeout(function() {
                button.innerText = textToCopy;
            }, 3000);
            console.log('Text copied to clipboard');
        } catch (err) {
            console.error('Error in copying text: ', err);
        }
    }
</script><?php /**PATH /var/www/wemx/resources/themes/client/tailwind/layouts/footer.blade.php ENDPATH**/ ?>