<?php $__env->startSection('container'); ?>
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header"><?php echo __('admin.groups'); ?></div>

                <div class="card-body">
                    <a href="<?php echo e(route('groups.create')); ?>" class="btn btn-primary"><?php echo __('admin.create_group'); ?></a>
                    <a href="<?php echo e(route('permissions.index')); ?>" class="btn btn-primary"><?php echo __('admin.permissions'); ?></a>
                    <hr>

                    <table class="table">
                        <thead>
                            <tr>
                                <th><?php echo __('admin.id'); ?></th>
                                <th><?php echo __('admin.name'); ?></th>
                                <th class="text-right"><?php echo __('admin.actions'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($group->id); ?></td>
                                    <td><?php echo e($group->name); ?></td>
                                    <td class="text-right">
                                        <a href="<?php echo e(route('groups.users', $group->id)); ?>"
                                           class="btn btn-primary"><?php echo __('admin.users'); ?></a>
                                        <a href="<?php echo e(route('groups.edit', $group->id)); ?>"
                                            class="btn btn-primary"><?php echo __('admin.edit'); ?></a>

                                        <form action="<?php echo e(route('groups.destroy', $group->id)); ?>" method="POST"
                                            style="display: inline-block;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button onclick="deleteItem(event)" type="submit"
                                                class="btn btn-danger"><?php echo __('admin.delete'); ?></button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.groups', ['default' => 'Groups']), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/groups/index.blade.php ENDPATH**/ ?>