<?php $__env->startSection('container'); ?>
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header"><?php echo __('admin.categories'); ?></div>

                <div class="card-body">
                    <a href="<?php echo e(route('categories.create')); ?>" class="btn btn-primary"><i class="fas fa-solid fa-plus"></i> <?php echo __('admin.create_category'); ?></a>
                    <hr>
                    <?php if($categories->count() == 0): ?>
                        <?php echo $__env->make(AdminTheme::path('empty-state'), ['title' => 'We couldn\'t find any categories', 'description' => 'You haven\'t created any categories yet.'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                    <table class="table">
                        <thead>
                            <tr>
                                <th><?php echo __('admin.id'); ?></th>
                                <th><?php echo __('admin.icon'); ?></th>
                                <th><?php echo __('admin.name'); ?></th>
                                <th><?php echo __('admin.link'); ?></th>
                                <th><?php echo __('admin.description'); ?></th>
                                <th class="text-right"><?php echo __('admin.actions'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($category->id); ?></td>
                                    <td><img alt="image" src="<?php echo e(asset('storage/products/' . $category->icon)); ?>" class="rounded-circle" width="35" data-toggle="tooltip" title="" data-original-title="<?php echo e($category->name); ?>"></td>
                                    <td><?php echo e($category->name); ?></td>
                                    <td><?php echo e($category->link); ?></td>
                                    <td><?php echo e($category->description); ?></td>
                                    <td class="text-right">
                                        <a href="<?php echo e(route('admin.change-order', ['id' => $category->id, 'model' => 'categories', 'direction' => 'up'])); ?>"
                                           class="btn btn-primary"><i class="fas fa-solid fa-caret-up"></i></a>
                                        <a href="<?php echo e(route('admin.change-order', ['id' => $category->id, 'model' => 'categories', 'direction' => 'down'])); ?>"
                                           class="btn btn-primary"><i class="fas fa-solid fa-caret-down"></i></a>
                                        <a href="<?php echo e(route('categories.edit', $category->id)); ?>"
                                            class="btn btn-primary"><?php echo __('admin.edit'); ?></a>

                                        <form action="<?php echo e(route('categories.destroy', $category->id)); ?>" method="POST"
                                            style="display: inline-block;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button onclick="deleteItem(event)" type="submit"
                                                class="btn btn-danger"><?php echo __('admin.delete'); ?></button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => 'Categories', 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/categories/index.blade.php ENDPATH**/ ?>