<?php $__env->startSection('container'); ?>
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header"><?php echo __('admin.users'); ?></div>
                <div class="card-body">
                    <button class="btn btn-primary mb-3" data-toggle="modal" data-target="#exampleModal">
                        <?php echo __('admin.search', ['default' => 'Search']); ?>

                    </button>
                    <div class="table-responsive">
                      <table class="table table-striped table-md">
                          <tbody>
                              <tr>
                                  <th><?php echo e(__('admin.username')); ?></th>
                                  <th><?php echo e(__('admin.email')); ?></th>
                                  <th><?php echo e(__('admin.balance')); ?></th>
                                  <th><?php echo e(__('admin.total_spent')); ?></th>
                                  <th><?php echo e(__('admin.vissibility')); ?></th>
                                  <th><?php echo e(__('admin.dates')); ?></th>
                                  <th class="text-right"><?php echo e(__('admin.action')); ?></th>
                              </tr>

                              <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <tr>
                                  <td>
                                    <div style="display: flex;align-items: center;">
                                      <img src="<?php echo e($user->avatar()); ?>" alt="<?php echo e(__('admin.avatar')); ?>" style="width: 32px; border-radius: 20px; margin-right: 10px">
                                      <div>
                                        <?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?> <?php if($user->is_admin()): ?> <i class="fas fa-solid fa-star" style="color: gold"></i> <?php endif; ?> <br>
                                        <small><?php echo e($user->username); ?></small>
                                      </div>
                                    </div>
                                  </td>
                                  <td><?php echo e($user->email); ?></td>
                                  <td><?php echo e(currency('symbol')); ?><?php echo e(number_format($user->balance, 2)); ?></td>
                                  <td><?php echo e(currency('symbol')); ?><?php echo e(number_format($user->payments->where('status', 'paid')->sum('amount'), 2)); ?></td>
                                  <td>
                                    <div>
                                      <?php echo e(ucfirst($user->visibility)); ?>

                                    </div>
                                    <small><?php echo e($user->last_login_at->diffForHumans()); ?></small>
                                  </td>
                                  <td>
                                    <small><?php echo e(__('admin.created')); ?>: <?php echo e($user->created_at->diffForHumans()); ?></small> <br>
                                    <small><?php echo e(__('admin.updated')); ?>: <?php echo e($user->updated_at->diffForHumans()); ?></small>
                                  </td>
                                  <td class="text-right">
                                      <a href="<?php echo e(route('users.edit', $user)); ?>"
                                          class="btn btn-sm btn-primary"><?php echo __('admin.edit'); ?></a>
                                  </td>
                              </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </tbody>
                      </table>
                  </div>

                </div>
            </div>
            <?php echo e($users->links(AdminTheme::pagination())); ?>

        </div>
    </div>
    <div class="modal fade" tabindex="-1" role="dialog" id="exampleModal" aria-hidden="true" style="display: none;">
        <div class="modal-dialog" role="document">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title"><?php echo __('admin.search_engine', ['default' => 'Search Engine']); ?></h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('admin.close')); ?>">
                <span aria-hidden="true">×</span>
              </button>
            </div>
            <div class="modal-body">
                <form id="search-form">
                    <div class="form-group">
                        <label><?php echo __('admin.search_users', ['default' => 'Search Users']); ?></label>
                        <div class="input-group">
                          <div class="input-group-prepend">
                            <div class="input-group-text">
                                <i class="fas fa-search"></i>
                            </div>
                          </div>
                          <input type="text" id="search-input"class="form-control" placeholder="<?php echo __('admin.start_typing', ['default' => 'Start typing...']); ?>">
                        </div>
                      </div>
                  </form>

                  <div id="search-results"></div>
            </div>
            <div class="modal-footer bg-whitesmoke br">
              <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo __('admin.close'); ?></button>
            </div>
          </div>
        </div>
      </div>
      <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
$(document).ready(function() {
  $('#search-input').on('input', function() {
    var query = $(this).val();
    $.ajax({
      url: '/admin/users/search',
      type: 'GET',
      data: {query: query},
      success: function(data) {
        var options = '';
        $.each(data, function(index, value) {
          options +=
        '<li class="media">' +
            '<img alt="image" class="mr-3 mb-3 rounded-circle" width="50" src="/storage/avatars/' + (value.avatar == null ? 'default.jpg' : value.avatar) + '">' +
            '<div class="media-body">' +
            '<div class="media-title">' + value.first_name + ' ' + value.last_name + ' [' + value.username +']</div>' +
            '<div class="text-job text-muted">'+ value.email +'</div>' +
            '</div>' +
            '<div class="media-items">' +
            '<div class="media-item">' +
                '<a href="/admin/users/' + value.id +'/edit" class="btn btn-sm btn-primary">View</a>' +
            '</div>' +
            '</div>' +
        '</li>'
          ;
        });
        $('#search-results').html(options);
      },
      error: function(jqXHR, textStatus, errorThrown) {
        console.log(textStatus, errorThrown);
      }
    });
  });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.users'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/groups/users.blade.php ENDPATH**/ ?>