<?php $__env->startSection('css_libraries'); ?>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/wd/123-bs4.css'))); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header"><?php echo __('admin.packages'); ?></div>

                <div class="card-body">
                    <a href="<?php echo e(route('packages.create')); ?>" class="btn btn-primary"><i class="fas fa-solid fa-plus"></i>
                        <?php echo __('admin.create_package', ['default' => 'Create Package']); ?>

                    </a>
                    <hr>
                    <?php if($packages->count() == 0): ?>
                        <?php echo $__env->make(AdminTheme::path('empty-state'),
                        ['title' => __('admin.packages_not_found', ['default' => 'We couldn\'t find any packages']),
                        'description' => __('admin.packages_not_found_desc', ['default' => 'You haven\'t created any packages yet.'])], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <table class="table">
                            <thead>
                            <tr>
                                <th><?php echo __('admin.id'); ?></th>
                                <th><?php echo __('admin.icon'); ?></th>
                                <th><?php echo __('admin.name'); ?></th>
                                <th><?php echo __('admin.category'); ?></th>
                                <th><?php echo __('admin.service'); ?></th>
                                <th><?php echo __('admin.status'); ?></th>
                                <th class="text-right"><?php echo __('admin.actions'); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                                $categories = Categories::all();
                                $i = 1;
                            ?>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(!$packages->where('category_id', $category->id)->count()): ?>
                                <?php continue; ?>
                                <?php endif; ?>
                                <tr>
                                    <td colspan="7" data-toggle="collapse" data-target=".category-<?php echo e($category->id); ?>" class="bg-light text-primary clickable" style="cursor: pointer;">
                                        <?php echo e($category->name); ?>

                                    </td>
                                </tr>

                                <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($package->category_id == $category->id): ?>
                                        <tr class="collapse category-<?php echo e($category->id); ?> <?php if($i == 1): ?> show <?php endif; ?>">
                                            <td><?php echo e($package->id); ?></td>
                                            <td>
                                                <img alt="image" src="<?php echo e(asset('storage/products/' . $package->icon)); ?>"
                                                     class="rounded-circle" width="35" data-toggle="tooltip" title="" data-original-title="<?php echo e($package->name); ?>">
                                            </td>
                                            <td><?php echo e($package->name); ?></td>
                                            <td><?php echo e($category->name); ?></td>
                                            <td><?php echo e($package->service); ?></td>
                                            <td><span class="badge badge-secondary"><?php echo __('admin.' . $package->status); ?></span></td>
                                            <td class="text-right">
                                                <a href="<?php echo e(route('admin.change-order', ['id' => $package->id, 'model' => 'packages', 'direction' => 'up'])); ?>"
                                                   class="btn btn-primary"><i class="fas fa-solid fa-caret-up"></i></a>
                                                <a href="<?php echo e(route('admin.change-order', ['id' => $package->id, 'model' => 'packages', 'direction' => 'down'])); ?>"
                                                   class="btn btn-primary"><i class="fas fa-solid fa-caret-down"></i></a>
                                                <a href="<?php echo e(route('packages.clone', $package->id)); ?>"
                                                   class="btn btn-primary"><i class="fas fa-clone"></i></a>
                                                <a href="<?php echo e(route('packages.edit', $package->id)); ?>"
                                                   class="btn btn-primary"><?php echo __('admin.edit'); ?></a>

                                                <form action="<?php echo e(route('packages.destroy', $package->id)); ?>" method="POST"
                                                      style="display: inline-block;">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button onclick="deleteItem(event)" type="submit"
                                                            class="btn btn-danger"><?php echo __('admin.delete'); ?></button>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php ($i++); ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.packages'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/packages/index.blade.php ENDPATH**/ ?>