<!DOCTYPE html>
<html lang="en" class="">

<head>
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v6.4.2/css/all.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/font-awesome.min.css">

    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>

    <script async src="https://www.googletagmanager.com/gtag/js?id=G-FGB0VF3742"></script>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="description" content="Swift Byte Gamehosting">
    <meta name="keywords" content="Gamehosting, Swift Byte, Server mieten, Gaming-Server, Multiplayer-Spiele, Online-Gaming, Minecraft Server, Ark Server, RimWorld Server, CS:GO Server, 7 Days to Die Server, Spielserver Hosting, Mod-Unterst�tzung, DDoS-Schutz, Hohe Performance, Niedrige Latenz, Game-Server Management">
    <meta name="author" content="WemX">
    <title><?php echo $__env->yieldContent('title'); ?> - <?php echo App\Models\Settings::get('app_name', 'WemX', ); ?></title>
    <link rel="icon" href="<?php echo App\Models\Settings::get('favicon', 'https://imgur.com/oJDxg2r.png', ); ?>">
    <meta name="description" content="Swift Byte - Dein Gaming-Server mit Power! Rund um die Uhr bereit für unvergessliche Spielerlebnisse.">
    <link rel="stylesheet" href="<?php echo e(Theme::get('Default')->assets); ?>assets/css/custom.css">
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    <?php echo $__env->make(Portal::path('layouts.tailwind'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>


<body class="dark">
    <?php echo $__env->make(Portal::path('layouts.header'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <section id="home" class="slide bg-white dark:bg-gray-900 h-96 sm:h-72 md:h-80 lg:h-96 xl:h-[35rem]">
        <div class="grid py-8 px-4 mx-auto max-w-screen-xl lg:gap-8 xl:gap-0 lg:py-16 lg:grid-cols-12">
            <div class="place-self-center mr-auto lg:col-span-7">
                <h1 class="mb-4 max-w-2xl text-3xl font-extrabold leading-none md:text-4xl xl:text-5xl dark:text-white">
                    <?php echo App\Models\Settings::get('portal::title', 'Swift Byte - Level up your gaming experience!', ); ?>
                </h1>
                <p class="mb-6 max-w-2xl font-light text-gray-500 lg:mb-8 md:text-lg lg:text-xl dark:text-gray-400">
                    <?php echo App\Models\Settings::get('portal::description', 'Starte noch heute deinen Gameserver und sei bestens
                    ausgestattet f&uuml;r alle Situationen mit unserer leistungsstarken Systemen, die daf&uuml;r
                    sorgen, dass deine Server rund um die Uhr laufen.', ); ?>
                </p>
                <a href="#pricing" class="inline-flex justify-center items-center py-3 px-5 mr-3 text-base font-medium text-center text-white rounded-lg bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 dark:focus:ring-primary-900">
                    <?php echo App\Models\Settings::get('portal::button', 'Unsere Server', ); ?>
                    <svg class="ml-2 -mr-1 w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-4.293-4.293a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                    </svg>
                </a>
                <a href="https://discord.gg/HZnpsfmQh9" class="inline-flex justify-center items-center py-3 px-5 text-base font-medium text-center text-gray-900 rounded-lg border border-gray-300 hover:bg-gray-100 focus:ring-4 focus:ring-gray-100 dark:text-white dark:border-gray-700 dark:hover:bg-gray-700 dark:focus:ring-gray-800">
                    <?php echo __('auth.join_discord'); ?>

                </a>
            </div>
            <div class="hidden lg:mt-0 lg:col-span-5 lg:flex">
                <img class="w-full h-auto md:w-3/4 lg:w-9/10" src="<?php echo App\Models\Settings::get('portal::default::header_image', ); ?>" alt="mockup">
            </div>
        </div>
    </section>


    <section class="bg-white dark:bg-gray-900">
        <div class="py-8 px-4 mx-auto max-w-screen-xl lg:py-16">
            <h2 class="mb-8 text-3xl font-extrabold tracking-tight leading-tight text-center text-gray-900 lg:mb-16 dark:text-white md:text-4xl">
                <?php echo __('client.host_favorite_games'); ?>

            </h2>

            <div class="grid grid-cols-2 gap-8 text-gray-500 sm:gap-12 md:grid-cols-3 lg:grid-cols-3 dark:text-gray-400">
                <!-- Spiel 1 -->
                <a href="https://swift-byte.de/?category=rust#pricing" class="flex justify-center items-center">
                    <img src="/storage/products/rust_wemx.png" class="hover:text-gray-900 dark:hover:text-white" style="height: 60px;" />
                    <h2 class="hidden md:block text-3xl font-extrabold tracking-tight leading-tight text-center text-gray-900 dark:text-white md:text-3xl ml-4">
                        <?php echo __('client.rust'); ?>

                    </h2>
                </a>

                <!-- Spiel 2 -->
                <a href="https://swift-byte.de/?category=minecraft-spigot#pricing" class="flex justify-center items-center">
                    <img src="/storage/products/minecraft_wemx.png" class="hover:text-gray-900 dark:hover:text-white" style="height: 60px;" />
                    <h2 class="hidden md:block text-3xl font-extrabold tracking-tight leading-tight text-center text-gray-900 dark:text-white md:text-3xl ml-4">
                        <?php echo __('client.minecraft'); ?>

                    </h2>
                </a>

                <!-- Spiel 3 -->
                <a href="https://swift-byte.de/?category=ark#pricing" class="flex justify-center items-center">
                    <img src="/storage/products/ark_wemx.png" class="hover:text-gray-900 dark:hover:text-white" style="height: 60px;" />
                    <h2 class="hidden md:block text-3xl font-extrabold tracking-tight leading-tight text-center text-gray-900 dark:text-white md:text-3xl ml-4">
                        <?php echo __('client.ack'); ?>

                    </h2>
                </a>

                <!-- Spiel 4 -->
                <a href="https://swift-byte.de/?category=7d2d#pricing" class="flex justify-center items-center">
                    <img src="/storage/products/7d2d_logo.png" class="hover:text-gray-900 dark:hover:text-white" style="height: 60px;" />
                    <h2 class="hidden md:block text-3xl font-extrabold tracking-tight leading-tight text-center text-gray-900 dark:text-white md:text-3xl ml-4">
                        7D2D
                    </h2>
                </a>

                <!-- Spiel 5 -->
                <a href="https://swift-byte.de/?category=rimworld#pricing" class="flex justify-center items-center">
                    <img src="/storage/products/rimworld_logo.png" class="hover:text-gray-900 dark:hover:text-white" style="height: 60px;" />
                    <h2 class="hidden md:block text-3xl font-extrabold tracking-tight leading-tight text-center text-gray-900 dark:text-white md:text-3xl ml-4">
                        Rimworld
                    </h2>
                </a>

                <!-- Spiel 6 -->
                <a href="https://swift-byte.de/?category=cs2#pricing" class="flex justify-center items-center">
                    <img src="/storage/products/csgo_logo.png" class="hover:text-gray-900 dark:hover:text-white" style="height: 60px;" />
                    <h2 class="hidden md:block text-3xl font-extrabold tracking-tight leading-tight text-center text-gray-900 dark:text-white md:text-3xl ml-4">
                        CS2
                    </h2>
                </a>
            </div>
        </div>
    </section>

    <section id="features" class="bg-gray-50 dark:bg-gray-800">

        <div class="wave-panel-top">
            <svg data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 120" preserveAspectRatio="none">
                <path d="M0,0V46.29c47.79,22.2,103.59,32.17,158,28,70.36-5.37,136.33-33.31,206.8-37.5C438.64,32.43,512.34,53.67,583,72.05c69.27,18,138.3,24.88,209.4,13.08,36.15-6,69.85-17.84,104.45-29.34C989.49,25,1113-14.29,1200,52.47V0Z" opacity=".25" class="shape-fill"></path>
                <path d="M0,0V15.81C13,36.92,27.64,56.86,47.69,72.05,99.41,111.27,165,111,224.58,91.58c31.15-10.15,60.09-26.07,89.67-39.8,40.92-19,84.73-46,130.83-49.67,36.26-2.85,70.9,9.42,98.6,31.56,31.77,25.39,62.32,62,103.63,73,40.44,10.79,81.35-6.69,119.13-24.28s75.16-39,116.92-43.05c59.73-5.85,113.28,22.88,168.9,38.84,30.2,8.66,59,6.17,87.09-7.5,22.43-10.89,48-26.93,60.65-49.24V0Z" opacity=".5" class="shape-fill"></path>
                <path d="M0,0V5.63C149.93,59,314.09,71.32,475.83,42.57c43-7.64,84.23-20.12,127.61-26.46,59-8.63,112.48,12.24,165.56,35.4C827.93,77.22,886,95.24,951.2,90c86.53-7,172.46-45.71,248.8-84.81V0Z" class="shape-fill"></path>
            </svg>
        </div>

        <div class="py-8 px-4 mx-auto max-w-screen-xl sm:py-16 lg:px-6">
            <div class="mb-8 max-w-screen-md lg:mb-16">
                <h2 class="mb-4 text-4xl font-extrabold text-gray-900 dark:text-white"><?php echo __('client.our_game_anel'); ?></h2>
                <p class="text-gray-500 sm:text-xl dark:text-gray-400">
                    <?php echo __('client.our_game_anel_desc', ['app' => settings('app_name', 'WemX')]); ?>

                </p>
            </div>
            <div class="space-y-8 md:grid md:grid-cols-2 lg:grid-cols-3 md:gap-12 md:space-y-0">
                <div>
                    <div class="flex justify-center items-center mb-4 w-10 h-10 rounded-full bg-primary-100 lg:h-12 lg:w-12 dark:bg-primary-900">
                        <div class="text-primary-600 dark:text-primary-300 text-2xl">
                            <i class="bx bxs-file"></i>
                        </div>
                    </div>
                    <h3 class="mb-2 text-xl font-bold dark:text-white"><?php echo __('client.file_manager'); ?></h3>
                    <p class="text-gray-500 dark:text-gray-400">
                        <?php echo __('client.file_manager_desc'); ?>

                    </p>
                </div>

                <div>
                    <div class="flex justify-center items-center mb-4 w-10 h-10 rounded-full bg-primary-100 lg:h-12 lg:w-12 dark:bg-primary-900">
                        <div class="text-primary-600 dark:text-primary-300 text-2xl">
                            <i class="bx bxs-plug"></i>
                        </div>
                    </div>
                    <h3 class="mb-2 text-xl font-bold dark:text-white"><?php echo __('client.plugins_manager'); ?></h3>
                    <p class="text-gray-500 dark:text-gray-400">
                        <?php echo __('client.plugins_manager_desc'); ?>

                    </p>
                </div>

                <div>
                    <div class="flex justify-center items-center mb-4 w-10 h-10 rounded-full bg-primary-100 lg:h-12 lg:w-12 dark:bg-primary-900">
                        <div class="text-primary-600 dark:text-primary-300 text-2xl">
                            <i class="bx bx-revision"></i>
                        </div>
                    </div>
                    <h3 class="mb-2 text-xl font-bold dark:text-white"><?php echo __('client.backup_manager'); ?></h3>
                    <p class="text-gray-500 dark:text-gray-400">
                        <?php echo __('client.backup_manager_desc'); ?>

                    </p>
                </div>

                <div>
                    <div class="flex justify-center items-center mb-4 w-10 h-10 rounded-full bg-primary-100 lg:h-12 lg:w-12 dark:bg-primary-900">
                        <div class="text-primary-600 dark:text-primary-300 text-2xl">
                            <i class="bx bxs-user"></i>
                        </div>
                    </div>
                    <h3 class="mb-2 text-xl font-bold dark:text-white"><?php echo __('client.user_manager'); ?></h3>
                    <p class="text-gray-500 dark:text-gray-400">
                        <?php echo __('client.user_manager_desc'); ?>

                    </p>
                </div>

                <div>
                    <div class="flex justify-center items-center mb-4 w-10 h-10 rounded-full bg-primary-100 lg:h-12 lg:w-12 dark:bg-primary-900">
                        <div class="text-primary-600 dark:text-primary-300 text-2xl">
                            <i class="bx bxs-time-five"></i>
                        </div>
                    </div>
                    <h3 class="mb-2 text-xl font-bold dark:text-white"><?php echo __('client.schedule_manager'); ?></h3>
                    <p class="text-gray-500 dark:text-gray-400">
                        <?php echo __('client.schedule_manager_desc'); ?>

                    </p>
                </div>

                <div>
                    <div class="flex justify-center items-center mb-4 w-10 h-10 rounded-full bg-primary-100 lg:h-12 lg:w-12 dark:bg-primary-900">
                        <div class="text-primary-600 dark:text-primary-300 text-2xl">
                            <i class="bx bx-support"></i>
                        </div>
                    </div>
                    <h3 class="mb-2 text-xl font-bold dark:text-white"><?php echo __('custom.support'); ?></h3>
                    <p class="text-gray-500 dark:text-gray-400">
                        <?php echo __('custom.support_desc'); ?>

                    </p>
                </div>
            </div>
        </div>
        <div class="wave-panel-bottom">
            <svg data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 120" preserveAspectRatio="none">
                <path d="M0,0V46.29c47.79,22.2,103.59,32.17,158,28,70.36-5.37,136.33-33.31,206.8-37.5C438.64,32.43,512.34,53.67,583,72.05c69.27,18,138.3,24.88,209.4,13.08,36.15-6,69.85-17.84,104.45-29.34C989.49,25,1113-14.29,1200,52.47V0Z" opacity=".25" class="shape-fill"></path>
                <path d="M0,0V15.81C13,36.92,27.64,56.86,47.69,72.05,99.41,111.27,165,111,224.58,91.58c31.15-10.15,60.09-26.07,89.67-39.8,40.92-19,84.73-46,130.83-49.67,36.26-2.85,70.9,9.42,98.6,31.56,31.77,25.39,62.32,62,103.63,73,40.44,10.79,81.35-6.69,119.13-24.28s75.16-39,116.92-43.05c59.73-5.85,113.28,22.88,168.9,38.84,30.2,8.66,59,6.17,87.09-7.5,22.43-10.89,48-26.93,60.65-49.24V0Z" opacity=".5" class="shape-fill"></path>
                <path d="M0,0V5.63C149.93,59,314.09,71.32,475.83,42.57c43-7.64,84.23-20.12,127.61-26.46,59-8.63,112.48,12.24,165.56,35.4C827.93,77.22,886,95.24,951.2,90c86.53-7,172.46-45.71,248.8-84.81V0Z" class="shape-fill"></path>
            </svg>
        </div>
    </section>


    <section class="bg-white dark:bg-gray-900" id="pricing">
        <div class="py-8 px-4 mx-auto max-w-screen-xl lg:py-16 lg:px-6">
            <?php if($selected_category !== NULL): ?>
            <div class="mx-auto max-w-screen-md text-center mb-8 lg:mb-12">
                <h2 class="mb-4 text-4xl tracking-tight font-extrabold text-gray-900 dark:text-white"> <?php echo __('client.viewing_plans_for'); ?> <?php echo e($selected_category->name); ?></h2>
                <p class="mb-5 font-light text-gray-500 sm:text-xl dark:text-gray-400"><?php echo e($selected_category->description); ?></p>
            </div>

            <?php
            $isVisiblePackageAvailable = false;
            foreach ($selected_category->packages as $package) {
            if($package->status != 'unlisted' && $package->status != 'inactive' && ($package->status != 'restricted' || (Auth::check() && Auth::user()->is_admin()))) {
            $isVisiblePackageAvailable = true;
            break;
            }
            }
            ?>

            <?php if(!$isVisiblePackageAvailable): ?>
            <div class="mx-auto max-w-screen-md text-center mb-8 lg:mb-12">
                <h2 class="mb-4 text-4xl tracking-tight font-extrabold text-gray-500 dark:text-gray-400">Bald verfügbar!</h2>
                <p class="mb-5 font-light text-gray-500 sm:text-xl dark:text-gray-400"><?php echo e($selected_category->description); ?></p>
            </div>
            <?php endif; ?>

            <div class="space-y-8 lg:grid lg:grid-cols-3 sm:gap-6 xl:gap-10 lg:space-y-0">
                <?php $__currentLoopData = $selected_category->packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <?php if($package->status == 'unlisted' OR $package->status == 'inactive' OR $package->status == 'restricted'): ?>
                <?php if($package->status == 'restricted'): ?>
                <?php if(Auth::guest() OR !Auth::user()->is_admin()): ?>
                <?php continue; ?>
                <?php endif; ?>
                <?php else: ?>
                <?php continue; ?>
                <?php endif; ?>
                <?php endif; ?>
                <div class="flex flex-col p-6 mx-auto max-w-lg text-center text-gray-900 bg-white rounded-lg border border-gray-100 shadow dark:border-gray-600 xl:p-8 dark:bg-gray-800 dark:text-white">
                    <h3 class="mb-4 text-2xl font-semibold"><?php echo e($package->name); ?></h3>
                    <div class="flex justify-center items-center"> <!-- Sie können die Höhe (h-24) an Ihre Bedürfnisse anpassen -->
                        <img class="max-h-full max-w-full" src="<?php echo e(asset('storage/products/' . $package->icon)); ?>" alt="Icon" />
                    </div>

                    <div class="flex justify-center items-center my-8">
                        <span class="text-4xl font-extrabold text-primary-600">
                            <?php echo e($package->prices->first()->totalPrice()); ?> <?php echo e(currency('symbol')); ?>

                        </span>
                        <span class="text-gray-500 dark:text-gray-400 text-sm ml-2">
                            /<?php echo e($package->prices->first()->period()); ?>

                        </span>
                    </div>

                    <!-- List -->
                    <ul role="list" class="mb-8 space-y-4 text-left">
                        <div class="grid grid-cols-1 gap-4">
                            <?php $__currentLoopData = $package->features()->orderBy('order', 'desc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="flex items-center space-x-3">
                                <!-- Icon -->
                                <span class="text-<?php echo e($feature->color); ?>-500 dark:text-<?php echo e($feature->color); ?>-500 bx-sm">
                                    <?php echo $feature->icon; ?>

                                </span>
                                <span><?php echo $feature->description; ?></span>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </ul>

                    <p class="font-light text-gray-500 sm:text-lg dark:text-gray-400">
                        <?php echo __('client.price_block_desc', [
                        'period' =>
                        (mb_strtolower($package->prices->first()->period()) == 'monat' ? 'Erster ' :
                        (mb_strtolower($package->prices->first()->period()) == 'quartal' ? 'Erstes ' : ''))
                        . ucfirst(mb_strtolower($package->prices->first()->period())),
                        'total_price' => $package->prices->first()->totalPrice(),
                        'renewal_price' => $package->prices->first()->renewal_price,
                        'per_period' => ucfirst(mb_strtolower($package->prices->first()->periodToHuman())),
                        'symbol' => currency('symbol')
                        ]); ?>

                    </p>
                    <br>
                    <a href=" <?php echo e(route('store.package', ['package' => $package->id])); ?>" class="text-white bg-primary-600 hover:bg-primary-700 focus:ring-4 focus:ring-primary-200 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:text-white  dark:focus:ring-primary-900">
                        <?php echo __('client.get_started'); ?></a>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php else: ?>
        <div class="mx-auto max-w-screen-md text-center mb-8 lg:mb-12">
            <h2 class="mb-4 text-4xl tracking-tight font-extrabold text-gray-900 dark:text-white">
                <?php echo __('client.no_plans_display'); ?></h2>
            <p class="mb-5 font-light text-gray-500 sm:text-xl dark:text-gray-400">
                <?php echo __('client.no_plans_display_desc'); ?></p>
        </div>
        <?php endif; ?>
        </div>
    </section>

    <section>
        <aside aria-label="Related articles" class="py-8 lg:py-15 bg-white dark:bg-gray-900">
            <div class="px-4 mx-auto max-w-screen-xl">
                <h2 class="mb-8 text-2xl font-bold text-gray-900 dark:text-white"><?php echo __('client.other_categories'); ?></h2>
                <div class="grid gap-12 sm:grid-cols-2 lg:grid-cols-4">

                    <?php $__currentLoopData = $categories->all()->sortBy('name'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <article class="max-w-xs">
                        <a href="<?php echo e(url()->current()); ?>?category=<?php echo e($category->link); ?>#pricing">
                            <img src="<?php echo e($category->icon()); ?>" class="mb-5 rounded-lg" alt="Image 1" style="height: 200px;">
                        </a>
                        <h2 class="mb-2 text-xl font-bold leading-tight text-gray-900 dark:text-white">
                            <a href="#"><?php echo e($category->name); ?></a>
                        </h2>
                        <p class="mb-4 font-light text-gray-500 dark:text-gray-400"><?php echo e($category->description); ?></p>
                        <a href="<?php echo e(url()->current()); ?>?category=<?php echo e($category->link); ?>#pricing" class="py-2.5 px-5 mr-2 mb-2 min-w-full text-center text-sm font-medium text-gray-900 focus:outline-none bg-white rounded-lg border border-gray-200 hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700"><?php if(request()->input('category', (isset($selected_category->link)) ? $selected_category->link : '') == $category->link): ?>
                            <?php echo __('client.selected'); ?>

                            <?php else: ?>
                            <?php echo __('client.pricing'); ?>

                            <?php endif; ?></a>
                    </article>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </aside>
    </section>


    <section class="bg-white dark:bg-gray-900">
        <div class="py-8 px-4 mx-auto max-w-screen-xl lg:py-16">
            <h2 class="mb-8 text-2xl sm:text-3xl font-extrabold tracking-tight leading-tight text-center text-gray-900 lg:mb-16 dark:text-white md:text-4xl">
                <?php echo __('custom.secure_payment_title'); ?>

            </h2>
            <div class="flex justify-center items-center flex-nowrap gap-4 sm:gap-8">
                <!-- PayPal Logo -->
                <div class="w-20 md:w-32 lg:w-36"> <!-- Verkleinern der Logos auf mobilen Geräten -->
                    <img class="w-full h-auto" src="https://www.paypalobjects.com/webstatic/de_DE/i/de-pp-logo-200px.png" alt="PayPal Logo" />
                </div>
                <!-- Visa & Mastercard Logo -->
                <div class="w-24 md:w-32 lg:w-36">
                    <img class="w-full h-auto" src="https://pngimg.com/d/visa_PNG39.png" alt="Mastercard and Visa Logo" />
                </div>
            </div>
            <p class="mt-6 text-center text-sm sm:text-base text-gray-600 dark:text-gray-300">
                <?php echo __('custom.secure_payment_description'); ?>

            </p>
        </div>
        <div class="wave-footer">
            <svg data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 120" preserveAspectRatio="none">
                <path d="M0,0V46.29c47.79,22.2,103.59,32.17,158,28,70.36-5.37,136.33-33.31,206.8-37.5C438.64,32.43,512.34,53.67,583,72.05c69.27,18,138.3,24.88,209.4,13.08,36.15-6,69.85-17.84,104.45-29.34C989.49,25,1113-14.29,1200,52.47V0Z" opacity=".25" class="shape-fill"></path>
                <path d="M0,0V15.81C13,36.92,27.64,56.86,47.69,72.05,99.41,111.27,165,111,224.58,91.58c31.15-10.15,60.09-26.07,89.67-39.8,40.92-19,84.73-46,130.83-49.67,36.26-2.85,70.9,9.42,98.6,31.56,31.77,25.39,62.32,62,103.63,73,40.44,10.79,81.35-6.69,119.13-24.28s75.16-39,116.92-43.05c59.73-5.85,113.28,22.88,168.9,38.84,30.2,8.66,59,6.17,87.09-7.5,22.43-10.89,48-26.93,60.65-49.24V0Z" opacity=".5" class="shape-fill"></path>
                <path d="M0,0V5.63C149.93,59,314.09,71.32,475.83,42.57c43-7.64,84.23-20.12,127.61-26.46,59-8.63,112.48,12.24,165.56,35.4C827.93,77.22,886,95.24,951.2,90c86.53-7,172.46-45.71,248.8-84.81V0Z" class="shape-fill"></path>
            </svg>
        </div>
    </section>

    <footer class="p-4 bg-gray-50 sm:p-6 dark:bg-gray-800">
        <div class="mx-auto max-w-screen-xl">
            <div class="md:flex md:justify-between">
                <div class="mb-6 md:mb-0">
                    <a href="/" class="flex items-center">
                        <img src="<?php echo App\Models\Settings::get('logo', 'https://imgur.com/oJDxg2r.png', ); ?>" class="mr-3 h-8" alt="<?php echo App\Models\Settings::get('app_name', 'WemX', ); ?> Logo" />
                        <span class="self-center text-2xl font-semibold whitespace-nowrap dark:text-white"><?php echo App\Models\Settings::get('app_name', 'WemX', ); ?></span>
                    </a>
                </div>
                <div class="grid grid-cols-2 gap-8 sm:gap-6 sm:grid-cols-3">
                    <div>
                        <h2 class="mb-6 text-sm font-semibold text-gray-900 uppercase dark:text-white"><?php echo __('client.resources'); ?></h2>
                        <ul class="text-gray-600 dark:text-gray-400">
                            <?php $__currentLoopData = Page::getActive(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(in_array('footer_resources', $page->placement)): ?>
                            <li class="mb-4">
                                <a href="<?php echo e(route('page', $page->path)); ?>" <?php if($page->new_tab): ?> target="_blank"
                                    <?php endif; ?> class="hover:underline"><?php echo e($page->name); ?></a>
                            </li>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <div>
                        <h2 class="mb-6 text-sm font-semibold text-gray-900 uppercase dark:text-white"><?php echo __('client.help_center'); ?></h2>
                        <ul class="text-gray-600 dark:text-gray-400">
                            <li class="mb-4">
                                <a href="<?php echo e(route('contact')); ?>" class="hover:underline"><?php echo __('client.contact_us'); ?></a>
                            </li>
                            <?php $__currentLoopData = Page::getActive(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(in_array('footer_help_center', $page->placement)): ?>
                            <li class="mb-4">
                                <a href="<?php echo e(route('page', $page->path)); ?>" <?php if($page->new_tab): ?> target="_blank"
                                    <?php endif; ?> class="hover:underline"><?php echo e($page->name); ?></a>
                            </li>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <div>
                        <h2 class="mb-6 text-sm font-semibold text-gray-900 uppercase dark:text-white"><?php echo __('client.legal'); ?></h2>
                        <ul class="text-gray-600 dark:text-gray-400">
                            <?php $__currentLoopData = Page::getActive(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(in_array('footer_legal', $page->placement)): ?>
                            <li class="mb-4">
                                <a href="<?php echo e(route('page', $page->path)); ?>" <?php if($page->new_tab): ?> target="_blank"
                                    <?php endif; ?> class="hover:underline"><?php echo e($page->name); ?></a>
                            </li>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
            <hr class="my-6 border-gray-200 sm:mx-auto dark:border-gray-700 lg:my-8" />
            <div class="flex mt-4 space-x-6 sm:justify-center sm:mt-0">
                <?php if(settings('socials::discord')): ?>
                <a href="<?php echo App\Models\Settings::get('socials::discord', ); ?>" target="_blank" class="text-gray-500 hover:text-gray-900 dark:hover:text-primary-500">
                    <i class='bx bxl-discord-alt' style="font-size: 1.25rem"></i>
                </a>
                <?php endif; ?>
                <?php if(settings('socials::twitter')): ?>
                <a href="<?php echo App\Models\Settings::get('socials::twitter', ); ?>" target="_blank" class="text-gray-500 hover:text-gray-900 dark:hover:text-primary-500">
                    <i class='bx bxl-instagram' style="font-size: 1.25rem"></i>
                </a>
                <?php endif; ?>
                <?php if(settings('socials::github')): ?>
                <a href="<?php echo App\Models\Settings::get('socials::github', ); ?>" target="_blank" class="text-gray-500 hover:text-gray-900 dark:hover:text-primary-500">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                        <path fill-rule="evenodd" d="M12 2C6.477 2 2 6.484 2 12.017c0 4.425 2.865 8.18 6.839 9.504.5.092.682-.217.682-.483 0-.237-.008-.868-.013-1.703-2.782.605-3.369-1.343-3.369-1.343-.454-1.158-1.11-1.466-1.11-1.466-.908-.62.069-.608.069-.608 1.003.07 1.531 1.032 1.531 1.032.892 1.53 2.341 1.088 2.91.832.092-.647.35-1.088.636-1.338-2.22-.253-4.555-1.113-4.555-4.951 0-1.093.39-1.988 1.029-2.688-.103-.253-.446-1.272.098-2.65 0 0 .84-.27 2.75 1.026A9.564 9.564 0 0112 6.844c.85.004 1.705.115 2.504.337 1.909-1.296 2.747-1.027 2.747-1.027.546 1.379.202 2.398.1 2.651.64.7 1.028 1.595 1.028 2.688 0 3.848-2.339 4.695-4.566 4.943.359.309.678.92.678 1.855 0 1.338-.012 2.419-.012 2.747 0 .268.18.58.688.482A10.019 10.019 0 0022 12.017C22 6.484 17.522 2 12 2z" clip-rule="evenodd" />
                    </svg>
                </a>
                <?php endif; ?>
            </div>
        </div>
    </footer>
</body>

</html><?php /**PATH /var/www/wemx/resources/themes/portal/default/main.blade.php ENDPATH**/ ?>