<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="theme-color" content="#0045ff">
    <meta property="og:title" content="<?php echo App\Models\Settings::get('app_name', 'WemX', ); ?>">
    <meta property="og:description" content="Manage your orders with an easy-to-use Dashboard">
    <meta property="og:image" content="<?php echo App\Models\Settings::get('logo', 'https://imgur.com/oJDxg2r.png', ); ?>">
    <meta name="keywords" content="wemx, WemX, WemX Pro, WHMCS, Billing,  <?php echo $__env->yieldContent('keywords'); ?>">
    <meta name="author" content="WemX">
    <title><?php echo $__env->yieldContent('title'); ?> - <?php echo App\Models\Settings::get('app_name', 'WemX', ); ?></title>
    <link rel="icon" href="<?php echo App\Models\Settings::get('favicon', 'https://imgur.com/oJDxg2r.png', ); ?>">
    <!-- Custom CSS -->
    
    <link rel="stylesheet" href="<?php echo e(Theme::get('Default')->assets); ?>assets/css/custom.css">
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    <?php echo $__env->make(Theme::path('layouts.tailwind'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('header'); ?>
</head>

<?php echo $__env->make(Theme::path('layouts.widgets.require_address'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<body class="bg-white dark:bg-gray-900" style="min-height: 100vh;display: flex;flex-direction: column;">

    <?php echo $__env->make(Theme::path('layouts.header'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container mx-auto mt-10 mb-10 mx-auto max-w-screen-xl px-4 md:px-6">
        <?php echo $__env->make(Theme::path('layouts.alerts'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="app">
            <?php echo $__env->yieldPushContent('widgets'); ?>
            <?php echo $__env->yieldContent('container'); ?>
        </div>
    </div>

    <?php echo $__env->make(Theme::path('layouts.footer'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
</body>

</html>
<?php /**PATH /var/www/wemx/resources/themes/client/tailwind/layouts/wrapper.blade.php ENDPATH**/ ?>