<?php $__env->startSection('css_libraries'); ?>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <section class="section">
        <div class="section-body">
            <div class="col-12">
                <?php if ($__env->exists(AdminTheme::path('users.user_nav'))) echo $__env->make(AdminTheme::path('users.user_nav'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <?php if($user->punishments()->exists()): ?>
                <div class="alert alert-dark alert-has-icon">
                    <div class="alert-body">
                        <div class="alert-title">
                            <?php echo e(__('admin.punishments_on_record')); ?>

                        </div>
                        <?php echo e(__('admin.history_of_punishments', ['number' => $user->punishments()->count()])); ?>

                    </div>
                </div>
            <?php endif; ?>

                <?php if($user->status == 'pending'): ?>
                    <div class="alert alert-warning alert-has-icon">
                        <div class="alert-icon"><i class="far fa-lightbulb"></i></div>
                        <div class="alert-body">
                            <div
                                class="alert-title"><?php echo __('admin.activate_account', ['default' => 'Activate Account']); ?></div>
                            <?php echo __('admin.user_activate_account_desc', ['default' =>
                            'This account is currently awaiting activation by an moderator, click the button below to active this users account.']); ?>

                            <a href="<?php echo e(route('admin.user.activate', ['user' => $user->id])); ?>" class="btn btn-primary">
                                <?php echo __('admin.activate', ['default' => 'Activate']); ?>

                            </a>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if(!$user->is_verified()): ?>
                    <div class="alert alert-warning alert-has-icon">
                        <div class="alert-icon"><i class="far fa-lightbulb"></i></div>
                        <div class="alert-body">
                            <div
                                class="alert-title"><?php echo __('admin.pending_email_verification', ['default' => 'Pending Email Verification']); ?></div>
                            <?php echo __('admin.pending_email_verification_desc', ['default' => 'This user has not yet verified their email address']); ?>

                            <a href="<?php echo e(route('admin.user.verify', ['user' => $user->id])); ?>" class="btn btn-primary">
                                <?php echo __('admin.manually_verify', ['default' => 'Manually Verify']); ?>

                            </a>
                        </div>
                    </div>
                <?php endif; ?>

            </div>
        </div>
        <div class="row mt-sm-4">
            <div class="col-12 col-md-12 col-lg-4">
                <div class="card profile-widget">
                    <div class="profile-widget-header">
                        <img alt="image" src="<?php echo e($user->avatar()); ?>" class="rounded-circle profile-widget-picture"/>
                        <div class="profile-widget-items">
                            <div class="profile-widget-item">
                                <div class="profile-widget-item-label">
                                    <?php echo __('admin.status'); ?>

                                </div>
                                <div class="profile-widget-item-value">
                                    <a href="#" class="badge
                                        <?php if($user->status == 'active'): ?> badge-success
                                        <?php elseif($user->status == 'pending'
                                        OR $user->status == 'suspended'): ?> badge-warning
                                        <?php elseif($user->status == 'banned'): ?> badge-danger
                                        <?php else: ?> badge-primary <?php endif; ?>"><?php echo __('admin.'. $user->status); ?>

                                    </a>
                                </div>
                            </div>
                            <div class="profile-widget-item">
                                <div class="profile-widget-item-label"><?php echo __('admin.payments'); ?></div>
                                <div class="profile-widget-item-value"><?php echo e($user->payments->count()); ?></div>
                            </div>
                            <div class="profile-widget-item">
                                <div class="profile-widget-item-label"><?php echo __('admin.orders'); ?></div>
                                <div class="profile-widget-item-value"><?php echo e($user->orders->count()); ?></div>
                            </div>
                        </div>
                    </div>
                    <div class="profile-widget-description">
                        <div class="profile-widget-name">
                            <?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?>

                            <div class="text-muted d-inline font-weight-normal">
                                <div class="slash"></div>
                                <?php echo e($user->email); ?>

                            </div>
                        </div>
                        <?php echo e($user->address->company ?? ''); ?> <br>
                        <?php echo e($user->address->address ?? ''); ?> <?php echo e($user->address->address_2 ?? ''); ?> <br>
                        <?php echo e($user->address->zip_code ?? ''); ?> <?php echo e($user->address->city ?? ''); ?>

                        <?php echo e($user->address->province ?? ''); ?> <?php echo e($user->address->country ?? ''); ?>

                    </div>
                    <div class="card-footer text-left">
                        <a href="<?php echo e(route('admin.user.impersonate', ['user' => $user->id])); ?>"
                            class="btn btn-icon icon-left btn-dark"><i class="fas fa-user"></i>
                             <?php echo __('admin.login_as_user', ['default' => 'Login as User']); ?>

                         </a>
                        <a href="<?php echo e(route('users.email-password-reset', ['user' => $user->id])); ?>"
                           class="btn btn-icon icon-left btn-dark"><i class="fas fa-envelope"></i>
                            <?php echo __('admin.email_password_reset', ['default' => 'Email Password Reset']); ?>

                        </a>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('users.update-balance', ['user' => $user->id])); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="form-group col-md-8 col-8">
                                    <label><?php echo __('admin.amount'); ?></label>
                                    <input type="number" class="form-control" name="amount" value="0" step="0.01" required="">
                                </div>
                                <div class="form-group col-md-4 col-4">
                                    <label><?php echo __('admin.type'); ?></label>
                                    <select id="type" name="type" class="form-control">
                                        <option value="+"><?php echo __('admin.ADD'); ?></option>
                                        <option value="-"><?php echo __('admin.REMOVE'); ?></option>
                                        <option value="="><?php echo __('admin.SET'); ?></option>
                                    </select>
                                </div>
                                <div class="col-12" style="display: flex;justify-content: space-between;">
                                    <div class="profile-widget-name">
                                        <?php echo __('admin.current_balance', ['default' => 'Current Balance']); ?>:
                                        <strong><?php echo e(currency('symbol')); ?><?php echo e(number_format( $user->balance ,2)); ?></strong>
                                    </div>
                                    <button class="btn btn-dark" type="submit">
                                        <?php echo __('admin.update_balance', ['default' => 'Update Balance']); ?>

                                    </button>
                                </div>
                            </div>
                        </form>
                        <hr>
                        <div class="summary">
                            <div class="summary-item">
                                <h6>
                                    <?php echo __('admin.balance_history', ['default' => 'Balance History']); ?>

                                    <span
                                        class="text-muted">
                                        (<?php echo e($user->balance_transactions->count()); ?> <?php echo __('admin.transactions', ['default' => 'transactions']); ?>)
                                    </span>
                                </h6>
                                <ul class="list-unstyled list-unstyled-border">
                                    <?php $__currentLoopData = $user->balance_transactions()->latest()->paginate(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="media">
                                            <div class="media-body">
                                                <div class="media-title"><a href="#"><?php echo e($transaction->description); ?></a>
                                                </div>
                                                <div class="text-muted text-medium">
                                                    <?php echo __('admin.before_transaction', ['default' => 'Before transaction']); ?>

                                                    :
                                                    <?php echo e(currency('symbol')); ?><?php echo e(number_format($transaction->balance_before_transaction, 2)); ?>

                                                    <div class="bullet"></div>
                                                    <?php echo e($transaction->created_at->diffForHumans()); ?>

                                                    <div class="bullet"></div>
                                                    <span class="<?php if($transaction->result == '+' ): ?> text-success
                                                        <?php elseif($transaction->result == '-'): ?> text-danger
                                                        <?php else: ?> text-secondary <?php endif; ?>">
                                                        <?php echo e($transaction->result); ?> <?php echo e(currency('symbol')); ?><?php echo e(number_format($transaction->amount, 2)); ?>

                                                    </span>
                                                </div>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                                <?php echo e($user->balance_transactions()->latest()->paginate(5)->links(AdminTheme::pagination())); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <div class="summary">

                            <div class="summary-item">
                                <h6>
                                    <?php echo __('admin.device_list', ['default' => 'Device List']); ?>

                                    <span
                                        class="text-muted">(<?php echo e($user->devices->count()); ?> <?php echo e(mb_strtolower(__('admin.items'))); ?>)</span>
                                </h6>
                                <ul class="list-unstyled list-unstyled-border">

                                    <?php $__currentLoopData = $user->devices()->latest()->paginate(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="media">
                                            <?php if($device->device_name == 'Phone'): ?>
                                                <svg class="dark:text-white mr-2" fill="none" stroke="currentColor"
                                                     style="width: 2rem; height: 2rem"
                                                     viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                          stroke-width="2"
                                                          d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z">
                                                    </path>
                                                </svg>
                                            <?php else: ?>
                                                <svg class="w-6 h-6 dark:text-white mr-2" fill="none"
                                                     stroke="currentColor" style="width: 2rem; height: 2rem"
                                                     viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                          stroke-width="2"
                                                          d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                                                    </path>
                                                </svg>
                                            <?php endif; ?>
                                            <div class="media-body">
                                                <div class="media-right"><a href="<?php echo e(route('admin.user.devices.destroy', ['user' => $user->id, 'device' => $device->id])); ?>"
                                                                            class="btn btn-icon btn-sm btn-danger"><i
                                                            class="fas fa-trash-alt"></i></a> <a href="<?php echo e(route('admin.user.devices.revoke', ['user' => $user->id, 'device' => $device->id])); ?>"
                                                                                                 class="btn btn-icon btn-sm btn-warning"><i
                                                            class="fas fa-recycle"></i></a></div>
                                                <div class="media-title"><a href="#"><?php echo e($device->device_type); ?></a>
                                                </div>
                                                <div class="text-muted text-small"><?php if(!$device->is_revoked): ?>
                                                        <span
                                                            class="text-success"><?php echo __('admin.active', ['default' => 'active']); ?></span>
                                                    <?php else: ?>
                                                        <span
                                                            class="text-danger"><?php echo __('admin.revoked', ['default' => 'revoked']); ?></span>
                                                    <?php endif; ?>
                                                    <div class="bullet"></div>
                                                    <a href="#"><?php echo e($device->ip_address); ?></a>
                                                    <div
                                                        class="bullet"></div> <?php echo e($device->last_login_at->diffForHumans()); ?>

                                                </div>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </ul>
                                <?php echo e($user->devices()->latest()->paginate(5)->links(AdminTheme::pagination())); ?>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="col-12 col-md-12 col-lg-8">

                <div class="card">
                    <div class="card-header">
                        <h4><?php echo __('admin.statistics', ['default' => 'Statistics']); ?></h4>
                        <div class="card-header-action">
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="summary">
                            <div class="summary-info">
                                <h4><?php echo e(currency('symbol')); ?><?php echo e(number_format($user->payments()->whereStatus('paid')->getAmountSum(), 2)); ?></h4>
                                <div class="text-muted"><?php echo e($user->payments()->whereStatus('paid')->count()); ?>

                                    <?php echo __('admin.payments', ['default' => 'payments']); ?> <?php echo __('admin.on', ['default' => 'on']); ?> <?php echo e($user->orders()->count()); ?> <?php echo e(mb_strtolower(__('admin.orders'))); ?>

                                </div>
                                <div class="d-block mt-2">
                                    <a href="<?php echo e(route('admin.user.orders', $user->id)); ?>"><?php echo __('admin.view_all', ['default' => 'View All']); ?></a>
                                </div>
                            </div>
                            <div class="summary-item">
                                <h6><?php echo __('admin.order_list', ['default' => 'Order List']); ?>

                                    <span
                                        class="text-muted">(<?php echo e($user->orders->count()); ?> <?php echo e(mb_strtolower(__('admin.items'))); ?>)</span>
                                </h6>
                                <ul class="list-unstyled list-unstyled-border">
                                    <?php $__currentLoopData = $user->orders()->paginate(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="media">
                                            <a href="<?php echo e(route('orders.edit', $order->id)); ?>">
                                                <img class="mr-3 rounded" width="50"
                                                     src="<?php echo e(asset('storage/products/' . $order->package['icon'])); ?>"
                                                     alt="icon">
                                            </a>
                                            <div class="media-body">
                                                <div class="media-right">
                                                    <?php echo e(currency('symbol')); ?><?php echo e(number_format($order->price['renewal_price'], 2)); ?>

                                                    /
                                                    <?php echo e($order->periodToHuman()); ?>

                                                </div>
                                                <div class="media-title"><a href="<?php echo e(route('orders.edit', $order->id)); ?>"><?php echo e($order->name); ?></a></div>
                                                <div class="text-muted text-small"><?php echo e(mb_strtolower(__('admin.' . $order->status))); ?>

                                                    <div class="bullet"></div>
                                                    <?php echo e($order->service); ?>

                                                    <div
                                                        class="bullet"></div> <?php echo e($order->due_date->translatedFormat(settings('date_format', 'd M Y'))); ?>

                                                </div>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                                <?php echo e($user->orders()->paginate(5)->links(AdminTheme::pagination())); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <form method="post" action="<?php echo e(route('users.update', ['user' => $user->id])); ?>"
                          class="needs-validation" novalidate="">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('put'); ?>
                        <div class="card-header">
                            <h4><?php echo __('admin.edit_profile', ['default' => 'Edit Profile']); ?></h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-md-12 col-12">
                                    <label><?php echo __('admin.username'); ?></label>
                                    <input type="text" class="form-control" name="username"
                                           value="<?php echo e($user->username); ?>" required/>
                                </div>
                                <div class="form-group col-md-6 col-12">
                                    <label><?php echo __('admin.first_name', ['default' => 'First Name']); ?></label>
                                    <input type="text" class="form-control" name="first_name"
                                           value="<?php echo e($user->first_name); ?>"/>
                                </div>
                                <div class="form-group col-md-6 col-12">
                                    <label><?php echo __('admin.last_name', ['default' => 'Last Name']); ?></label>
                                    <input type="text" class="form-control" name="last_name"
                                           value="<?php echo e($user->last_name); ?>"/>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-md-12 col-12">
                                    <label><?php echo __('admin.email'); ?></label>
                                    <input type="email" class="form-control" name="email" value="<?php echo e($user->email); ?>"/>
                                    <div class="invalid-feedback">
                                        <?php echo __('admin.fill_in_email', ['default' => 'Please fill in the email']); ?>

                                    </div>
                                </div>

                                <div class="form-group col-md-12 col-12">
                                    <label><?php echo __('admin.password'); ?></label>
                                    <input type="password" class="form-control" name="password"/>
                                    <div class="small mt-1">
                                        <?php echo __('admin.edit_password_desc', ['default' => 'Leave this field empty if you don\'t want to reset the password']); ?>

                                    </div>
                                </div>

                                <div class="form-group col-md-12 col-12">
                                    <label><?php echo __('admin.status'); ?></label>
                                    <select class="form-control select2 select2-hidden-accessible " name="status"
                                            tabindex="-1" aria-hidden="true">
                                        <option value="active" <?php if($user->status == 'active'): ?> selected <?php endif; ?>>
                                            <?php echo __('admin.active'); ?>

                                        </option>
                                        <option value="pending" <?php if($user->status == 'pending'): ?> selected <?php endif; ?>>
                                            <?php echo __('admin.pending'); ?>

                                        </option>
                                        <option value="suspended" <?php if($user->status == 'suspended'): ?> selected <?php endif; ?>>
                                            <?php echo __('admin.suspended'); ?>

                                        </option>
                                    </select>
                                </div>

                                <div class="form-group col-md-12 col-12">
                                    <label><?php echo __('admin.groups'); ?></label>
                                    <select
                                        class="form-control select2 select2-hidden-accessible  <?php $__errorArgs = ['groups'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="groups[]" multiple="" tabindex="-1" aria-hidden="true">
                                        <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($group->id); ?>"
                                                    <?php if($user->groups()->find($group->id)): ?> selected <?php endif; ?>><?php echo e($group->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['groups'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-md-12 col-12">
                                    <label><?php echo __('admin.company_name', ['default' => 'Company Name']); ?> <?php echo __('admin.optional'); ?></label>
                                    <input type="text" class="form-control" name="company_name"
                                           value="<?php echo e($user->address->company_name ?? ''); ?>"/>
                                </div>

                                <div class="form-group col-md-12 col-12">
                                    <label><?php echo __('admin.street'); ?></label>
                                    <input type="text" class="form-control" name="address"
                                           value="<?php echo e($user->address->address ?? ''); ?>"/>
                                </div>

                                <div class="form-group col-md-12 col-12">
                                    <label><?php echo __('admin.street_2', ['default' => 'Street 2']); ?></label>
                                    <input type="text" class="form-control" name="address_2"
                                           value="<?php echo e($user->address->address_2 ?? ''); ?>"/>
                                </div>

                                <div class="form-group col-md-3 col-6">
                                    <label><?php echo __('admin.zip_code', ['default' => 'Zip Code']); ?></label>
                                    <input type="text" class="form-control" name="zip_code"
                                           value="<?php echo e($user->address->zip_code ?? ''); ?>"/>
                                </div>

                                <div class="form-group col-md-3 col-6">
                                    <label><?php echo __('admin.city'); ?></label>
                                    <input type="text" class="form-control" name="city"
                                           value="<?php echo e($user->address->city ?? ''); ?>"/>
                                </div>

                                <div class="form-group col-md-3 col-6">
                                    <label><?php echo __('admin.province_state', ['default' => 'Province / State']); ?></label>
                                    <input type="text" class="form-control" name="region"
                                           value="<?php echo e($user->address->region ?? ''); ?>"/>
                                </div>

                                <div class="form-group col-md-3 col-6">
                                    <label for="inputState"><?php echo __('admin.country'); ?> *</label>
                                    <select id="inputState" name="country"
                                            class="form-control select2 select2-hidden-accessible">
                                        <?php $__currentLoopData = config('utils.countries'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>" <?php if($user->address->country == $key): ?> selected <?php endif; ?>><?php echo e($country); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group mb-0 col-12">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" name="is_subscribed" class="custom-control-input"
                                               id="newsletter" <?php if($user->is_subscribed): ?> checked <?php endif; ?>/>
                                        <label class="custom-control-label" for="newsletter">
                                            <?php echo __('admin.subscribe_to_newsletter', ['default' => 'Subscribe to newsletter']); ?>

                                        </label>
                                        <div class="text-muted form-text">
                                            <?php echo __('admin.subscribe_to_newsletter_desc', ['default' => 'This user will get new information about products, offers and promotions']); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer text-right">
                            <button class="btn btn-danger" type="button" onclick="deleteUser()"><?php echo __('admin.delete', ['default' => 'Delete']); ?></button>
                            <button class="btn btn-dark" type="submit"><?php echo __('admin.update_changes', ['default' => 'Update Changes']); ?></button>
                        </div>
                    </form>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h4><?php echo __('admin.upload_new_avatar', ['default' => 'Upload new Avatar']); ?></h4>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.user.update-avatar', ['user' => $user->id])); ?>" method="POST"
                              class="drop-zone-md" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="file" name="avatar" accept="image/*" required>
                    </div>
                    <div class="card-footer text-right">
                        <a href="<?php echo e(route('admin.user.reset-avatar', ['user' => $user->id])); ?>" class="btn btn-danger">
                            <?php echo __('admin.reset_avatar', ['default' => 'Reset Avatar']); ?>

                        </a>
                        <button class="btn btn-dark"
                                type="submit"><?php echo __('admin.upload_avatar', ['default' => 'Upload Avatar']); ?></button>
                    </div>
                    </form>
                </div>

            </div>
        </div>
        </div>
    </section>

<script>
    function deleteUser() {
        if (window.confirm('Are you sure you want to delete this user? All orders, payments and all other data belonging to the user will be deleted')) {
            window.location.href = "/admin/users/<?php echo e($user->id); ?>/delete";
        } else {
            event.preventDefault();
        }
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.users'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/users/edit.blade.php ENDPATH**/ ?>