<?php $__env->startSection('container'); ?>
<div class="col-12 col-md-12 col-lg-12">
  <form action="<?php echo e(route('tickets.departments.update', $department->id)); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <div class="card">
      <div class="card-header">
        <h4>
          Edit Department
        </h4>
      </div>
      <div class="card-body p-0">

        <div class="form-group col-12">
          <label>Name</label>
          <input type="text" name="name" value="<?php echo e($department->name); ?>" required class="form-control">
        </div>

        <div class="form-group col-12">
          <label>Description</label>
          <input type="text" name="description" value="<?php echo e($department->description); ?>" class="form-control">
        </div>

        <?php if ($__env->exists(AdminTheme::moduleView('tickets', 'editor'))) echo $__env->make(AdminTheme::moduleView('tickets', 'editor'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="form-group col-12">
          <label>Template</label>
          <textarea name="template" class="form-control"><?php echo $department->template; ?></textarea>
          <small class="form-text text-muted">
            This template will be presented when a user tries to create a new ticket in this department
          </small>
        </div>

        <div class="form-group col-12">
          <label>Auto Response</label>
          <textarea name="auto_response_template" class="form-control"><?php echo $department->auto_response_template; ?></textarea>
          <small class="form-text text-muted">
            The bot will automatically respond to the user after their ticket has been created
          </small>
        </div>

        <div class="form-group col-12">
          <label>Auto close after hour</label>
          <input type="number" name="auto_close_after" value="<?php echo e($department->auto_close_after); ?>" required class="form-control">
          <small class="form-text text-muted">
            After how many hours of inactivity should the ticket automatically be closed. Set "0" not to close
          </small>
        </div>

        <div class="form-group col-12">
          <label>Auto lock after hour</label>
          <input type="number" name="auto_lock_after" value="<?php echo e($department->auto_lock_after); ?>" required class="form-control">
          <small class="form-text text-muted">
            After how many hours of inactivity should the ticket automatically be locked. Set "0" not to lock
          </small>
        </div>

      </div>
      <div class="card-footer" style="display: flex; justify-content: space-between">
        <a href="<?php echo e(route('tickets.departments.delete', $department->id)); ?>" class="btn btn-danger">Delete</a>
        <button type="submit" class="btn btn-success">Update</button>
      </div>
    </div>
  </form>

</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make(AdminTheme::wrapper(), ['title' => 'Departments', 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/Modules/Tickets/Resources/views/admin/default/departments/edit.blade.php ENDPATH**/ ?>