<?php $__env->startSection('container'); ?>
    <section class="section">
        <div class="section-body">
            <div class="col-12">
                <?php if ($__env->exists(AdminTheme::path('users.user_nav'))) echo $__env->make(AdminTheme::path('users.user_nav'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>

        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4><?php echo __('admin.alt_accounts', ['default' => 'Alt Accounts']); ?></h4>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <tbody>
                            <tr>
                                <th><?php echo __('admin.user'); ?></th>
                                <th><?php echo __('admin.email'); ?></th>
                                <th><?php echo __('admin.create_at'); ?></th>
                                <th><?php echo __('admin.ip_address', ['default' => 'IP Address']); ?></th>
                                <th class="text-right"><?php echo __('admin.actions'); ?></th>
                            </tr>
                            <?php $__currentLoopData = $ips->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($ip->hasDuplicateIp($user->id) !== NULL): ?>
                                    <tr>
                                        <td class="text-left">
                                            <img alt="<?php echo e(__('Image')); ?>" src="<?php echo e($ip->hasDuplicateIp($user->id)->avatar()); ?>"
                                                 class="rounded-circle mr-2" width="35" data-toggle="tooltip" title=""
                                                 data-original-title="<?php echo e($ip->hasDuplicateIp($user->id)->first_name); ?> <?php echo e($ip->hasDuplicateIp($user->id)->last_name); ?>">
                                            <?php echo e($ip->hasDuplicateIp($user->id)->username); ?>

                                        </td>
                                        <td class="align-middle">
                                            <?php echo e($ip->hasDuplicateIp($user->id)->email); ?>

                                        </td>
                                        <td><?php echo e($ip->hasDuplicateIp($user->id)->created_at); ?></td>
                                        <td><?php echo e($ip->ip_address); ?></td>
                                        <td class="text-right">
                                            <a href="#" class="btn btn-danger"><i
                                                    class="fas fa-solid fa-trash-can"></i> <?php echo __('admin.delete'); ?></a>
                                            <a href="<?php echo e(route('users.edit', ['user' => $ip->hasDuplicateIp($user->id)->id])); ?>"
                                               class="btn btn-primary"><i
                                                    class="fas fa-solid fa-user"></i> <?php echo __('admin.edit'); ?></a>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <table class="table">
                        <thead>
                        <tr>
                            <th scope="col"><?php echo __('admin.ip_address', ['default' => 'IP Address']); ?></th>
                            <th scope="col"><?php echo e(__('admin.times_used')); ?></th>
                            <th class="text-right" scope="col"><?php echo __('admin.data'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $ips->paginate(15); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($ip->ip_address); ?></td>
                                <td><?php echo e($ip->uses); ?></td>
                                <td class="text-right"><?php echo e($ip->updated_at->diffForHumans()); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php echo e($ips->paginate(15)->links(AdminTheme::pagination())); ?>

                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.activity'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/users/activity.blade.php ENDPATH**/ ?>