<?php $__env->startSection('css_libraries'); ?>
<link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>" />
<link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
<script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
<script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <form action="<?php echo e(route('admin.settings.store')); ?>" method="POST">
            <div class="card-header">
              <h4>Ticket Settings</h4>
            </div>
            <div class="card-body">
                <?php echo csrf_field(); ?>
              <div class="row">
                <div class="form-group col-12">
                  <a href="<?php echo e(route('admin.tickets.view-api-key')); ?>" class="btn btn-primary">
                    View API Key
                  </a>
                    <a href="<?php echo e(route('admin.tickets.create-api-key')); ?>" class="btn btn-warning">
                        Regenerate API Key
                    </a>
                </div>
                <div class="form-group col-12">
                  <div class="control-label">
                      Enable Discord Sync
                  </div>
                  <label class="custom-switch mt-2" 
                  onclick="location.href = '<?php if(settings('tickets::discord_sync', false)): ?> /admin/settings/store?tickets::discord_sync=0 <?php else: ?> /admin/settings/store?tickets::discord_sync=1 <?php endif; ?>';">
                      <input type="checkbox" name="tickets::discord_sync" value="1" <?php if(settings('tickets::discord_sync')): ?> checked <?php endif; ?> class="custom-switch-input">
                      <span class="custom-switch-indicator"></span>
                      <span class="custom-switch-description">
                          Enable syncronization between tickets on the website and Discord
                      </span>
                  </label>
              </div>
              <?php if(settings('tickets::discord_sync', false)): ?>
                <div class="form-group col-12">
                    <label>Discord Server</label>
                    <input type="number" name="tickets::discord_server" value="<?php echo App\Models\Settings::get('tickets::discord_server', '', ); ?>" class="form-control">
                    <small class="text-sm mt-2">The ID of the Discord server where tickets should be created</small>
                </div>
                <div class="form-group col-12">
                  <label>Channel ID</label>
                  <input type="number" name="tickets::discord_channel_id" value="<?php echo App\Models\Settings::get('tickets::discord_channel_id', '', ); ?>" class="form-control">
                  <small class="text-sm mt-2">The ID of the channel where tickets should be created</small>
                </div>
              <?php endif; ?>
                <div class="form-group col-12">
                    <label>Bot Avatar</label>
                    <input type="text" name="tickets::bot_avatar" value="<?php echo App\Models\Settings::get('tickets::bot_avatar', settings('logo', 'https://imgur.com/oJDxg2r.png'), ); ?>" class="form-control">
                    <div class="gallery gallary mt-3">
                        <div class="gallery-item" data-image="<?php echo App\Models\Settings::get('tickets::bot_avatar', settings('logo', 'https://imgur.com/oJDxg2r.png'), ); ?>" data-title="Image 1" href="<?php echo App\Models\Settings::get('tickets::bot_avatar', settings('logo', 'https://imgur.com/oJDxg2r.png'), ); ?>" title="Image 1" style="background-image: url('<?php echo App\Models\Settings::get('tickets::bot_avatar', settings('logo', 'https://imgur.com/oJDxg2r.png'), ); ?>')');"></div>
                      </div>
                </div>
              </div>
            </div>
            <div class="card-footer text-right">
              <button type="submit" class="btn btn-primary"><?php echo __('admin.submit'); ?></button>
            </div>
          </div>
        </form>
    </div>
</div>
<style>
    span.select2.select2-container.select2-container--default {
        width: 100% !important;
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.settings'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/Modules/Tickets/Resources/views/admin/default/settings.blade.php ENDPATH**/ ?>