<?php $__env->startSection('container'); ?>
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header"><?php echo e(__('admin.news')); ?></div>

                <div class="card-body">
                    <a href="<?php echo e(route('articles.create')); ?>" class="btn btn-primary"><?php echo e(__('admin.create_article')); ?></a>
                    <hr>

                    <table class="table">
                        <thead>
                            <tr>
                                <th><?php echo __('admin.id'); ?></th>
                                <th><?php echo __('admin.name'); ?></th>
                                <th><?php echo __('admin.url', ['default' => 'URL']); ?></th>
                                <th><?php echo __('admin.status'); ?></th>
                                <th class="text-right"><?php echo __('admin.actions'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($article->id); ?></td>
                                    <td><?php echo e($article->title); ?></td>
                                    <td><?php echo e(route('news.article', $article->path)); ?></td>
                                    <td><?php if(true): ?>
                                            <i class="fas fa-solid fa-circle text-success " style="font-size: 11px;"></i> <?php echo __('admin.active'); ?>

                                        <?php else: ?>
                                            <i class="fas fa-solid fa-circle text-danger " style="font-size: 11px;"></i> <?php echo __('admin.inactive'); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td class="text-right">
                                        <a href="<?php echo e(route('articles.translation', $article->id)); ?>"
                                           class="btn btn-warning"><?php echo e(__('admin.translations')); ?></a>
                                        <a href="<?php echo e(route('articles.edit', $article->id)); ?>"
                                            class="btn btn-primary"><?php echo __('admin.edit'); ?></a>

                                        <form action="<?php echo e(route('articles.destroy', $article->id)); ?>" method="POST"
                                            style="display: inline-block;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button onclick="deleteItem(event)" type="submit"
                                                class="btn btn-danger"><?php echo __('admin.delete'); ?></button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' =>  'News', 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/articles/index.blade.php ENDPATH**/ ?>