<?php $__env->startSection('title', __('client.dashboard')); ?>


<?php $__env->startSection('keywords', 'WemX Dashboard, WemX Panel'); ?>

<?php $__env->startSection('container'); ?>
    <div class="flex flex-wrap ">
        <div class="lg:w-1/4 pr-4 pl-4 md:w-1/3 pr-4 pl-4 sm:w-1/2 pr-4 pl-4 w-full">
            <?php echo $__env->make(Theme::path('layouts.widgets.user_balance'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="lg:w-3/4 pr-4 pl-4 md:w-2/3 pr-4 pl-4 sm:w-1/2 pr-4 pl-4 w-full">

            <?php echo $__env->make(Theme::path('layouts.widgets.service_stats'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <section class="dark:bg-gray-900 py-3 sm:py-5">
                <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
                    <?php if(auth()->user()->balance_transactions()->count() == 0): ?>

                        <?php echo $__env->make(Theme::path('empty-state'), ['title' => 'No records found', 'description' => 'You have an empty balance history, click the widget to update your balance.'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php else: ?>

                    <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
                        <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                            <tr>
                                <th scope="col" class="px-6 py-3">
                                    <?php echo __('client.description'); ?>

                                </th>
                                <th scope="col" class="px-6 py-3">
                                    <div class="flex items-center">
                                        <?php echo __('client.balance_before_transaction'); ?>

                                    </div>
                                </th>
                                <th scope="col" class="px-6 py-3">
                                    <div class="flex justify-end">
                                        <?php echo __('client.amount'); ?>

                                    </div>
                                </th>
                                <th scope="col" class="px-6 py-3">
                                    <div class="flex items-center">
                                        <?php echo __('client.date'); ?>

                                    </div>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = auth()->user()->balance_transactions()->latest()->paginate(15); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="bg-white border-b dark:bg-gray-800 dark:border-gray-700">
                                <th scope="row" class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap dark:text-white">
                                    <a href="<?php if(isset($transaction->payment_id)): ?><?php echo e(route('invoice', ['payment' => $transaction->payment_id])); ?><?php else: ?> # <?php endif; ?>"><?php echo e($transaction->description); ?></a>
                                </th>
                                <td class="px-6 py-4">
                                    <?php echo e(currency('symbol')); ?><?php echo e(number_format($transaction->balance_before_transaction, 2)); ?>

                                </td>
                                <td class="px-6 py-4 text-right">
                                    <?php if($transaction->result == '+'): ?>
                                        <span class="bg-green-100 text-green-800 text-sm font-medium mr-2 px-2.5 py-0.5 rounded dark:bg-green-900 dark:text-green-300">
                                            <?php echo e($transaction->result); ?> <?php echo e(currency('symbol')); ?><?php echo e(number_format($transaction->amount, 2)); ?></span>
                                    <?php elseif($transaction->result == '-'): ?>
                                        <span class="bg-red-100 text-red-800 text-sm font-medium mr-2 px-2.5 py-0.5 rounded dark:bg-red-900 dark:text-red-300">
                                            <?php echo e($transaction->result); ?> <?php echo e(currency('symbol')); ?><?php echo e(number_format($transaction->amount, 2)); ?></span>
                                    <?php elseif($transaction->result == '='): ?>
                                        <span class="bg-gray-100 text-gray-800 text-sm font-medium mr-2 px-2.5 py-0.5 rounded dark:bg-gray-700 dark:text-gray-300">
                                            <?php echo e($transaction->result); ?> <?php echo e(currency('symbol')); ?><?php echo e(number_format($transaction->amount, 2)); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="pl-3">
                                        <div class="text-base font-semibold text-sm"><?php echo e($transaction->created_at->translatedFormat('d M Y')); ?></div>
                                        <div class="font-normal text-gray-500"><?php echo e($transaction->created_at->diffForHumans()); ?></div>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <div class="pagination mt-3 flex justify-end">
                    <?php echo e(auth()->user()->balance_transactions()->latest()->paginate(15)->links(Theme::pagination())); ?>

                </div>
                <?php endif; ?>
            </section>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(Theme::wrapper(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/client/tailwind/dashboard/balance.blade.php ENDPATH**/ ?>