<?php

use App\Http\Controllers\Auth\OauthController;
use App\Http\Controllers\Client\ContactUsController;
use App\Http\Controllers\Client\DashboardController;
use App\Http\Controllers\Client\NewsController;
use App\Http\Controllers\Client\EmailHistoryController;
use App\Http\Controllers\Client\MaintenanceController;
use App\Http\Controllers\Client\NotificationsController;
use App\Http\Controllers\Client\PaymentController;
use App\Http\Controllers\Client\PortalController;
use App\Http\Controllers\Client\ServiceController;
use App\Http\Controllers\Client\StoreController;
use App\Http\Controllers\Client\SubscriptionController;
use App\Http\Controllers\Client\SupportChatController;
use App\Http\Middleware\TwoFactorAuthentication;
use App\Http\Controllers\Client\UserController;
use App\Http\Middleware\Maintenance;
use Illuminate\Support\Facades\Route;
use App\Http\Middleware\Punishments;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [PortalController::class, 'index'])->name('portal');
Route::get('/p/{page}', [DashboardController::class, 'page'])->name('page');

// Store group => /store
Route::prefix('store')->group(function () {
    Route::get('/', [StoreController::class, 'index'])->name('store.index');
    Route::get('/{service}', [StoreController::class, 'service'])->name('store.service');
    Route::get('/view/{package}', [StoreController::class, 'viewPackage'])->name('store.package');
    Route::get('/{package}/pricing', [StoreController::class, 'pricing'])->name('store.pricing');
    Route::get('/validate-coupon/{package}/{code}', [StoreController::class, 'validateCoupon'])->name('validate-coupon');
});

Route::get('/contact-us', [ContactUsController::class, 'contact'])->name('contact')->withoutMiddleware(TwoFactorAuthentication::class);;
Route::post('/contact-us', [ContactUsController::class, 'submit'])->name('contact.submit')->withoutMiddleware(TwoFactorAuthentication::class);;

Route::get('/suspended', [DashboardController::class, 'suspended'])->name('suspended')->withoutMiddleware(Punishments::class);

Route::middleware('auth')->group(function () {

    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    Route::prefix('/news')->group(function () {
        Route::get('/', [NewsController::class, 'index'])->name('news.index')->withoutMiddleware('auth');
        Route::get('/{article}', [NewsController::class, 'article'])->name('news.article')->withoutMiddleware('auth');
        Route::post('/{article}/comment', [NewsController::class, 'comment'])->name('news.comment')->middleware('throttle:5,15');
        Route::get('/{article}/{emoji}', [NewsController::class, 'react'])->name('news.react');
        Route::get('/rating/{article}/{rating}', [NewsController::class, 'helpful'])->name('news.helpful')->withoutMiddleware('auth');
        Route::get('/comment/{comment}/upvote', [NewsController::class, 'upvoteComment'])->name('news.comments.upvote')->middleware('throttle:3,15');
        Route::get('/comment/{comment}/downvote', [NewsController::class, 'downvoteComment'])->name('news.comments.downvote')->middleware('throttle:3,15');
        Route::get('/comment/{comment}/remove', [NewsController::class, 'removeComment'])->name('news.comments.remove');
        Route::get('/comment/{comment}/report', [NewsController::class, 'reportComment'])->name('news.comments.report');

    });

    // Filter Routes
    Route::prefix('filter')->group(function () {
        Route::any('/order/{status}', [DashboardController::class, 'filterOrders'])->name('filter-orders');
    });

    Route::prefix('invites')->group(function () {
        Route::get('/', [DashboardController::class, 'invites'])->name('invites.index');
        Route::get('/{invite}/accept', [DashboardController::class, 'acceptInvite'])->name('invites.accept');
        Route::get('/{invite}/reject', [DashboardController::class, 'rejectInvite'])->name('invites.reject');
    });

    // Service Routes
    Route::prefix('service')->group(function () {
        Route::any('/{order}/{page}', [ServiceController::class, 'service'])->name('service');
        Route::get('/package/{package}/prices', [ServiceController::class, 'getPackagePrices'])->name('package.prices');
    });

    // Notifications group => /notifications
    Route::prefix('notifications')->group(function () {
        Route::get('/mark-all-as-read', [NotificationsController::class, 'markAllAsRead'])->name('notifications.mark-as-read');
    });

    // Email History => /email-history
    Route::prefix('email-history')->group(function () {
        Route::get('/', [EmailHistoryController::class, 'index'])->name('email.history');
        Route::get('/{email}/download', [EmailHistoryController::class, 'download'])->name('email.download');
    });

    // Email History => /email-history
    Route::prefix('subscriptions')->group(function () {
        Route::get('/', [SubscriptionController::class, 'index'])->name('subscription.index');
        Route::post('/store', [SubscriptionController::class, 'store'])->name('subscription.store');
        Route::get('/prices/{package}', [SubscriptionController::class, 'getPricesForPackage'])->name('subscription.prices');
    });

    // User Settings group => /user/settings
    Route::prefix('/user/settings')->group(function () {
        Route::get('/', [UserController::class, 'settings'])->name('user.settings');
        Route::post('/update', [UserController::class, 'updateUser'])->name('update-username');
        Route::post('/update-address', [UserController::class, 'updateAddress'])->name('update-address')->withoutMiddleware(Maintenance::class);
        Route::post('/upload-avatar', [UserController::class, 'uploadProfilePicture'])->name('upload-profile-picture');
        Route::post('/update-email', [UserController::class, 'updateEmail'])->name('update-email');
        Route::post('/update-password', [UserController::class, 'updatePassword'])->name('update-password');
        Route::post('/download-data', [UserController::class, 'downloadUserData'])->name('user.download-data');
        Route::get('/revoke/{device}', [UserController::class, 'revoke'])->name('revoke');
        Route::get('/visibility/{status}', [UserController::class, 'visibility'])->name('user.visibility');
        Route::post('/request-removal', [UserController::class, 'deleteUserAccount'])->name('user.request-removal');
        Route::get('/request-cancel', [UserController::class, 'cancelDeleteUserAccount'])->name('user.cancel-removal');
    });

    Route::prefix('/balance')->group(function () {
        Route::get('/', [DashboardController::class, 'balance'])->name('balance');
        Route::any('/add', [PaymentController::class, 'createBalancePayment'])->name('balance.add');
    });

    Route::prefix('/oauth/{service}')->group(function () {
        Route::get('/connect', [OauthController::class, 'connect'])->name('oauth.connect');
        Route::get('/remove', [OauthController::class, 'remove'])->name('oauth.remove');
        Route::get('/redirect', [OauthController::class, 'callback'])->name('oauth.callback');
    });

    Route::prefix('/invoices')->group(function () {
        Route::get('/', [DashboardController::class, 'invoices'])->name('invoices');
    });

    Route::prefix('payment')->group(function () {
        Route::any('/package/{package}', [PaymentController::class, 'createOrderPayment'])->name('payment.package');
        Route::any('/process/{gateway}/{payment}', [PaymentController::class, 'processPayment'])->name('payment.process');
        Route::any('/return/{gateway}', [PaymentController::class, 'paymentReturn'])->name('payment.return')->withoutMiddleware('auth');
        Route::any('/create/order/subscription', [PaymentController::class, 'createOrderSubscription'])->name('payment.create_order_subscription');

        Route::any('/cancel/{payment}', [PaymentController::class, 'paymentCancel'])->name('payment.cancel');
        Route::any('/success/{payment}', [PaymentController::class, 'paymentSuccess'])->name('payment.success');

        Route::get('/invoice/{payment}', [PaymentController::class, 'invoice'])->name('invoice');
        Route::get('/invoice/{payment}/download', [PaymentController::class, 'downloadInvoice'])->name('invoice.download');
        Route::any('/invoice/{payment}/pay', [PaymentController::class, 'payInvoice'])->name('invoice.pay');
    });

    Route::prefix('/restricted')->withoutMiddleware(Maintenance::class)->group(function () {
        Route::get('/account-activation', [MaintenanceController::class, 'activation'])->name('restricted.activation');
        Route::get('/maintenance', [MaintenanceController::class, 'maintenance'])->name('restricted.maintenance');
    });

    Route::prefix('support/chat')->group(function () {
        Route::get('/', [SupportChatController::class, 'chat'])->name('support.chat');
        Route::get('/req', [SupportChatController::class, 'interactWithChatGPT'])->name('support.req');
    });

});





// Custom assets
Route::get('assets/{template}/{path}', function ($template, $path) {
    $path = resource_path('themes/client/' . $template . '/assets/' . $path);
    if (file_exists($path)) {
        return response()->file($path);
    }
    abort(404);
})->name('client-assets');

