<?php

use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\Auth\ReAuthenticationController;
use App\Http\Controllers\Auth\TwoFactorController;
use App\Http\Middleware\CheckRevokedDevices;
use App\Http\Middleware\TwoFactorAuthentication;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::middleware('auth')->group(function () {
    Route::get('/auth/logout', [AuthController::class, 'logout'])->name('logout')->withoutMiddleware(App\Http\Middleware\Maintenance::class);

    Route::get('/auth/{device}/reauthenticate', [ReAuthenticationController::class, 'client'])
        ->name('client.reauthenticate')->withoutMiddleware(CheckRevokedDevices::class);
    Route::post('/auth/{device}/reauthenticate', [ReAuthenticationController::class, 'clientPost'])
        ->name('client.reauthenticate.post')->withoutMiddleware(CheckRevokedDevices::class);
    
    Route::get('/admin/reauthenticate', [ReAuthenticationController::class, 'index'])->name('reauthenticate');
    Route::post('/admin/reauthenticate', [ReAuthenticationController::class, 'reauthenticate'])->name('reauthenticate.submit');
});

Route::middleware('auth')->prefix('/auth/verification')->withoutMiddleware(App\Http\Middleware\Maintenance::class)->group(function () {
    Route::get('/', [AuthController::class, 'verification'])->name('verification');
    Route::post('/validate', [AuthController::class, 'validateVerification'])->name('verification.validate');
});

Route::middleware('auth')->prefix('/two-factor-authentication')->group(function () {
    Route::post('/disable', [TwoFactorController::class, 'disableTwoFactor'])->name('2fa.disable');
    Route::get('/setup', [TwoFactorController::class, 'enableTwoFactor'])->name('2fa.setup');
    Route::post('/setup', [TwoFactorController::class, 'setupTwoFactor'])->name('2fa.setup.validate');
    Route::get('/recovery', [TwoFactorController::class, 'recovery'])->name('2fa.recovery');
    Route::get('/recovery/download', [TwoFactorController::class, 'downloadRecoveryCodes'])->name('2fa.recovery.download');
    Route::post('/activate', [TwoFactorController::class, 'activateTwoFactor'])->name('2fa.activate');
    Route::get('/validate', [TwoFactorController::class, 'validateTwoFactor'])->name('2fa.validate')->withoutMiddleware(TwoFactorAuthentication::class);
    Route::post('/validate', [TwoFactorController::class, 'validateTwoFactorCheck'])->name('2fa.validate.check')->middleware('throttle:authentication')->withoutMiddleware(TwoFactorAuthentication::class);
    Route::get('/lost-access', [TwoFactorController::class, 'recover'])->name('2fa.recover')->withoutMiddleware(TwoFactorAuthentication::class);
    Route::post('/lost-access', [TwoFactorController::class, 'recoverDeviceAccess'])->name('2fa.recover.access')->middleware('throttle:authentication')->withoutMiddleware(TwoFactorAuthentication::class);
});

Route::middleware('guest')->prefix('auth')->group(function () {

    Route::get('login', [AuthController::class, 'login'])
    ->name('login');

    Route::post('login', [AuthController::class, 'authenticate'])
    ->name('login.authenticate')->middleware('throttle:authentication');

    Route::get('register', [AuthController::class, 'register'])
    ->name('register');

    Route::post('register', [AuthController::class, 'store'])
    ->name('register.store');

    Route::get('forgot-password', [AuthController::class, 'forgotPassword'])
    ->name('forgot-password');

    Route::post('forgot-password', [AuthController::class, 'sendPasswordResetEmail'])
    ->name('forgot-password.send-email')->middleware('throttle:authentication');;

    Route::get('reset-password/{token}', [AuthController::class, 'resetPassword'])
    ->name('reset-password');

    Route::post('reset-password/{token}', [AuthController::class, 'resetPasswordUpdate'])
    ->name('reset-password.update');
});
