<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\SettingsController;
use App\Http\Controllers\Admin\EmailsController;
use App\Http\Controllers\Admin\CoreController;
use App\Http\Controllers\Admin\ThemeController;
use App\Http\Controllers\Admin\Overview\OverviewController;
use App\Http\Controllers\Admin\GroupController;
use App\Http\Controllers\Admin\PagesController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\PermissionController;
use App\Http\Controllers\Admin\ModulesController;
use App\Http\Controllers\Admin\ServicesController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\PackagesController;
use App\Http\Controllers\Admin\CouponController;
use App\Http\Controllers\Admin\GatewayController;
use App\Http\Controllers\Admin\PaymentsController;
use App\Http\Controllers\Admin\OrdersController;
use App\Http\Controllers\Admin\MarketplaceController;
use App\Http\Controllers\Admin\LogsController;
use App\Http\Controllers\Admin\PunishmentController;
use App\Http\Controllers\Admin\ArticlesController;
use App\Http\Controllers\Admin\UpdatesController;

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Using [CheckPermission::class] or 'permission' - this will check for a perm that is equal to the route name
// Using [CheckPermission::class . ':root'] or 'permission:root' - it will ignore the route name and check the perm which is written after ":", in this example we check if the user has root permissions. This method is recommended for route groups
Route::middleware(['auth', 'permission:admin.view'])->group(function () {
    Route::get('/', [OverviewController::class, 'index'])->name('admin.view')->middleware('permission');
    Route::get('/change/order/{id}/{model}/{direction}', [OverviewController::class, 'changeOrder'])->name('admin.change-order')->middleware('permission');
    Route::get('/admin-toggle-mode', [OverviewController::class, 'modeToggle'])->name('admin.toggle-mode')->middleware('permission');

    Route::get('/setup', [CoreController::class, 'setup'])->name('admin.setup');

    // users
    Route::get('/users/search', [UserController::class, 'search'])->name('admin.user.search')->middleware('permission');
    Route::prefix('/users/{user}')->group(function () {
        Route::post('/update-avatar', [UserController::class, 'uploadProfilePicture'])->name('admin.user.update-avatar')->middleware('permission');
        Route::post('/update-balance', [UserController::class, 'updateBalance'])->name('users.update-balance')->middleware('permission');
        Route::get('/email-password-reset', [UserController::class, 'emailPasswordReset'])->name('users.email-password-reset')->middleware('permission');
        Route::get('/reset-avatar', [UserController::class, 'resetProfilePicture'])->name('admin.user.reset-avatar')->middleware('permission');
        Route::get('/{device}/revoke', [UserController::class, 'revokeDevice'])->name('admin.user.devices.revoke')->middleware('permission');
        Route::get('/{device}/delete', [UserController::class, 'destroyDevice'])->name('admin.user.devices.destroy')->middleware('permission');
        Route::get('/orders', [UserController::class, 'orders'])->name('admin.user.orders')->middleware('permission');
        Route::get('/invoices', [UserController::class, 'invoices'])->name('admin.user.invoices')->middleware('permission');
        Route::get('/emails', [UserController::class, 'emails'])->name('admin.user.emails')->middleware('permission');
        Route::get('/tickets', [UserController::class, 'tickets'])->name('admin.user.tickets')->middleware('permission');
        Route::get('/punishments', [UserController::class, 'punishments'])->name('admin.user.punishments')->middleware('permission');
        Route::post('/punishments', [UserController::class, 'createPunishment'])->name('admin.user.punishments.create')->middleware('permission');
        Route::get('/punishments/{id}/delete', [UserController::class, 'destroyPunishment'])->name('admin.user.punishments.delete')->middleware('permission');
        Route::get('/activity', [UserController::class, 'activity'])->name('admin.user.activity')->middleware('permission');
        Route::get('/activate', [UserController::class, 'activate'])->name('admin.user.activate')->middleware('permission');
        Route::get('/verify-user', [UserController::class, 'verify'])->name('admin.user.verify')->middleware('permission');
        Route::get('/impersonate', [UserController::class, 'impersonate'])->name('admin.user.impersonate')->middleware('permission');
        Route::get('/impersonate-exit', [UserController::class, 'stopImpersonate'])->name('admin.user.impersonate.exit')->withoutMiddleware('permission:admin.view');
        Route::get('/delete', [UserController::class, 'destroy'])->name('admin.users.destroy')->middleware('permission');
    });

    // Payments
    Route::prefix('/payments')->group(function () {
        Route::get('/search', [PaymentsController::class, 'search'])->name('payments.search')->middleware('permission');
        Route::get('/create', [PaymentsController::class, 'create'])->name('payments.create')->middleware('permission');
        Route::post('/create', [PaymentsController::class, 'store'])->name('payments.store')->middleware('permission');
        Route::get('/{payment}/edit', [PaymentsController::class, 'edit'])->name('payments.edit')->middleware('permission');
        Route::post('/{payment}/edit', [PaymentsController::class, 'update'])->name('payments.update')->middleware('permission');
        Route::post('/{payment}/refund', [PaymentsController::class, 'refund'])->name('payments.refund')->middleware('permission');
        Route::post('/{payment}/complete', [PaymentsController::class, 'complete'])->name('payments.complete')->middleware('permission');
        Route::get('/subscriptions/{status}', [PaymentsController::class, 'subscriptions'])->name('payments.subscriptions')->middleware('permission');
        Route::get('/{status}', [PaymentsController::class, 'index'])->name('payments.index')->middleware('permission');
    });

    // Orders
    Route::prefix('/orders')->group(function () {
        Route::get('/create', [OrdersController::class, 'create'])->name('orders.create')->middleware('permission');
        Route::post('/create', [OrdersController::class, 'store'])->name('orders.store')->middleware('permission');

        Route::get('/{order}/edit', [OrdersController::class, 'edit'])->name('orders.edit')->middleware('permission');
        Route::post('/{order}/edit', [OrdersController::class, 'update'])->name('orders.update')->middleware('permission');
        Route::post('/{order}/extend', [OrdersController::class, 'extend'])->name('orders.extend')->middleware('permission');
        Route::post('/{order}/cancel', [OrdersController::class, 'cancel'])->name('orders.cancel')->middleware('permission');
        Route::get('/{order}/action/try-again', [OrdersController::class, 'tryAgain'])->name('orders.try-again')->middleware('permission');
        Route::get('/{order}/action/{action}', [OrdersController::class, 'action'])->name('orders.action')->middleware('permission');
        Route::get('/{status}', [OrdersController::class, 'index'])->name('orders.index')->middleware('permission');
        Route::get('/prices/{package}', [OrdersController::class, 'getPricesForPackage']);

        Route::get('/{order}/delete', [OrdersController::class, 'destroy'])->name('orders.destroy')->middleware('permission');
    });

    // themes
    Route::prefix('/themes')->group(function () {
        Route::get('/', [ThemeController::class, 'themes'])->name('admin.themes')->middleware('permission');
        Route::get('/activate/{theme}', [ThemeController::class, 'activate'])->name('admin.theme.activate')->middleware('permission');
        Route::get('/files/{folder}', [ThemeController::class, 'files'])->where('folder', '.*')->name('admin.theme.files')->middleware('permission');
        Route::get('/edit', [ThemeController::class, 'edit_file'])->name('admin.theme.files.edit')->middleware('permission');
        Route::any('/files/save', [ThemeController::class, 'save_file'])->name('admin.theme.file.save')->middleware('permission');
    });

    // Admin themes
    Route::prefix('/admin-themes')->group(function () {
        Route::get('/', [ThemeController::class, 'admin_themes'])->name('admin.admin_themes')->middleware('permission');
        Route::get('/activate/{theme}', [ThemeController::class, 'admin_activate'])->name('admin.admin_theme.activate')->middleware('permission');
    });

    // Updates
    Route::prefix('/updates')->group(function () {
        Route::get('/', [UpdatesController::class, 'index'])->name('updates.index')->middleware('permission');
        Route::get('/{version}/install/{type?}', [UpdatesController::class, 'install'])->name('updates.install')->middleware('permission');
        Route::get('/update-progress', [UpdatesController::class, 'trackProgress'])->name('updates.progress');
    });

    // Punishments
    Route::prefix('/punishments')->group(function () {
        Route::get('/bans', [PunishmentController::class, 'bans'])->name('admin.bans.index')->middleware('permission');
        Route::get('/warnings', [PunishmentController::class, 'warnings'])->name('admin.warnings.index')->middleware('permission');
        Route::get('/{punishment}/unban', [PunishmentController::class, 'unban'])->name('admin.bans.unban')->middleware('permission');
        Route::get('/{punishment}/delete', [PunishmentController::class, 'destroy'])->name('admin.bans.destroy')->middleware('permission');
    });

    Route::prefix('/settings')->group(function () {
        Route::get('/general', [SettingsController::class, 'general'])->name('admin.settings')->middleware('permission');
        Route::get('/seo', [SettingsController::class, 'seo'])->name('admin.seo')->middleware('permission');
        Route::get('/taxes', [SettingsController::class, 'taxes'])->name('admin.taxes')->middleware('permission');
        Route::get('/registrations', [SettingsController::class, 'registrations'])->name('admin.registrations')->middleware('permission');
        Route::get('/oauth', [SettingsController::class, 'oauth'])->name('admin.oauth')->middleware('permission');
        Route::get('/captcha', [SettingsController::class, 'captcha'])->name('admin.captcha')->middleware('permission');
        Route::get('/maintenance', [SettingsController::class, 'maintenance'])->name('admin.maintenance')->middleware('permission');
        Route::get('/portal', [SettingsController::class, 'portal'])->name('admin.settings.portal')->middleware('permission');
        Route::get('/theme', [SettingsController::class, 'theme'])->name('admin.settings.theme')->middleware('permission');
        Route::any('/store', [SettingsController::class, 'store'])->name('admin.settings.store')->middleware('permission');
    });

    // Emails
    Route::prefix('/emails')->group(function () {
        Route::get('/', [EmailsController::class, 'history'])->name('emails.history')->middleware('permission');
        Route::post('/send', [EmailsController::class, 'sendEmail'])->name('emails.send')->middleware('permission');
        Route::get('/configure', [EmailsController::class, 'configure'])->name('emails.configure')->middleware('permission');
        Route::get('/send-test', [EmailsController::class, 'testMail'])->name('emails.test')->middleware('permission');
        Route::get('/messages', [EmailsController::class, 'messages'])->name('emails.messages')->middleware('permission');
        Route::get('/templates', [EmailsController::class, 'templates'])->name('emails.templates')->middleware('permission');
        Route::get('/{email}/resend', [EmailsController::class, 'resend'])->name('emails.resend')->middleware('permission');
    });

    Route::prefix('/logs')->group(function () {
        Route::get('/', [LogsController::class, 'index'])->name('logs.index')->middleware('permission');
    });

    Route::prefix('/marketplace')->group(function () {
        Route::get('/', [MarketplaceController::class, 'index'])->name('admin.marketplace')->middleware('permission');
        Route::get('/view/{resource}', [MarketplaceController::class, 'view'])->name('admin.marketplace.view')->middleware('permission');
        Route::get('install/{resource_id}/{version_id}', [OverviewController::class, 'resourceInstall'])->name('admin.resource.install')->middleware('permission');
    });

    Route::prefix('/services')->group(function () {
        Route::get('/', [ServicesController::class, 'index'])->name('services.view')->middleware('permission');
        Route::get('/{service}/config', [ServicesController::class, 'config'])->name('services.config')->middleware('permission');
        Route::post('/{service}/store', [ServicesController::class, 'store'])->name('services.store')->middleware('permission');
        Route::get('/{service}/test-connection', [ServicesController::class, 'testConnection'])->name('services.test-connection')->middleware('permission');
    });

    Route::prefix('/modules')->group(function () {
        Route::get('/', [ModulesController::class, 'index'])->name('modules.view')->middleware('permission');
        Route::get('/{module}/toggle', [ModulesController::class, 'toggleStatus'])->name('modules.toggle')->middleware('permission');
    });

    Route::prefix('/packages/prices')->group(function () {
        Route::post('/{package}/create', [PackagesController::class, 'createPrice'])->name('package_price.create')->middleware('permission');
        Route::post('/{price}/update', [PackagesController::class, 'updatePrice'])->name('package_price.update')->middleware('permission');
        Route::get('/{price}/delete', [PackagesController::class, 'deletePrice'])->name('package_price.delete')->middleware('permission');
    });

    Route::prefix('/packages/emails')->group(function () {
        Route::post('/{package}/create', [PackagesController::class, 'createEmail'])->name('packages.emails.create')->middleware('permission');
        Route::post('/{email}/update', [PackagesController::class, 'updateEmail'])->name('packages.emails.update')->middleware('permission');
        Route::get('/{email}/delete', [PackagesController::class, 'deleteEmail'])->name('packages.emails.delete')->middleware('permission');
    });

    Route::prefix('/packages/webhooks')->group(function () {
        Route::post('/{package}/create', [PackagesController::class, 'createWebhook'])->name('packages.webhooks.create')->middleware('permission');
        Route::post('/{webhook}/update', [PackagesController::class, 'updateWebhook'])->name('packages.webhooks.update')->middleware('permission');
        Route::get('/{webhook}/delete', [PackagesController::class, 'deleteWebhook'])->name('packages.webhooks.delete')->middleware('permission');
    });

    Route::prefix('/packages/{package}')->group(function () {
        Route::get('/features', [PackagesController::class, 'editFeatures'])->name('packages.features')->middleware('permission');
        Route::get('/prices', [PackagesController::class, 'editPrices'])->name('packages.prices')->middleware('permission');
        Route::get('/service', [PackagesController::class, 'editService'])->name('packages.service')->middleware('permission');
        Route::get('/emails', [PackagesController::class, 'editEmails'])->name('packages.emails')->middleware('permission');
        Route::get('/webhooks', [PackagesController::class, 'editWebhooks'])->name('packages.webhooks')->middleware('permission');
        Route::get('/links', [PackagesController::class, 'editLinks'])->name('packages.links')->middleware('permission');

        Route::post('/feature/create', [PackagesController::class, 'createFeature'])->name('package.create-feature')->middleware('permission');
        Route::get('/{feature}/move/{direction}', [PackagesController::class, 'moveFeature'])->name('package.move-feature')->middleware('permission');
        Route::get('/{feature}/delete', [PackagesController::class, 'destroyFeature'])->name('package.destroy-feature')->middleware('permission');
        Route::post('/update-service-data', [PackagesController::class, 'updateServiceData'])->name('package.update-service')->middleware('permission');
    });

    Route::get('/packages/update-service/{package}/{service}', [PackagesController::class, 'updateService'])->name('packages.update-service')->middleware('permission');
    Route::get('/packages/clone/{package}', [PackagesController::class, 'clonePackage'])->name('packages.clone')->middleware('permission');

    Route::get('/permissions/import', [PermissionController::class, 'import'])->name('permissions.import')->middleware('permission');
    Route::get('/gateways/toggle/{gateway}', [GatewayController::class, 'toggle'])->name('gateways.toggle')->middleware('permission');
    Route::get('/gateways/default/{gateway}', [GatewayController::class, 'default'])->name('gateways.default')->middleware('permission');
    Route::resource('gateways', GatewayController::class)->middleware('permission');
    Route::resource('categories', CategoryController::class)->middleware('permission');
    Route::resource('packages', PackagesController::class)->middleware('permission');
    Route::resource('coupons', CouponController::class)->middleware('permission');
    Route::resource('users', UserController::class)->middleware('permission');
    Route::get('/groups/users/{group}', [GroupController::class, 'showUsers'])->name('groups.users')->middleware('permission');
    Route::resource('groups', GroupController::class)->middleware('permission');
    Route::resource('permissions', PermissionController::class)->middleware('permission');

    Route::get('/pages/translation/{id}', [PagesController::class, 'translation'])->name('pages.translation')->middleware('permission');
    Route::get('/pages/translation/edit/{id}/{locale?}', [PagesController::class, 'translationEdit'])->name('pages.translation.edit')->middleware('permission');
    Route::put('/pages/translation/store/{id}', [PagesController::class, 'translationStore'])->name('pages.translation.store')->middleware('permission');
    Route::delete('/pages/translation/{translation}', [PagesController::class, 'translationDestroy'])->name('pages.translation.destroy')->middleware('permission');
    Route::resource('pages', PagesController::class)->middleware('permission');

    Route::get('/articles/translation/{id}', [ArticlesController::class, 'translation'])->name('articles.translation')->middleware('permission');
    Route::get('/articles/translation/edit/{id}/{locale?}', [ArticlesController::class, 'translationEdit'])->name('articles.translation.edit')->middleware('permission');
    Route::put('/articles/translation/store/{id}', [ArticlesController::class, 'translationStore'])->name('articles.translation.store')->middleware('permission');
    Route::delete('/articles/translation/{translation}', [ArticlesController::class, 'translationDestroy'])->name('articles.translation.destroy')->middleware('permission');
    Route::resource('articles', ArticlesController::class)->middleware('permission');
});
