@extends('client.default.layouts.wrapper')
@section('title', 'Notifications')
@section('container')
    <div class="card">
        <div class="card-header">
            <h4>Notification History</h4>
            <div class="card-header-action">
                <a class="btn btn-primary" href="{{ route('notifications.mark-as-read') }}">
                    Mark All As Read
                </a>
            </div>
        </div>
        <div class="card-body">

            @if (Notification::where('user_id', auth()->user()->id)->count() >= 0)
                @includeIf(Theme::path('empty-state'), [
                    'title' => 'We couldn\'t find any data',
                    'description' => 'You have not yet received any notifications, please check back later.',
                ])
            @else
                <div class="table-responsive">
                    <table class="table table-striped" id="sortable-table">
                        <thead>
                            <tr>
                                <th class="text-center">

                                </th>
                                <th>Message</th>
                                <th>Actions</th>
                                <th>Sent by</th>
                                <th>Created</th>
                            </tr>
                        </thead>
                        <tbody class="ui-sortable">
                            @foreach ($notifications as $notificaiton)
                                <tr>
                                    <td>
                                        <div
                                            class="sort-handler ui-sortable-handle notification-icon {{ 'notification-' . $notificaiton->type }}">
                                            <div class="notification-icon">{!! $notificaiton->icon !!}</div>
                                        </div>
                                    </td>
                                    <td>{{ $notificaiton->message }}</td>
                                    <td>
                                        @if ($notificaiton->button_url !== null)
                                            <a href="{{ $notificaiton->button_url }}" class="btn btn-sm btn-dark">Take me
                                                there</a>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge badge-secondary">System</span>
                                    </td>
                                    <td>{{ $notificaiton->created_at->diffForHumans() }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
            {{ $notifications->links() }}
        </div>
    </div>
@endsection
