@extends('client.default.layouts.wrapper')

@section('css_libraries')
    <link rel="stylesheet" href="{{ asset(AdminTheme::assets('modules/summernote/summernote-bs4.css')) }}" />
    <link rel="stylesheet" href="{{ asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css')) }}">
@endsection

@section('js_libraries')
    <script src="{{ asset(AdminTheme::assets('modules/summernote/summernote-bs4.js')) }}"></script>
    <script src="{{ asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js')) }}"></script>
@endsection

@section('container')
    <h4 class="text-dark mb-3">Review & Checkout</h4>

    <div class="row">
        @php(
    $carts = auth()->user()->cart()->get(),
)
        <div class="col-12 col-md-8 col-lg-8">
            @if (empty($carts))
                <div class="card justify-content-center align-items-center" style="height: 320px;">
                    <i class="fas fa-boxes" style="font-size: 40px"></i>
                    <p class="lead mt-2">Your shopping cart is empty</p>
                    <a href="{{ route('admin.overview') }}" class="btn btn-primary">Start Shopping</a>
                </div>
            @else
                <div class="card">
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table" id="sortable-table">
                                <thead>
                                    <tr>
                                        <th class="text-center">
                                            <i class="fas fa-th"></i>
                                        </th>
                                        <th>Product</th>
                                        <th>Price / Cycle</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody class="ui-sortable">
                                    @foreach ($carts as $cart)
                                        <tr>
                                            <td>
                                                <div class="sort-handler ui-sortable-handle">
                                                    <i class="fas fa-th"></i>
                                                </div>
                                            </td>
                                            <td>
                                                <img alt="image" src="/storage/products/{{ $cart->package->icon }}"
                                                    class="rounded-circle" width="35" data-toggle="tooltip"
                                                    title="" data-original-title="{{ $cart->package->name }}" />
                                                {{ $cart->package->name }}
                                            </td>
                                            <td>
                                                <div class="dropdown">
                                                    <button class="btn btn-light dropdown-toggle" type="button"
                                                        id="dropdownMenuButton{{ $cart->price->id }}" data-toggle="dropdown"
                                                        aria-haspopup="true" aria-expanded="false">
                                                        ${{ $cart->price->price }}/{{ $cart->price->period }}
                                                    </button>
                                                    <div class="dropdown-menu"
                                                        aria-labelledby="dropdownMenuButton{{ $cart->price->id }}">
                                                        @foreach ($cart->package->prices()->get() as $price)
                                                            <a class="dropdown-item"
                                                                href="#">${{ $price->price }}/{{ $price->period }}</a>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            </td>
                                            <td><a href="#" class="btn btn-danger"><i
                                                        class="fa-solid fa-trash-can"></i></a></td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            @endif

            <h4 class="text-dark mb-3">Account Details</h4>
            @auth
                <div class="card author-box">
                    <div class="card-body">
                        <div class="">
                            <div class="author-box-name">
                                <a href="#">{{ auth()->user()->first_name . ' ' . auth()->user()->last_name }}</a>
                            </div>
                            <div class="author-box-job">
                                @foreach (auth()->user()->groups()->get() as $group)
                                    <span class="badge badge-secondary">{{ $group->name }}</span>
                                @endforeach
                            </div>
                            <div class="author-box-description">
                                <p>
                                    Petey MacGibbon <br>
                                    {{ auth()->user()->email }} <br>
                                    Waubesa Center
                                    Norfolk, Virginia, 54839
                                    United States <br>
                                </p>
                            </div>
                            <div class="w-100 d-sm-none"></div>
                            <div class="float-right mt-sm-0 mt-3">
                                <a href="/user/settings" class="btn btn-outline-secondary btn-sm">Edit</a>
                            </div>
                        </div>
                    </div>
                </div>
            @endauth

            @guest
                <div class="card">
                    <div class="card-body">
                        <div id="accordion">
                            <div class="accordion">
                                <div class="accordion-header collapsed" role="button" data-toggle="collapse"
                                    data-target="#panel-body-1" aria-expanded="false">
                                    <h4>Login with existing account</h4>
                                </div>
                                <div class="accordion-body collapse" id="panel-body-1" data-parent="#accordion" style="">
                                    <p class="mb-0">
                                    <form method="POST" action="{{ route('login') }}" class="needs-validation" novalidate="">
                                        @csrf
                                        <div class="form-group">
                                            <label for="email">Email</label>
                                            <input id="email" type="email" class="form-control" name="email"
                                                tabindex="1" required autofocus>
                                            <div class="invalid-feedback">
                                                Please fill in your email
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="d-block">
                                                <label for="password" class="control-label">Password</label>
                                                <div class="float-right">
                                                    <a href="auth-forgot-password.html" class="text-small">
                                                        Forgot Password?
                                                    </a>
                                                </div>
                                            </div>
                                            <input id="password" type="password" class="form-control" name="password"
                                                tabindex="2" required>
                                            <div class="invalid-feedback">
                                                please fill in your password
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" name="remember" class="custom-control-input"
                                                    tabindex="3" id="remember-me">
                                                <label class="custom-control-label" for="remember-me">Remember Me</label>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <button type="submit" onClick="load(this)"
                                                class="btn btn-primary btn-lg btn-block" tabindex="4">
                                                Login
                                            </button>
                                        </div>
                                    </form>
                                    </p>
                                </div>
                            </div>
                            <div class="accordion">
                                <div class="accordion-header" role="button" data-toggle="collapse"
                                    data-target="#panel-body-2" aria-expanded="true">
                                    <h4>Create a new account</h4>
                                </div>
                                <div class="accordion-body collapse show" id="panel-body-2" data-parent="#accordion"
                                    style="">
                                    <p class="mb-0">
                                    <form method="POST" action="#" class="needs-validation" novalidate="">
                                        @csrf

                                        <h2 class="section-title">Account Details</h2>

                                        <div class="row">
                                            <div class="form-group col-6">
                                                <label for="frist_name">First Name *</label>
                                                <input id="frist_name" type="text" class="form-control" name="first_name"
                                                    autofocus="">
                                            </div>
                                            <div class="form-group col-6">
                                                <label for="last_name">Last Name *</label>
                                                <input id="last_name" type="text" class="form-control" name="last_name">
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="email">Email *</label>
                                            <input id="email" type="email" class="form-control" name="email"
                                                tabindex="1" required autofocus>
                                            <div class="invalid-feedback">
                                                Please fill in your email
                                            </div>

                                        </div>

                                        <h2 class="section-title">Billing Address</h2>
                                        <div class="billing_address">

                                            <div class="row">
                                                <div class="form-group col-6">
                                                    <label for="company_name">Company Name (optional)</label>
                                                    <input type="text" class="form-control" name="company_name"
                                                        id="company_name" />
                                                </div>
                                                <div class="form-group col-6">
                                                    <label for="inputAddress">Address *</label>
                                                    <input type="text" class="form-control" name="address"
                                                        id="inputAddress" placeholder="1234 Main St" />
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="form-group col-8">
                                                    <label for="inputAddress2">Address 2</label>
                                                    <input type="text" class="form-control" name="address_2"
                                                        id="inputAddress2" placeholder="Apartment, studio, or floor" />
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label for="inputState">Country *</label>
                                                    <select id="inputState" class="form-control">
                                                        <option value="Afghanistan">Afghanistan</option>
                                                        <option value="Albania">Albania</option>
                                                        <option value="Algeria">Algeria</option>
                                                        <option value="American Samoa">American Samoa</option>
                                                        <option value="Andorra">Andorra</option>
                                                        <option value="Angola">Angola</option>
                                                        <option value="Anguilla">Anguilla</option>
                                                        <option value="Antartica">Antarctica</option>
                                                        <option value="Antigua and Barbuda">Antigua and Barbuda</option>
                                                        <option value="Argentina">Argentina</option>
                                                        <option value="Armenia">Armenia</option>
                                                        <option value="Aruba">Aruba</option>
                                                        <option value="Australia">Australia</option>
                                                        <option value="Austria">Austria</option>
                                                        <option value="Azerbaijan">Azerbaijan</option>
                                                        <option value="Bahamas">Bahamas</option>
                                                        <option value="Bahrain">Bahrain</option>
                                                        <option value="Bangladesh">Bangladesh</option>
                                                        <option value="Barbados">Barbados</option>
                                                        <option value="Belarus">Belarus</option>
                                                        <option value="Belgium">Belgium</option>
                                                        <option value="Belize">Belize</option>
                                                        <option value="Benin">Benin</option>
                                                        <option value="Bermuda">Bermuda</option>
                                                        <option value="Bhutan">Bhutan</option>
                                                        <option value="Bolivia">Bolivia</option>
                                                        <option value="Bosnia and Herzegowina">Bosnia and Herzegowina</option>
                                                        <option value="Botswana">Botswana</option>
                                                        <option value="Bouvet Island">Bouvet Island</option>
                                                        <option value="Brazil">Brazil</option>
                                                        <option value="British Indian Ocean Territory">British Indian Ocean
                                                            Territory</option>
                                                        <option value="Brunei Darussalam">Brunei Darussalam</option>
                                                        <option value="Bulgaria">Bulgaria</option>
                                                        <option value="Burkina Faso">Burkina Faso</option>
                                                        <option value="Burundi">Burundi</option>
                                                        <option value="Cambodia">Cambodia</option>
                                                        <option value="Cameroon">Cameroon</option>
                                                        <option value="Canada">Canada</option>
                                                        <option value="Cape Verde">Cape Verde</option>
                                                        <option value="Cayman Islands">Cayman Islands</option>
                                                        <option value="Central African Republic">Central African Republic
                                                        </option>
                                                        <option value="Chad">Chad</option>
                                                        <option value="Chile">Chile</option>
                                                        <option value="China">China</option>
                                                        <option value="Christmas Island">Christmas Island</option>
                                                        <option value="Cocos Islands">Cocos (Keeling) Islands</option>
                                                        <option value="Colombia">Colombia</option>
                                                        <option value="Comoros">Comoros</option>
                                                        <option value="Congo">Congo</option>
                                                        <option value="Congo">Congo, the Democratic Republic of the</option>
                                                        <option value="Cook Islands">Cook Islands</option>
                                                        <option value="Costa Rica">Costa Rica</option>
                                                        <option value="Cota D'Ivoire">Cote d'Ivoire</option>
                                                        <option value="Croatia">Croatia (Hrvatska)</option>
                                                        <option value="Cuba">Cuba</option>
                                                        <option value="Cyprus">Cyprus</option>
                                                        <option value="Czech Republic">Czech Republic</option>
                                                        <option value="Denmark">Denmark</option>
                                                        <option value="Djibouti">Djibouti</option>
                                                        <option value="Dominica">Dominica</option>
                                                        <option value="Dominican Republic">Dominican Republic</option>
                                                        <option value="East Timor">East Timor</option>
                                                        <option value="Ecuador">Ecuador</option>
                                                        <option value="Egypt">Egypt</option>
                                                        <option value="El Salvador">El Salvador</option>
                                                        <option value="Equatorial Guinea">Equatorial Guinea</option>
                                                        <option value="Eritrea">Eritrea</option>
                                                        <option value="Estonia">Estonia</option>
                                                        <option value="Ethiopia">Ethiopia</option>
                                                        <option value="Falkland Islands">Falkland Islands (Malvinas)</option>
                                                        <option value="Faroe Islands">Faroe Islands</option>
                                                        <option value="Fiji">Fiji</option>
                                                        <option value="Finland">Finland</option>
                                                        <option value="France">France</option>
                                                        <option value="France Metropolitan">France, Metropolitan</option>
                                                        <option value="French Guiana">French Guiana</option>
                                                        <option value="French Polynesia">French Polynesia</option>
                                                        <option value="French Southern Territories">French Southern Territories
                                                        </option>
                                                        <option value="Gabon">Gabon</option>
                                                        <option value="Gambia">Gambia</option>
                                                        <option value="Georgia">Georgia</option>
                                                        <option value="Germany">Germany</option>
                                                        <option value="Ghana">Ghana</option>
                                                        <option value="Gibraltar">Gibraltar</option>
                                                        <option value="Greece">Greece</option>
                                                        <option value="Greenland">Greenland</option>
                                                        <option value="Grenada">Grenada</option>
                                                        <option value="Guadeloupe">Guadeloupe</option>
                                                        <option value="Guam">Guam</option>
                                                        <option value="Guatemala">Guatemala</option>
                                                        <option value="Guinea">Guinea</option>
                                                        <option value="Guinea-Bissau">Guinea-Bissau</option>
                                                        <option value="Guyana">Guyana</option>
                                                        <option value="Haiti">Haiti</option>
                                                        <option value="Heard and McDonald Islands">Heard and Mc Donald Islands
                                                        </option>
                                                        <option value="Holy See">Holy See (Vatican City State)</option>
                                                        <option value="Honduras">Honduras</option>
                                                        <option value="Hong Kong">Hong Kong</option>
                                                        <option value="Hungary">Hungary</option>
                                                        <option value="Iceland">Iceland</option>
                                                        <option value="India">India</option>
                                                        <option value="Indonesia">Indonesia</option>
                                                        <option value="Iran">Iran (Islamic Republic of)</option>
                                                        <option value="Iraq">Iraq</option>
                                                        <option value="Ireland">Ireland</option>
                                                        <option value="Israel">Israel</option>
                                                        <option value="Italy">Italy</option>
                                                        <option value="Jamaica">Jamaica</option>
                                                        <option value="Japan">Japan</option>
                                                        <option value="Jordan">Jordan</option>
                                                        <option value="Kazakhstan">Kazakhstan</option>
                                                        <option value="Kenya">Kenya</option>
                                                        <option value="Kiribati">Kiribati</option>
                                                        <option value="Democratic People's Republic of Korea">Korea, Democratic
                                                            People's Republic of</option>
                                                        <option value="Korea">Korea, Republic of</option>
                                                        <option value="Kuwait">Kuwait</option>
                                                        <option value="Kyrgyzstan">Kyrgyzstan</option>
                                                        <option value="Lao">Lao People's Democratic Republic</option>
                                                        <option value="Latvia">Latvia</option>
                                                        <option value="Lebanon">Lebanon</option>
                                                        <option value="Lesotho">Lesotho</option>
                                                        <option value="Liberia">Liberia</option>
                                                        <option value="Libyan Arab Jamahiriya">Libyan Arab Jamahiriya</option>
                                                        <option value="Liechtenstein">Liechtenstein</option>
                                                        <option value="Lithuania">Lithuania</option>
                                                        <option value="Luxembourg">Luxembourg</option>
                                                        <option value="Macau">Macau</option>
                                                        <option value="Macedonia">Macedonia, The Former Yugoslav Republic of
                                                        </option>
                                                        <option value="Madagascar">Madagascar</option>
                                                        <option value="Malawi">Malawi</option>
                                                        <option value="Malaysia">Malaysia</option>
                                                        <option value="Maldives">Maldives</option>
                                                        <option value="Mali">Mali</option>
                                                        <option value="Malta">Malta</option>
                                                        <option value="Marshall Islands">Marshall Islands</option>
                                                        <option value="Martinique">Martinique</option>
                                                        <option value="Mauritania">Mauritania</option>
                                                        <option value="Mauritius">Mauritius</option>
                                                        <option value="Mayotte">Mayotte</option>
                                                        <option value="Mexico">Mexico</option>
                                                        <option value="Micronesia">Micronesia, Federated States of</option>
                                                        <option value="Moldova">Moldova, Republic of</option>
                                                        <option value="Monaco">Monaco</option>
                                                        <option value="Mongolia">Mongolia</option>
                                                        <option value="Montserrat">Montserrat</option>
                                                        <option value="Morocco">Morocco</option>
                                                        <option value="Mozambique">Mozambique</option>
                                                        <option value="Myanmar">Myanmar</option>
                                                        <option value="Namibia">Namibia</option>
                                                        <option value="Nauru">Nauru</option>
                                                        <option value="Nepal">Nepal</option>
                                                        <option value="Netherlands">Netherlands</option>
                                                        <option value="Netherlands Antilles">Netherlands Antilles</option>
                                                        <option value="New Caledonia">New Caledonia</option>
                                                        <option value="New Zealand">New Zealand</option>
                                                        <option value="Nicaragua">Nicaragua</option>
                                                        <option value="Niger">Niger</option>
                                                        <option value="Nigeria">Nigeria</option>
                                                        <option value="Niue">Niue</option>
                                                        <option value="Norfolk Island">Norfolk Island</option>
                                                        <option value="Northern Mariana Islands">Northern Mariana Islands
                                                        </option>
                                                        <option value="Norway">Norway</option>
                                                        <option value="Oman">Oman</option>
                                                        <option value="Pakistan">Pakistan</option>
                                                        <option value="Palau">Palau</option>
                                                        <option value="Panama">Panama</option>
                                                        <option value="Papua New Guinea">Papua New Guinea</option>
                                                        <option value="Paraguay">Paraguay</option>
                                                        <option value="Peru">Peru</option>
                                                        <option value="Philippines">Philippines</option>
                                                        <option value="Pitcairn">Pitcairn</option>
                                                        <option value="Poland">Poland</option>
                                                        <option value="Portugal">Portugal</option>
                                                        <option value="Puerto Rico">Puerto Rico</option>
                                                        <option value="Qatar">Qatar</option>
                                                        <option value="Reunion">Reunion</option>
                                                        <option value="Romania">Romania</option>
                                                        <option value="Russia">Russian Federation</option>
                                                        <option value="Rwanda">Rwanda</option>
                                                        <option value="Saint Kitts and Nevis">Saint Kitts and Nevis</option>
                                                        <option value="Saint LUCIA">Saint LUCIA</option>
                                                        <option value="Saint Vincent">Saint Vincent and the Grenadines</option>
                                                        <option value="Samoa">Samoa</option>
                                                        <option value="San Marino">San Marino</option>
                                                        <option value="Sao Tome and Principe">Sao Tome and Principe</option>
                                                        <option value="Saudi Arabia">Saudi Arabia</option>
                                                        <option value="Senegal">Senegal</option>
                                                        <option value="Seychelles">Seychelles</option>
                                                        <option value="Sierra">Sierra Leone</option>
                                                        <option value="Singapore">Singapore</option>
                                                        <option value="Slovakia">Slovakia (Slovak Republic)</option>
                                                        <option value="Slovenia">Slovenia</option>
                                                        <option value="Solomon Islands">Solomon Islands</option>
                                                        <option value="Somalia">Somalia</option>
                                                        <option value="South Africa">South Africa</option>
                                                        <option value="South Georgia">South Georgia and the South Sandwich
                                                            Islands</option>
                                                        <option value="Span">Spain</option>
                                                        <option value="SriLanka">Sri Lanka</option>
                                                        <option value="St. Helena">St. Helena</option>
                                                        <option value="St. Pierre and Miguelon">St. Pierre and Miquelon
                                                        </option>
                                                        <option value="Sudan">Sudan</option>
                                                        <option value="Suriname">Suriname</option>
                                                        <option value="Svalbard">Svalbard and Jan Mayen Islands</option>
                                                        <option value="Swaziland">Swaziland</option>
                                                        <option value="Sweden">Sweden</option>
                                                        <option value="Switzerland">Switzerland</option>
                                                        <option value="Syria">Syrian Arab Republic</option>
                                                        <option value="Taiwan">Taiwan, Province of China</option>
                                                        <option value="Tajikistan">Tajikistan</option>
                                                        <option value="Tanzania">Tanzania, United Republic of</option>
                                                        <option value="Thailand">Thailand</option>
                                                        <option value="Togo">Togo</option>
                                                        <option value="Tokelau">Tokelau</option>
                                                        <option value="Tonga">Tonga</option>
                                                        <option value="Trinidad and Tobago">Trinidad and Tobago</option>
                                                        <option value="Tunisia">Tunisia</option>
                                                        <option value="Turkey">Turkey</option>
                                                        <option value="Turkmenistan">Turkmenistan</option>
                                                        <option value="Turks and Caicos">Turks and Caicos Islands</option>
                                                        <option value="Tuvalu">Tuvalu</option>
                                                        <option value="Uganda">Uganda</option>
                                                        <option value="Ukraine">Ukraine</option>
                                                        <option value="United Arab Emirates">United Arab Emirates</option>
                                                        <option value="United Kingdom">United Kingdom</option>
                                                        <option value="United States">United States</option>
                                                        <option value="United States Minor Outlying Islands">United States
                                                            Minor Outlying Islands</option>
                                                        <option value="Uruguay">Uruguay</option>
                                                        <option value="Uzbekistan">Uzbekistan</option>
                                                        <option value="Vanuatu">Vanuatu</option>
                                                        <option value="Venezuela">Venezuela</option>
                                                        <option value="Vietnam">Viet Nam</option>
                                                        <option value="Virgin Islands (British)">Virgin Islands (British)
                                                        </option>
                                                        <option value="Virgin Islands (U.S)">Virgin Islands (U.S.)</option>
                                                        <option value="Wallis and Futana Islands">Wallis and Futuna Islands
                                                        </option>
                                                        <option value="Western Sahara">Western Sahara</option>
                                                        <option value="Yemen">Yemen</option>
                                                        <option value="Serbia">Serbia</option>
                                                        <option value="Zambia">Zambia</option>
                                                        <option value="Zimbabwe">Zimbabwe</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="form-row">
                                                <div class="form-group col-md-6">
                                                    <label for="inputCity">City *</label>
                                                    <input type="text" class="form-control" name="city"
                                                        id="inputCity" />
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label for="inputState">State / Province*</label>
                                                    <input type="text" class="form-control" name="province"
                                                        id="inputState" />
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label for="inputZip">Zip *</label>
                                                    <input type="text" class="form-control" name="zip_code"
                                                        id="inputZip" />
                                                </div>
                                            </div>
                                        </div>

                                        <h2 class="section-title">Security</h2>
                                        <div class="row">
                                            <div class="form-group col-6">
                                                <label for="password">Password *</label>
                                                <input type="text" class="form-control" name="password" id="password" />
                                                <button type="button" data-toggle="modal"
                                                    data-target="#exampleModal"class="btn btn-icon icon-left btn-secondary mt-2"><i
                                                        class="fa-solid fa-rotate"></i> Generate</button>
                                            </div>
                                            <div class="form-group col-6">
                                                <label for="inputAddress">Confirm Password *</label>
                                                <input type="text" class="form-control" name="confirm_password"
                                                    id="confirm_password" />
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <button type="submit" onClick="load(this)"
                                                class="btn btn-primary btn-lg btn-block" tabindex="4">
                                                Login
                                            </button>
                                        </div>
                                    </form>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endguest


            <form action="{{ route('payment.process') }}" method="POST">
                @csrf
                <h4 class="text-dark mb-3">Payment Method</h4>
                <div class="card">
                    <div class="card-body">
                        <div class="mt-3 mb-3">
                            <select class="form-control select2 select2-hidden-accessible" name="gateway" tabindex="-1"
                                aria-hidden="true" required>
                                @foreach (App\Models\Gateways\Gateway::getActive() as $gateway)
                                    <option value="{{ $gateway->id }}">{{ $gateway->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                <h4 class="text-dark mb-3">Additional Notes</h4>
                <div class="form-group">
                    <textarea class="form-control"></textarea>
                </div>


        </div>

        <div class="col-12 col-md-4 col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h3>Cart Summary</h3>
                </div>
                <div class="card-body">
                    <div class="list-item">
                        <p class="text-dark mb-2 d-flex justify-content-between">Subtotal <span>$0.00</span></p>
                        <hr>
                        <p class="text-dark mb-2 d-flex justify-content-between">Monthly <span>$0.00</span></p>
                        <p class="text-dark mb-2 d-flex justify-content-between">Setup Fee <span>$0.00</span></p>
                        <hr>
                        <p class="text-dark">Total due today</p>
                        <h2 class="text-dark">10</h2>
                    </div>
                </div>
                <div class="card-footer text-right">
                    <button type="submit" class="btn btn-primary btn-lg btn-block">Complete Checkout</button>
                </div>
                </form>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="form-group">
                        <label>Coupon Code</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <div class="input-group-text">
                                    <i class="fa-solid fa-tag"></i>
                                </div>
                            </div>
                            <input type="text" class="form-control">
                        </div>
                    </div>
                    <a href="#" class="btn btn-sm btn-primary">Apply</a>
                </div>
            </div>
        </div>
    </div>
@endsection
