@extends(AdminTheme::wrapper(), ['title' => __('admin.packages'), 'keywords' => 'WemX Dashboard, WemX Panel'])

@section('css_libraries')
    <link rel="stylesheet" href="{{ asset(AdminTheme::assets('modules/wd/123-bs4.css')) }}" />
@endsection

@section('container')

                                <!-- Modal -->
                                <div class="modal fade" id="IconModal" tabindex="-1" role="dialog" aria-labelledby="IconModalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-lg" role="document">
                                    <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="IconModalLabel">Select Icon</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <div class="row">
                                            @foreach(config('utils.icons') as $icon)
                                                <div class="col-1 mb-4">
                                                    <div class="bx-md d-flex justify-content-center" style="cursor: pointer;" onclick='setIcon("{{ $icon }}")'>
                                                        {!! $icon !!}
                                                    </div>
                                                </div>
                                            @endforeach
                                            <div class="form-group col-md-12 col-12">
                                                <label for="description">Icon Font</label>
                                                <input type="text" name="description" id="custom-icon" value="<i class='bx bxs-check-shield' ></i>"
                                                    class="form-control" value="" required="" />
                                                <small>You can find custom icons on <a target="_blank" href="https://boxicons.com/">BoxIcons</a> - Choose icon -> font -> copy (svg format is supported, make sure to add fill="currentcolor")</small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                        <button type="button" onclick="setFeatureIcon()" class="btn btn-primary" data-dismiss="modal">Use Icon</button>
                                    </div>
                                    </div>
                                </div>

                                </div>
                                <hr>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-striped" id="sortable-table">
                                            <thead>
                                                <tr>
                                                    <th>Icon</th>
                                                    <th>Feature</th>
                                                    <th>Order ID</th>
                                                    <th class="text-right">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody class="ui-sortable">
                                                @foreach($package->features()->orderBy('order', 'desc')->get() as $feature)
                                                <tr>
                                                    <td><span class='bx-sm text-primary'>{!! $feature->icon !!}</span></td>
                                                    <td class="align-middle">
                                                        {{ $feature->description }}
                                                    </td>
                                                    <td class="align-middle">
                                                        {{ $feature->order }}
                                                    </td>
                                                    <td class="text-right">
                                                        <a href="{{ route('package.move-feature', ['package' => $package->id, 'feature' => $feature->id, 'direction' => 'up']) }}" class="btn btn-primary"><i class="fas fa-solid fa-caret-up"></i></a>
                                                        <a href="{{ route('package.move-feature', ['package' => $package->id, 'feature' => $feature->id, 'direction' => 'down']) }}" class="btn btn-primary"><i class="fas fa-solid fa-caret-down"></i></a>
                                                        <a href="{{ route('package.destroy-feature', ['package' => $package->id, 'feature' => $feature->id]) }}" class="btn btn-danger"><i class="fas fa-solid fa-trash"></i></a>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>   
@endsection
