<?php

namespace App\Providers;

use App\Facades\AdminTheme;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Blade;
use App\Facades\Theme;
use Illuminate\Support\Facades\URL;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {

        if(env('FORCE_HTTPS', false)) {
            URL::forceScheme('https');
        }

        // define @settings('key') directive
        Blade::directive('settings', function ($key, $default = null) {
            return "<?php echo App\\Models\\Settings::get({$key}, {$default}); ?>";
        });

        // create @admin directive
        Blade::if('admin', function () {
            return auth()->check() && auth()->user()->is_admin();
        });

        // define theme components
        $this->app->booted(function () {
            Theme::registerComponents();
            AdminTheme::registerComponents();
        });
    }


}
